/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.samples.SampleConfiguration;
import io.aeron.samples.SamplesUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SigInt;

public class Pong {
    private static final int PING_STREAM_ID = SampleConfiguration.PING_STREAM_ID;
    private static final int PONG_STREAM_ID = SampleConfiguration.PONG_STREAM_ID;
    private static final int FRAME_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final String PING_CHANNEL = SampleConfiguration.PING_CHANNEL;
    private static final String PONG_CHANNEL = SampleConfiguration.PONG_CHANNEL;
    private static final boolean INFO_FLAG = SampleConfiguration.INFO_FLAG;
    private static final boolean EMBEDDED_MEDIA_DRIVER = SampleConfiguration.EMBEDDED_MEDIA_DRIVER;
    private static final boolean EXCLUSIVE_PUBLICATIONS = SampleConfiguration.EXCLUSIVE_PUBLICATIONS;
    private static final IdleStrategy PING_HANDLER_IDLE_STRATEGY = new BusySpinIdleStrategy();

    public static void main(String[] args) {
        MediaDriver driver = EMBEDDED_MEDIA_DRIVER ? MediaDriver.launchEmbedded() : null;
        Aeron.Context ctx = new Aeron.Context();
        if (EMBEDDED_MEDIA_DRIVER) {
            ctx.aeronDirectoryName(driver.aeronDirectoryName());
        }
        if (INFO_FLAG) {
            ctx.availableImageHandler(SamplesUtil::printAvailableImage);
            ctx.unavailableImageHandler(SamplesUtil::printUnavailableImage);
        }
        BusySpinIdleStrategy idleStrategy = new BusySpinIdleStrategy();
        System.out.println("Subscribing Ping at " + PING_CHANNEL + " on stream id " + PING_STREAM_ID);
        System.out.println("Publishing Pong at " + PONG_CHANNEL + " on stream id " + PONG_STREAM_ID);
        System.out.println("Using exclusive publications " + EXCLUSIVE_PUBLICATIONS);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        try (Aeron aeron = Aeron.connect(ctx);
             Subscription subscription = aeron.addSubscription(PING_CHANNEL, PING_STREAM_ID);
             Publication publication = EXCLUSIVE_PUBLICATIONS ? aeron.addExclusivePublication(PONG_CHANNEL, PONG_STREAM_ID) : aeron.addPublication(PONG_CHANNEL, PONG_STREAM_ID);){
            BufferClaim bufferClaim = new BufferClaim();
            FragmentHandler fragmentHandler = (buffer, offset, length, header) -> Pong.pingHandler(bufferClaim, publication, buffer, offset, length, header);
            while (running.get()) {
                idleStrategy.idle(subscription.poll(fragmentHandler, FRAME_COUNT_LIMIT));
            }
            System.out.println("Shutting down...");
        }
        CloseHelper.close(driver);
    }

    private static void pingHandler(BufferClaim bufferClaim, Publication pongPublication, DirectBuffer buffer, int offset, int length, Header header) {
        PING_HANDLER_IDLE_STRATEGY.reset();
        while (pongPublication.tryClaim(length, bufferClaim) <= 0L) {
            PING_HANDLER_IDLE_STRATEGY.idle();
        }
        bufferClaim.flags(header.flags()).putBytes(buffer, offset, length).commit();
    }
}

