/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.ToIntFunction;
import org.HdrHistogram.Histogram;
import org.agrona.concurrent.SigInt;
import org.agrona.hints.ThreadHints;
import org.agrona.nio.NioSelectedKeySet;

public class SendHackSelectReceiveUdpPing
implements ToIntFunction<SelectionKey> {
    private static final InetSocketAddress SEND_ADDRESS = new InetSocketAddress("localhost", 20124);
    private static final Histogram HISTOGRAM = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(1408);
    private DatagramChannel receiveChannel;
    private int sequenceNumber;

    public static void main(String[] args) throws IOException {
        new SendHackSelectReceiveUdpPing().run();
    }

    private void run() throws IOException {
        this.receiveChannel = DatagramChannel.open();
        Common.init(this.receiveChannel);
        this.receiveChannel.bind(new InetSocketAddress("localhost", 20123));
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        Selector selector = Selector.open();
        this.receiveChannel.register(selector, 1, this);
        NioSelectedKeySet keySet = Common.keySet(selector);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            this.measureRoundTrip(HISTOGRAM, SEND_ADDRESS, this.buffer, sendChannel, selector, keySet, running);
            HISTOGRAM.reset();
            System.gc();
            LockSupport.parkNanos(1000000000L);
        }
    }

    @Override
    public int applyAsInt(SelectionKey key) {
        try {
            this.buffer.clear();
            this.receiveChannel.receive(this.buffer);
            long receivedSequenceNumber = this.buffer.getLong(0);
            long timestampNs = this.buffer.getLong(8);
            if (receivedSequenceNumber != (long)this.sequenceNumber) {
                throw new IllegalStateException("Data Loss:" + this.sequenceNumber + " to " + receivedSequenceNumber);
            }
            long durationNs = System.nanoTime() - timestampNs;
            HISTOGRAM.recordValue(durationNs);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return 1;
    }

    private void measureRoundTrip(Histogram histogram, InetSocketAddress sendAddress, ByteBuffer buffer, DatagramChannel sendChannel, Selector selector, NioSelectedKeySet keySet, AtomicBoolean running) throws IOException {
        this.sequenceNumber = 0;
        while (this.sequenceNumber < 10000) {
            long timestampNs = System.nanoTime();
            buffer.clear();
            buffer.putLong(this.sequenceNumber);
            buffer.putLong(timestampNs);
            buffer.flip();
            sendChannel.send(buffer, sendAddress);
            while (selector.selectNow() == 0) {
                if (!running.get()) {
                    return;
                }
                ThreadHints.onSpinWait();
            }
            keySet.forEach(this);
            ++this.sequenceNumber;
        }
        histogram.outputPercentileDistribution(System.out, 1000.0);
    }
}

