/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ChannelUri;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.SystemUtil;

public final class ChannelUriStringBuilder {
    public static final String TAG_PREFIX = "tag:";
    private final StringBuilder sb = new StringBuilder(64);
    private String prefix;
    private String media;
    private String endpoint;
    private String networkInterface;
    private String controlEndpoint;
    private String controlMode;
    private String tags;
    private String alias;
    private String cc;
    private String fc;
    private Boolean reliable;
    private Integer ttl;
    private Integer mtu;
    private Integer termLength;
    private Integer initialTermId;
    private Integer termId;
    private Integer termOffset;
    private Long sessionId;
    private Long groupTag;
    private Long linger;
    private Boolean sparse;
    private Boolean eos;
    private Boolean tether;
    private Boolean group;
    private Boolean rejoin;
    private Boolean ssc;
    private boolean isSessionIdTagged;
    private Integer socketSndbufLength;
    private Integer socketRcvbufLength;
    private Integer receiverWindowLength;

    public ChannelUriStringBuilder() {
    }

    public ChannelUriStringBuilder(String initialUri) {
        this(ChannelUri.parse(initialUri));
    }

    public ChannelUriStringBuilder(ChannelUri channelUri) {
        this.isSessionIdTagged = false;
        this.prefix(channelUri);
        this.media(channelUri);
        this.endpoint(channelUri);
        this.networkInterface(channelUri);
        this.controlEndpoint(channelUri);
        this.controlMode(channelUri);
        this.tags(channelUri);
        this.alias(channelUri);
        this.congestionControl(channelUri);
        this.flowControl(channelUri);
        this.reliable(channelUri);
        this.ttl(channelUri);
        this.mtu(channelUri);
        this.termLength(channelUri);
        this.initialTermId(channelUri);
        this.termId(channelUri);
        this.termOffset(channelUri);
        this.sessionId(channelUri);
        this.group(channelUri);
        this.linger(channelUri);
        this.sparse(channelUri);
        this.eos(channelUri);
        this.tether(channelUri);
        this.groupTag(channelUri);
        this.rejoin(channelUri);
        this.spiesSimulateConnection(channelUri);
        this.socketRcvbufLength(channelUri);
        this.socketSndbufLength(channelUri);
        this.receiverWindowLength(channelUri);
    }

    public ChannelUriStringBuilder clear() {
        this.prefix = null;
        this.media = null;
        this.endpoint = null;
        this.networkInterface = null;
        this.controlEndpoint = null;
        this.controlMode = null;
        this.tags = null;
        this.alias = null;
        this.cc = null;
        this.fc = null;
        this.reliable = null;
        this.ttl = null;
        this.mtu = null;
        this.termLength = null;
        this.initialTermId = null;
        this.termId = null;
        this.termOffset = null;
        this.sessionId = null;
        this.groupTag = null;
        this.linger = null;
        this.sparse = null;
        this.eos = null;
        this.tether = null;
        this.group = null;
        this.rejoin = null;
        this.isSessionIdTagged = false;
        this.socketRcvbufLength = null;
        this.socketSndbufLength = null;
        this.receiverWindowLength = null;
        return this;
    }

    public ChannelUriStringBuilder validate() {
        if (null == this.media) {
            throw new IllegalStateException("media type is mandatory");
        }
        if ("udp".equals(this.media) && null == this.endpoint && null == this.controlEndpoint) {
            throw new IllegalStateException("either 'endpoint' or 'control' must be specified for UDP.");
        }
        int count = 0;
        count += null == this.initialTermId ? 0 : 1;
        count += null == this.termId ? 0 : 1;
        if ((count += null == this.termOffset ? 0 : 1) > 0) {
            if (count < 3) {
                throw new IllegalStateException("if any of then a complete set of 'initialTermId', 'termId', and 'termOffset' must be provided");
            }
            if (this.termId - this.initialTermId < 0) {
                throw new IllegalStateException("difference greater than 2^31 - 1: termId=" + this.termId + " - initialTermId=" + this.initialTermId);
            }
            if (null != this.termLength && this.termOffset > this.termLength) {
                throw new IllegalStateException("termOffset=" + this.termOffset + " > termLength=" + this.termLength);
            }
        }
        return this;
    }

    public ChannelUriStringBuilder prefix(String prefix) {
        if (null != prefix && !prefix.equals("") && !prefix.equals("aeron-spy")) {
            throw new IllegalArgumentException("invalid prefix: " + prefix);
        }
        this.prefix = prefix;
        return this;
    }

    public ChannelUriStringBuilder prefix(ChannelUri channelUri) {
        return this.prefix(channelUri.prefix());
    }

    public String prefix() {
        return this.prefix;
    }

    public ChannelUriStringBuilder media(String media) {
        switch (media) {
            case "udp": 
            case "ipc": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid media: " + media);
            }
        }
        this.media = media;
        return this;
    }

    public ChannelUriStringBuilder media(ChannelUri channelUri) {
        return this.media(channelUri.media());
    }

    public String media() {
        return this.media;
    }

    public ChannelUriStringBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ChannelUriStringBuilder endpoint(ChannelUri channelUri) {
        return this.endpoint(channelUri.get("endpoint"));
    }

    public String endpoint() {
        return this.endpoint;
    }

    public ChannelUriStringBuilder networkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
    }

    public ChannelUriStringBuilder networkInterface(ChannelUri channelUri) {
        return this.networkInterface(channelUri.get("interface"));
    }

    public String networkInterface() {
        return this.networkInterface;
    }

    public ChannelUriStringBuilder controlEndpoint(String controlEndpoint) {
        this.controlEndpoint = controlEndpoint;
        return this;
    }

    public ChannelUriStringBuilder controlEndpoint(ChannelUri channelUri) {
        return this.controlEndpoint(channelUri.get("control"));
    }

    public String controlEndpoint() {
        return this.controlEndpoint;
    }

    public ChannelUriStringBuilder controlMode(String controlMode) {
        if (null != controlMode && !controlMode.equals("manual") && !controlMode.equals("dynamic")) {
            throw new IllegalArgumentException("invalid control mode: " + controlMode);
        }
        this.controlMode = controlMode;
        return this;
    }

    public ChannelUriStringBuilder controlMode(ChannelUri channelUri) {
        return this.controlMode(channelUri.get("control-mode"));
    }

    public String controlMode() {
        return this.controlMode;
    }

    public ChannelUriStringBuilder reliable(Boolean isReliable) {
        this.reliable = isReliable;
        return this;
    }

    public ChannelUriStringBuilder reliable(ChannelUri channelUri) {
        String reliableValue = channelUri.get("reliable");
        if (null == reliableValue) {
            this.reliable = null;
            return this;
        }
        return this.reliable(Boolean.valueOf(reliableValue));
    }

    public Boolean reliable() {
        return this.reliable;
    }

    public ChannelUriStringBuilder ttl(Integer ttl) {
        if (null != ttl && (ttl < 0 || ttl > 255)) {
            throw new IllegalArgumentException("TTL not in range 0-255: " + ttl);
        }
        this.ttl = ttl;
        return this;
    }

    public ChannelUriStringBuilder ttl(ChannelUri channelUri) {
        String ttlValue = channelUri.get("ttl");
        if (null == ttlValue) {
            this.ttl = null;
            return this;
        }
        return this.ttl(Integer.valueOf(ttlValue));
    }

    public Integer ttl() {
        return this.ttl;
    }

    public ChannelUriStringBuilder mtu(Integer mtu) {
        if (null != mtu) {
            if (mtu < 32 || mtu > 65504) {
                throw new IllegalArgumentException("MTU not in range 32-65504: " + mtu);
            }
            if ((mtu & 0x1F) != 0) {
                throw new IllegalArgumentException("MTU not a multiple of FRAME_ALIGNMENT: mtu=" + mtu);
            }
        }
        this.mtu = mtu;
        return this;
    }

    public ChannelUriStringBuilder mtu(ChannelUri channelUri) {
        String mtuValue = channelUri.get("mtu");
        if (null == mtuValue) {
            this.mtu = null;
            return this;
        }
        long value = SystemUtil.parseSize("mtu", mtuValue);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalStateException("mtu " + value + " > " + Integer.MAX_VALUE);
        }
        return this.mtu((int)value);
    }

    public Integer mtu() {
        return this.mtu;
    }

    public ChannelUriStringBuilder termLength(Integer termLength) {
        if (null != termLength) {
            LogBufferDescriptor.checkTermLength(termLength);
        }
        this.termLength = termLength;
        return this;
    }

    public ChannelUriStringBuilder termLength(ChannelUri channelUri) {
        String termLengthValue = channelUri.get("term-length");
        if (null == termLengthValue) {
            this.termLength = null;
            return this;
        }
        long value = SystemUtil.parseSize("term-length", termLengthValue);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalStateException("term length more than max length of 1073741824: value=" + value);
        }
        return this.termLength((int)value);
    }

    public Integer termLength() {
        return this.termLength;
    }

    public ChannelUriStringBuilder initialTermId(Integer initialTermId) {
        this.initialTermId = initialTermId;
        return this;
    }

    public ChannelUriStringBuilder initialTermId(ChannelUri channelUri) {
        String initialTermIdValue = channelUri.get("init-term-id");
        if (null == initialTermIdValue) {
            this.initialTermId = null;
            return this;
        }
        return this.initialTermId(Integer.valueOf(initialTermIdValue));
    }

    public Integer initialTermId() {
        return this.initialTermId;
    }

    public ChannelUriStringBuilder termId(Integer termId) {
        this.termId = termId;
        return this;
    }

    public ChannelUriStringBuilder termId(ChannelUri channelUri) {
        String termIdValue = channelUri.get("term-id");
        if (null == termIdValue) {
            this.termId = null;
            return this;
        }
        return this.termId(Integer.valueOf(termIdValue));
    }

    public Integer termId() {
        return this.termId;
    }

    public ChannelUriStringBuilder termOffset(Integer termOffset) {
        if (null != termOffset) {
            if (termOffset < 0 || termOffset > 0x40000000) {
                throw new IllegalArgumentException("term offset not in range 0-1g: " + termOffset);
            }
            if (0 != (termOffset & 0x1F)) {
                throw new IllegalArgumentException("term offset not multiple of FRAME_ALIGNMENT: " + termOffset);
            }
        }
        this.termOffset = termOffset;
        return this;
    }

    public ChannelUriStringBuilder termOffset(ChannelUri channelUri) {
        String termOffsetValue = channelUri.get("term-offset");
        if (null == termOffsetValue) {
            this.termOffset = null;
            return this;
        }
        return this.termOffset(Integer.valueOf(termOffsetValue));
    }

    public Integer termOffset() {
        return this.termOffset;
    }

    public ChannelUriStringBuilder sessionId(Integer sessionId) {
        this.sessionId = null != sessionId ? Long.valueOf(sessionId.longValue()) : null;
        return this;
    }

    public ChannelUriStringBuilder sessionId(String sessionIdStr) {
        if (null != sessionIdStr) {
            if (ChannelUri.isTagged(sessionIdStr)) {
                this.taggedSessionId(ChannelUri.getTag(sessionIdStr));
            } else {
                this.isSessionIdTagged(false);
                this.sessionId(Integer.valueOf(sessionIdStr));
            }
        } else {
            this.sessionId((Integer)null);
        }
        return this;
    }

    public ChannelUriStringBuilder taggedSessionId(Long sessionId) {
        this.isSessionIdTagged(true);
        this.sessionId = sessionId;
        return this;
    }

    public ChannelUriStringBuilder sessionId(ChannelUri channelUri) {
        return this.sessionId(channelUri.get("session-id"));
    }

    @Deprecated
    public Integer sessionId() {
        return null != this.sessionId ? Integer.valueOf(this.sessionId.intValue()) : null;
    }

    public ChannelUriStringBuilder linger(Long lingerNs) {
        if (null != lingerNs && lingerNs < 0L) {
            throw new IllegalArgumentException("linger value cannot be negative: " + lingerNs);
        }
        this.linger = lingerNs;
        return this;
    }

    public ChannelUriStringBuilder linger(ChannelUri channelUri) {
        String lingerValue = channelUri.get("linger");
        if (null == lingerValue) {
            this.linger = null;
            return this;
        }
        return this.linger(SystemUtil.parseDuration("linger", lingerValue));
    }

    public Long linger() {
        return this.linger;
    }

    public ChannelUriStringBuilder sparse(Boolean isSparse) {
        this.sparse = isSparse;
        return this;
    }

    public ChannelUriStringBuilder sparse(ChannelUri channelUri) {
        String sparseValue = channelUri.get("sparse");
        if (null == sparseValue) {
            this.sparse = null;
            return this;
        }
        return this.sparse(Boolean.valueOf(sparseValue));
    }

    public Boolean sparse() {
        return this.sparse;
    }

    public ChannelUriStringBuilder eos(Boolean eos) {
        this.eos = eos;
        return this;
    }

    public ChannelUriStringBuilder eos(ChannelUri channelUri) {
        String eosValue = channelUri.get("eos");
        if (null == eosValue) {
            this.eos = null;
            return this;
        }
        return this.eos(Boolean.valueOf(eosValue));
    }

    public Boolean eos() {
        return this.eos;
    }

    public ChannelUriStringBuilder tether(Boolean tether) {
        this.tether = tether;
        return this;
    }

    public ChannelUriStringBuilder tether(ChannelUri channelUri) {
        String tetherValue = channelUri.get("tether");
        if (null == tetherValue) {
            this.tether = null;
            return this;
        }
        return this.tether(Boolean.valueOf(tetherValue));
    }

    public Boolean tether() {
        return this.tether;
    }

    public ChannelUriStringBuilder group(Boolean group) {
        this.group = group;
        return this;
    }

    public ChannelUriStringBuilder group(ChannelUri channelUri) {
        String groupValue = channelUri.get("group");
        if (null == groupValue) {
            this.group = null;
            return this;
        }
        return this.group(Boolean.valueOf(groupValue));
    }

    public Boolean group() {
        return this.group;
    }

    public ChannelUriStringBuilder tags(String tags) {
        this.tags = tags;
        return this;
    }

    public ChannelUriStringBuilder tags(ChannelUri channelUri) {
        return this.tags(channelUri.get("tags"));
    }

    public ChannelUriStringBuilder tags(Long channelTag, Long pubSubTag) {
        if (null == channelTag && null != pubSubTag) {
            throw new IllegalArgumentException("null == channelTag && null != pubSubTag");
        }
        if (null == channelTag) {
            return this.tags((String)null);
        }
        return this.tags(channelTag + (null != pubSubTag ? "," + pubSubTag : ""));
    }

    public String tags() {
        return this.tags;
    }

    public ChannelUriStringBuilder isSessionIdTagged(boolean isSessionIdTagged) {
        this.isSessionIdTagged = isSessionIdTagged;
        return this;
    }

    public boolean isSessionIdTagged() {
        return this.isSessionIdTagged;
    }

    public ChannelUriStringBuilder alias(String alias) {
        this.alias = alias;
        return this;
    }

    public ChannelUriStringBuilder alias(ChannelUri channelUri) {
        return this.alias(channelUri.get("alias"));
    }

    public String alias() {
        return this.alias;
    }

    public ChannelUriStringBuilder congestionControl(String congestionControl) {
        this.cc = congestionControl;
        return this;
    }

    public ChannelUriStringBuilder congestionControl(ChannelUri channelUri) {
        return this.congestionControl(channelUri.get("cc"));
    }

    public String congestionControl() {
        return this.cc;
    }

    public ChannelUriStringBuilder flowControl(String flowControl) {
        this.fc = flowControl;
        return this;
    }

    public ChannelUriStringBuilder taggedFlowControl(Long groupTag, Integer minGroupSize, String timeout) {
        String flowControlValue = "tagged";
        if (null != groupTag || null != minGroupSize) {
            flowControlValue = flowControlValue + ",g:";
            if (null != groupTag) {
                flowControlValue = flowControlValue + groupTag;
            }
            if (null != minGroupSize) {
                flowControlValue = flowControlValue + "/" + minGroupSize;
            }
        }
        if (null != timeout) {
            flowControlValue = flowControlValue + ",t:" + timeout;
        }
        return this.flowControl(flowControlValue);
    }

    public ChannelUriStringBuilder minFlowControl(Integer minGroupSize, String timeout) {
        String flowControlValue = "min";
        if (null != minGroupSize) {
            flowControlValue = flowControlValue + ",g:/" + minGroupSize;
        }
        if (null != timeout) {
            flowControlValue = flowControlValue + ",t:" + timeout;
        }
        return this.flowControl(flowControlValue);
    }

    public ChannelUriStringBuilder flowControl(ChannelUri channelUri) {
        return this.flowControl(channelUri.get("fc"));
    }

    public String flowControl() {
        return this.fc;
    }

    public ChannelUriStringBuilder groupTag(Long groupTag) {
        this.groupTag = groupTag;
        return this;
    }

    public ChannelUriStringBuilder groupTag(ChannelUri channelUri) {
        String groupTagValue = channelUri.get("gtag");
        if (null == groupTagValue) {
            this.groupTag = null;
            return this;
        }
        return this.groupTag(Long.valueOf(groupTagValue));
    }

    public Long groupTag() {
        return this.groupTag;
    }

    public ChannelUriStringBuilder rejoin(Boolean rejoin) {
        this.rejoin = rejoin;
        return this;
    }

    public ChannelUriStringBuilder rejoin(ChannelUri channelUri) {
        String rejoinValue = channelUri.get("rejoin");
        if (null == rejoinValue) {
            this.rejoin = null;
            return this;
        }
        return this.rejoin(Boolean.valueOf(rejoinValue));
    }

    public Boolean rejoin() {
        return this.rejoin;
    }

    public ChannelUriStringBuilder spiesSimulateConnection(Boolean spiesSimulateConnection) {
        this.ssc = spiesSimulateConnection;
        return this;
    }

    public ChannelUriStringBuilder spiesSimulateConnection(ChannelUri channelUri) {
        String sscValue = channelUri.get("ssc");
        if (null == sscValue) {
            this.ssc = null;
            return this;
        }
        return this.spiesSimulateConnection(Boolean.valueOf(sscValue));
    }

    public Boolean spiesSimulateConnection() {
        return this.ssc;
    }

    public ChannelUriStringBuilder initialPosition(long position, int initialTermId, int termLength) {
        if (position < 0L || 0L != (position & 0x1FL)) {
            throw new IllegalArgumentException("invalid position: " + position);
        }
        int bitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        this.initialTermId = initialTermId;
        this.termId = LogBufferDescriptor.computeTermIdFromPosition(position, bitsToShift, initialTermId);
        this.termOffset = (int)(position & (long)(termLength - 1));
        this.termLength = termLength;
        return this;
    }

    public ChannelUriStringBuilder socketSndbufLength(Integer socketSndbufLength) {
        this.socketSndbufLength = socketSndbufLength;
        return this;
    }

    public ChannelUriStringBuilder socketSndbufLength(ChannelUri channelUri) {
        String valueStr = channelUri.get("so-sndbuf");
        if (null == valueStr) {
            this.socketSndbufLength = null;
            return this;
        }
        long value = SystemUtil.parseSize("so-sndbuf", valueStr);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalStateException("value exceeds maximum permitted: value=" + value);
        }
        return this.socketSndbufLength((int)value);
    }

    public Integer socketSndbufLength() {
        return this.socketSndbufLength;
    }

    public ChannelUriStringBuilder socketRcvbufLength(Integer socketRcvbufLength) {
        this.socketRcvbufLength = socketRcvbufLength;
        return this;
    }

    public ChannelUriStringBuilder socketRcvbufLength(ChannelUri channelUri) {
        String valueStr = channelUri.get("so-rcvbuf");
        if (null == valueStr) {
            this.socketRcvbufLength = null;
            return this;
        }
        long value = SystemUtil.parseSize("so-rcvbuf", valueStr);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalStateException("value exceeds maximum permitted: value=" + value);
        }
        return this.socketRcvbufLength((int)value);
    }

    public Integer socketRcvbufLength() {
        return this.socketRcvbufLength;
    }

    public ChannelUriStringBuilder receiverWindowLength(Integer receiverWindowLength) {
        this.receiverWindowLength = receiverWindowLength;
        return this;
    }

    public ChannelUriStringBuilder receiverWindowLength(ChannelUri channelUri) {
        String valueStr = channelUri.get("rcv-wnd");
        if (null == valueStr) {
            this.receiverWindowLength = null;
            return this;
        }
        long value = SystemUtil.parseSize("rcv-wnd", valueStr);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalStateException("value exceeds maximum permitted: value=" + value);
        }
        return this.receiverWindowLength((int)value);
    }

    public Integer receiverWindowLength() {
        return this.receiverWindowLength;
    }

    public String build() {
        char lastChar;
        this.sb.setLength(0);
        if (null != this.prefix && !"".equals(this.prefix)) {
            this.sb.append(this.prefix).append(':');
        }
        this.sb.append("aeron").append(':').append(this.media).append('?');
        if (null != this.tags) {
            this.sb.append("tags").append('=').append(this.tags).append('|');
        }
        if (null != this.endpoint) {
            this.sb.append("endpoint").append('=').append(this.endpoint).append('|');
        }
        if (null != this.networkInterface) {
            this.sb.append("interface").append('=').append(this.networkInterface).append('|');
        }
        if (null != this.controlEndpoint) {
            this.sb.append("control").append('=').append(this.controlEndpoint).append('|');
        }
        if (null != this.controlMode) {
            this.sb.append("control-mode").append('=').append(this.controlMode).append('|');
        }
        if (null != this.mtu) {
            this.sb.append("mtu").append('=').append(this.mtu).append('|');
        }
        if (null != this.termLength) {
            this.sb.append("term-length").append('=').append(this.termLength).append('|');
        }
        if (null != this.initialTermId) {
            this.sb.append("init-term-id").append('=').append(this.initialTermId).append('|');
        }
        if (null != this.termId) {
            this.sb.append("term-id").append('=').append(this.termId).append('|');
        }
        if (null != this.termOffset) {
            this.sb.append("term-offset").append('=').append(this.termOffset).append('|');
        }
        if (null != this.sessionId) {
            this.sb.append("session-id").append('=').append(ChannelUriStringBuilder.prefixTag(this.isSessionIdTagged, this.sessionId)).append('|');
        }
        if (null != this.ttl) {
            this.sb.append("ttl").append('=').append(this.ttl).append('|');
        }
        if (null != this.reliable) {
            this.sb.append("reliable").append('=').append(this.reliable).append('|');
        }
        if (null != this.linger) {
            this.sb.append("linger").append('=').append(this.linger.intValue()).append('|');
        }
        if (null != this.alias) {
            this.sb.append("alias").append('=').append(this.alias).append('|');
        }
        if (null != this.cc) {
            this.sb.append("cc").append('=').append(this.cc).append('|');
        }
        if (null != this.fc) {
            this.sb.append("fc").append('=').append(this.fc).append('|');
        }
        if (null != this.groupTag) {
            this.sb.append("gtag").append('=').append(this.groupTag).append('|');
        }
        if (null != this.sparse) {
            this.sb.append("sparse").append('=').append(this.sparse).append('|');
        }
        if (null != this.eos) {
            this.sb.append("eos").append('=').append(this.eos).append('|');
        }
        if (null != this.tether) {
            this.sb.append("tether").append('=').append(this.tether).append('|');
        }
        if (null != this.group) {
            this.sb.append("group").append('=').append(this.group).append('|');
        }
        if (null != this.rejoin) {
            this.sb.append("rejoin").append('=').append(this.rejoin).append('|');
        }
        if (null != this.ssc) {
            this.sb.append("ssc").append('=').append(this.ssc).append('|');
        }
        if (null != this.socketSndbufLength) {
            this.sb.append("so-sndbuf").append('=').append(this.socketSndbufLength).append('|');
        }
        if (null != this.socketRcvbufLength) {
            this.sb.append("so-rcvbuf").append('=').append(this.socketRcvbufLength).append('|');
        }
        if (null != this.receiverWindowLength) {
            this.sb.append("rcv-wnd").append('=').append(this.receiverWindowLength).append('|');
        }
        if ((lastChar = this.sb.charAt(this.sb.length() - 1)) == '|' || lastChar == '?') {
            this.sb.setLength(this.sb.length() - 1);
        }
        return this.sb.toString();
    }

    public String toString() {
        return this.build();
    }

    private static String prefixTag(boolean isTagged, Long value) {
        return isTagged ? TAG_PREFIX + value : value.toString();
    }
}

