/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.CounterMessageFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.command.TerminateDriverFlyweight;
import io.aeron.exceptions.AeronException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;

public final class DriverProxy {
    private final long clientId;
    private final PublicationMessageFlyweight publicationMessage = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMessage = new SubscriptionMessageFlyweight();
    private final RemoveMessageFlyweight removeMessage = new RemoveMessageFlyweight();
    private final DestinationMessageFlyweight destinationMessage = new DestinationMessageFlyweight();
    private final CounterMessageFlyweight counterMessage = new CounterMessageFlyweight();
    private final RingBuffer toDriverCommandBuffer;

    public DriverProxy(RingBuffer toDriverCommandBuffer, long clientId) {
        this.toDriverCommandBuffer = toDriverCommandBuffer;
        this.clientId = clientId;
    }

    public long timeOfLastDriverKeepaliveMs() {
        return this.toDriverCommandBuffer.consumerHeartbeatTime();
    }

    public long addPublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = PublicationMessageFlyweight.computeLength(channel.length());
        int index = this.toDriverCommandBuffer.tryClaim(1, length);
        if (index < 0) {
            throw new AeronException("could not write add publication command");
        }
        this.publicationMessage.wrap(this.toDriverCommandBuffer.buffer(), index).streamId(streamId).channel(channel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addExclusivePublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = PublicationMessageFlyweight.computeLength(channel.length());
        int index = this.toDriverCommandBuffer.tryClaim(3, length);
        if (index < 0) {
            throw new AeronException("could not write add exclusive publication command");
        }
        this.publicationMessage.wrap(this.toDriverCommandBuffer.buffer(), index).streamId(streamId).channel(channel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removePublication(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int index = this.toDriverCommandBuffer.tryClaim(2, RemoveMessageFlyweight.length());
        if (index < 0) {
            throw new AeronException("could not write remove publication command");
        }
        this.removeMessage.wrap(this.toDriverCommandBuffer.buffer(), index).registrationId(registrationId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addSubscription(String channel, int streamId) {
        long registrationId = -1L;
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = SubscriptionMessageFlyweight.computeLength(channel.length());
        int index = this.toDriverCommandBuffer.tryClaim(4, length);
        if (index < 0) {
            throw new AeronException("could not write add subscription command");
        }
        this.subscriptionMessage.wrap(this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(-1L).streamId(streamId).channel(channel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removeSubscription(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int index = this.toDriverCommandBuffer.tryClaim(5, RemoveMessageFlyweight.length());
        if (index < 0) {
            throw new AeronException("could not write remove subscription command");
        }
        this.removeMessage.wrap(this.toDriverCommandBuffer.buffer(), index).registrationId(registrationId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = DestinationMessageFlyweight.computeLength(endpointChannel.length());
        int index = this.toDriverCommandBuffer.tryClaim(7, length);
        if (index < 0) {
            throw new AeronException("could not write add destination command");
        }
        this.destinationMessage.wrap(this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(registrationId).channel(endpointChannel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removeDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = DestinationMessageFlyweight.computeLength(endpointChannel.length());
        int index = this.toDriverCommandBuffer.tryClaim(8, length);
        if (index < 0) {
            throw new AeronException("could not write remove destination command");
        }
        this.destinationMessage.wrap(this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(registrationId).channel(endpointChannel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addRcvDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = DestinationMessageFlyweight.computeLength(endpointChannel.length());
        int index = this.toDriverCommandBuffer.tryClaim(12, length);
        if (index < 0) {
            throw new AeronException("could not write add rcv destination command");
        }
        this.destinationMessage.wrap(this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(registrationId).channel(endpointChannel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removeRcvDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = DestinationMessageFlyweight.computeLength(endpointChannel.length());
        int index = this.toDriverCommandBuffer.tryClaim(13, length);
        if (index < 0) {
            throw new AeronException("could not write remove rcv destination command");
        }
        this.destinationMessage.wrap(this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(registrationId).channel(endpointChannel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = CounterMessageFlyweight.computeLength(keyLength, labelLength);
        int index = this.toDriverCommandBuffer.tryClaim(9, length);
        if (index < 0) {
            throw new AeronException("could not write add counter command");
        }
        this.counterMessage.wrap(this.toDriverCommandBuffer.buffer(), index).keyBuffer(keyBuffer, keyOffset, keyLength).labelBuffer(labelBuffer, labelOffset, labelLength).typeId(typeId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addCounter(int typeId, String label) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = CounterMessageFlyweight.computeLength(0, label.length());
        int index = this.toDriverCommandBuffer.tryClaim(9, length);
        if (index < 0) {
            throw new AeronException("could not write add counter command");
        }
        this.counterMessage.wrap(this.toDriverCommandBuffer.buffer(), index).keyBuffer(null, 0, 0).label(label).typeId(typeId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removeCounter(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int index = this.toDriverCommandBuffer.tryClaim(10, RemoveMessageFlyweight.length());
        if (index < 0) {
            throw new AeronException("could not write remove counter command");
        }
        this.removeMessage.wrap(this.toDriverCommandBuffer.buffer(), index).registrationId(registrationId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public void clientClose() {
        int index = this.toDriverCommandBuffer.tryClaim(11, 16);
        if (index > 0) {
            new CorrelatedMessageFlyweight().wrap(this.toDriverCommandBuffer.buffer(), index).clientId(this.clientId).correlationId(-1L);
            this.toDriverCommandBuffer.commit(index);
        }
    }

    public boolean terminateDriver(DirectBuffer tokenBuffer, int tokenOffset, int tokenLength) {
        int length = TerminateDriverFlyweight.computeLength(tokenLength);
        int index = this.toDriverCommandBuffer.tryClaim(14, length);
        if (index > 0) {
            new TerminateDriverFlyweight().wrap(this.toDriverCommandBuffer.buffer(), index).tokenBuffer(tokenBuffer, tokenOffset, tokenLength).clientId(this.clientId).correlationId(-1L);
            this.toDriverCommandBuffer.commit(index);
            return true;
        }
        return false;
    }
}

