/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.ControlEventListener;
import io.aeron.archive.client.RecordingSignalConsumer;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingSignalEventDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public final class RecordingSignalAdapter {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final RecordingSignalEventDecoder recordingSignalEventDecoder = new RecordingSignalEventDecoder();
    private final ControlledFragmentAssembler assembler = new ControlledFragmentAssembler(this::onFragment);
    private final ControlEventListener controlEventListener;
    private final RecordingSignalConsumer recordingSignalConsumer;
    private final Subscription subscription;
    private final int fragmentLimit;
    private final long controlSessionId;
    private boolean isDone = false;

    public RecordingSignalAdapter(long controlSessionId, ControlEventListener controlEventListener, RecordingSignalConsumer recordingSignalConsumer, Subscription subscription, int fragmentLimit) {
        this.controlSessionId = controlSessionId;
        this.controlEventListener = controlEventListener;
        this.recordingSignalConsumer = recordingSignalConsumer;
        this.subscription = subscription;
        this.fragmentLimit = fragmentLimit;
    }

    public int poll() {
        this.isDone = false;
        return this.subscription.controlledPoll(this.assembler, this.fragmentLimit);
    }

    public boolean isDone() {
        return this.isDone;
    }

    private ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        if (this.isDone) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        switch (this.messageHeaderDecoder.templateId()) {
            case 1: {
                this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                if (this.controlResponseDecoder.controlSessionId() != this.controlSessionId) break;
                this.controlEventListener.onResponse(this.controlSessionId, this.controlResponseDecoder.correlationId(), this.controlResponseDecoder.relevantId(), this.controlResponseDecoder.code(), this.controlResponseDecoder.errorMessage());
                this.isDone = true;
                return ControlledFragmentHandler.Action.BREAK;
            }
            case 24: {
                this.recordingSignalEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                if (this.recordingSignalEventDecoder.controlSessionId() != this.controlSessionId) break;
                this.recordingSignalConsumer.onSignal(this.recordingSignalEventDecoder.controlSessionId(), this.recordingSignalEventDecoder.correlationId(), this.recordingSignalEventDecoder.recordingId(), this.recordingSignalEventDecoder.subscriptionId(), this.recordingSignalEventDecoder.position(), this.recordingSignalEventDecoder.signal());
                this.isDone = true;
                return ControlledFragmentHandler.Action.BREAK;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

