/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.ExclusivePublication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.RegistrationException;
import java.util.List;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.Int2ObjectHashMap;

public final class ClusterMember {
    static final ClusterMember[] EMPTY_MEMBERS = new ClusterMember[0];
    private boolean isBallotSent;
    private boolean isLeader;
    private boolean hasRequestedJoin;
    private boolean hasTerminated;
    private int id;
    private long leadershipTermId = -1L;
    private long logPosition = -1L;
    private long candidateTermId = -1L;
    private long catchupReplaySessionId = -1L;
    private long catchupReplayCorrelationId = -1L;
    private long changeCorrelationId = -1L;
    private long removalPosition = -1L;
    private long timeOfLastAppendPositionNs = -1L;
    private final String ingressEndpoint;
    private final String consensusEndpoint;
    private final String logEndpoint;
    private final String catchupEndpoint;
    private final String archiveEndpoint;
    private final String endpoints;
    private ExclusivePublication publication;
    private Boolean vote = null;

    public ClusterMember(int id, String ingressEndpoint, String consensusEndpoint, String logEndpoint, String catchupEndpoint, String archiveEndpoint, String endpoints) {
        this.id = id;
        this.ingressEndpoint = ingressEndpoint;
        this.consensusEndpoint = consensusEndpoint;
        this.logEndpoint = logEndpoint;
        this.catchupEndpoint = catchupEndpoint;
        this.archiveEndpoint = archiveEndpoint;
        this.endpoints = endpoints;
    }

    public void reset() {
        this.isBallotSent = false;
        this.isLeader = false;
        this.hasRequestedJoin = false;
        this.hasTerminated = false;
        this.vote = null;
        this.candidateTermId = -1L;
        this.leadershipTermId = -1L;
        this.logPosition = -1L;
    }

    public ClusterMember isLeader(boolean isLeader) {
        this.isLeader = isLeader;
        return this;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public ClusterMember isBallotSent(boolean isBallotSent) {
        this.isBallotSent = isBallotSent;
        return this;
    }

    public boolean isBallotSent() {
        return this.isBallotSent;
    }

    public ClusterMember hasRequestedJoin(boolean hasRequestedJoin) {
        this.hasRequestedJoin = hasRequestedJoin;
        return this;
    }

    public boolean hasRequestedJoin() {
        return this.hasRequestedJoin;
    }

    public ClusterMember hasTerminated(boolean hasTerminated) {
        this.hasTerminated = hasTerminated;
        return this;
    }

    public boolean hasTerminated() {
        return this.hasTerminated;
    }

    public ClusterMember removalPosition(long removalPosition) {
        this.removalPosition = removalPosition;
        return this;
    }

    public long removalPosition() {
        return this.removalPosition;
    }

    public boolean hasRequestedRemove() {
        return this.removalPosition != -1L;
    }

    public ClusterMember id(int id) {
        this.id = id;
        return this;
    }

    public int id() {
        return this.id;
    }

    public ClusterMember vote(Boolean vote) {
        this.vote = vote;
        return this;
    }

    public Boolean vote() {
        return this.vote;
    }

    public ClusterMember leadershipTermId(long leadershipTermId) {
        this.leadershipTermId = leadershipTermId;
        return this;
    }

    public long leadershipTermId() {
        return this.leadershipTermId;
    }

    public ClusterMember logPosition(long logPosition) {
        this.logPosition = logPosition;
        return this;
    }

    public long logPosition() {
        return this.logPosition;
    }

    public ClusterMember candidateTermId(long candidateTermId) {
        this.candidateTermId = candidateTermId;
        return this;
    }

    public long candidateTermId() {
        return this.candidateTermId;
    }

    public ClusterMember catchupReplaySessionId(long replaySessionId) {
        this.catchupReplaySessionId = replaySessionId;
        return this;
    }

    public long catchupReplaySessionId() {
        return this.catchupReplaySessionId;
    }

    public ClusterMember catchupReplayCorrelationId(long correlationId) {
        this.catchupReplayCorrelationId = correlationId;
        return this;
    }

    public long catchupReplayCorrelationId() {
        return this.catchupReplayCorrelationId;
    }

    public ClusterMember correlationId(long correlationId) {
        this.changeCorrelationId = correlationId;
        return this;
    }

    public long correlationId() {
        return this.changeCorrelationId;
    }

    public ClusterMember timeOfLastAppendPositionNs(long timeNs) {
        this.timeOfLastAppendPositionNs = timeNs;
        return this;
    }

    public long timeOfLastAppendPositionNs() {
        return this.timeOfLastAppendPositionNs;
    }

    public String ingressEndpoint() {
        return this.ingressEndpoint;
    }

    public String consensusEndpoint() {
        return this.consensusEndpoint;
    }

    public String logEndpoint() {
        return this.logEndpoint;
    }

    public String catchupEndpoint() {
        return this.catchupEndpoint;
    }

    public String archiveEndpoint() {
        return this.archiveEndpoint;
    }

    public String endpoints() {
        return this.endpoints;
    }

    public ExclusivePublication publication() {
        return this.publication;
    }

    public void publication(ExclusivePublication publication) {
        this.publication = publication;
    }

    public void closePublication(ErrorHandler errorHandler) {
        CloseHelper.close(errorHandler, this.publication);
        this.publication = null;
    }

    public static ClusterMember[] parse(String value) {
        if (null == value || value.length() == 0) {
            return EMPTY_MEMBERS;
        }
        String[] memberValues = value.split("\\|");
        int length = memberValues.length;
        ClusterMember[] members = new ClusterMember[length];
        for (int i = 0; i < length; ++i) {
            String idAndEndpoints = memberValues[i];
            String[] memberAttributes = idAndEndpoints.split(",");
            if (memberAttributes.length != 6) {
                throw new ClusterException("invalid member value: " + idAndEndpoints + " within: " + value);
            }
            String endpoints = String.join((CharSequence)",", memberAttributes[1], memberAttributes[2], memberAttributes[3], memberAttributes[4], memberAttributes[5]);
            members[i] = new ClusterMember(Integer.parseInt(memberAttributes[0]), memberAttributes[1], memberAttributes[2], memberAttributes[3], memberAttributes[4], memberAttributes[5], endpoints);
        }
        return members;
    }

    public static ClusterMember parseEndpoints(int id, String endpoints) {
        String[] memberAttributes = endpoints.split(",");
        if (memberAttributes.length != 5) {
            throw new ClusterException("invalid member value: " + endpoints);
        }
        return new ClusterMember(id, memberAttributes[0], memberAttributes[1], memberAttributes[2], memberAttributes[3], memberAttributes[4], endpoints);
    }

    public static String encodeAsString(ClusterMember[] clusterMembers) {
        if (0 == clusterMembers.length) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int length = clusterMembers.length;
        for (int i = 0; i < length; ++i) {
            ClusterMember member = clusterMembers[i];
            builder.append(member.id()).append(',').append(member.endpoints());
            if (length - 1 == i) continue;
            builder.append('|');
        }
        return builder.toString();
    }

    public static String encodeAsString(List<ClusterMember> clusterMembers) {
        if (0 == clusterMembers.size()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int length = clusterMembers.size();
        for (int i = 0; i < length; ++i) {
            ClusterMember member = clusterMembers.get(i);
            builder.append(member.id()).append(',').append(member.endpoints());
            if (length - 1 == i) continue;
            builder.append('|');
        }
        return builder.toString();
    }

    public static void copyVotes(ClusterMember[] srcMembers, ClusterMember[] dstMembers) {
        for (ClusterMember srcMember : srcMembers) {
            ClusterMember dstMember = ClusterMember.findMember(dstMembers, srcMember.id);
            if (null == dstMember) continue;
            dstMember.vote = srcMember.vote;
        }
    }

    public static void addConsensusPublications(ClusterMember[] members, ClusterMember exclude, String channel, int streamId, Aeron aeron, ErrorHandler errorHandler) {
        ChannelUri channelUri = ChannelUri.parse(channel);
        for (ClusterMember member : members) {
            if (member.id == exclude.id) continue;
            channelUri.put("endpoint", member.consensusEndpoint());
            ClusterMember.trySetMemberPublication(member, channelUri, streamId, aeron, errorHandler);
        }
    }

    public static void addConsensusPublication(ClusterMember member, String channel, int streamId, Aeron aeron, ErrorHandler errorHandler) {
        ChannelUri channelUri = ChannelUri.parse(channel);
        channelUri.put("endpoint", member.consensusEndpoint());
        ClusterMember.trySetMemberPublication(member, channelUri, streamId, aeron, errorHandler);
    }

    public static void closeConsensusPublications(ErrorHandler errorHandler, ClusterMember[] clusterMembers) {
        for (ClusterMember member : clusterMembers) {
            member.closePublication(errorHandler);
        }
    }

    public static void addClusterMemberIds(ClusterMember[] clusterMembers, Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap) {
        for (ClusterMember member : clusterMembers) {
            clusterMemberByIdMap.put(member.id(), member);
        }
    }

    public static boolean hasActiveQuorum(ClusterMember[] clusterMembers, long nowNs, long timeoutNs) {
        int threshold = ClusterMember.quorumThreshold(clusterMembers.length);
        for (ClusterMember member : clusterMembers) {
            if (!member.isLeader() && nowNs > member.timeOfLastAppendPositionNs() + timeoutNs || --threshold > 0) continue;
            return true;
        }
        return false;
    }

    public static int quorumThreshold(int memberCount) {
        return (memberCount >> 1) + 1;
    }

    public static long quorumPosition(ClusterMember[] members, long[] rankedPositions) {
        int length = rankedPositions.length;
        for (int i = 0; i < length; ++i) {
            rankedPositions[i] = 0L;
        }
        for (ClusterMember member : members) {
            long newPosition = member.logPosition;
            for (int i = 0; i < length; ++i) {
                long rankedPosition = rankedPositions[i];
                if (newPosition <= rankedPosition) continue;
                rankedPositions[i] = newPosition;
                newPosition = rankedPosition;
            }
        }
        return rankedPositions[length - 1];
    }

    public static void resetLogPositions(ClusterMember[] clusterMembers, long logPosition) {
        for (ClusterMember member : clusterMembers) {
            member.logPosition(logPosition);
        }
    }

    public static boolean haveVotersReachedPosition(ClusterMember[] clusterMembers, long position, long leadershipTermId) {
        for (ClusterMember member : clusterMembers) {
            if (member.vote == null || member.logPosition >= position && member.leadershipTermId == leadershipTermId) continue;
            return false;
        }
        return true;
    }

    public static boolean haveQuorumReachedPosition(ClusterMember[] clusterMembers, long position, long leadershipTermId) {
        int votes = 0;
        for (ClusterMember member : clusterMembers) {
            if (member.leadershipTermId != leadershipTermId || member.logPosition < position) continue;
            ++votes;
        }
        return votes >= ClusterMember.quorumThreshold(clusterMembers.length);
    }

    public static void reset(ClusterMember[] members) {
        for (ClusterMember member : members) {
            member.reset();
        }
    }

    public static void becomeCandidate(ClusterMember[] members, long candidateTermId, int candidateMemberId) {
        for (ClusterMember member : members) {
            if (member.id == candidateMemberId) {
                member.vote(Boolean.TRUE).candidateTermId(candidateTermId).isBallotSent(true);
                continue;
            }
            member.vote(null).candidateTermId(-1L).isBallotSent(false);
        }
    }

    public static boolean hasWonVoteOnFullCount(ClusterMember[] members, long candidateTermId) {
        int votes = 0;
        for (ClusterMember member : members) {
            if (null == member.vote || member.candidateTermId != candidateTermId) {
                return false;
            }
            votes += member.vote != false ? 1 : 0;
        }
        return votes >= ClusterMember.quorumThreshold(members.length);
    }

    public static boolean hasMajorityVoteWithCanvassMembers(ClusterMember[] members, long candidateTermId) {
        int votes = 0;
        for (ClusterMember member : members) {
            if (-1L != member.logPosition && null == member.vote) {
                return false;
            }
            if (!Boolean.TRUE.equals(member.vote) || member.candidateTermId != candidateTermId) continue;
            ++votes;
        }
        return votes >= ClusterMember.quorumThreshold(members.length);
    }

    public static boolean hasMajorityVote(ClusterMember[] clusterMembers, long candidateTermId) {
        int votes = 0;
        for (ClusterMember member : clusterMembers) {
            if (!Boolean.TRUE.equals(member.vote) || member.candidateTermId != candidateTermId) continue;
            ++votes;
        }
        return votes >= ClusterMember.quorumThreshold(clusterMembers.length);
    }

    public static ClusterMember determineMember(ClusterMember[] clusterMembers, int memberId, String memberEndpoints) {
        ClusterMember member;
        ClusterMember clusterMember = member = -1 != memberId ? ClusterMember.findMember(clusterMembers, memberId) : null;
        if ((null == clusterMembers || 0 == clusterMembers.length) && null == member) {
            member = ClusterMember.parseEndpoints(-1, memberEndpoints);
        } else {
            if (null == member) {
                throw new ClusterException("memberId=" + memberId + " not found in clusterMembers");
            }
            if (!"".equals(memberEndpoints)) {
                ClusterMember.validateMemberEndpoints(member, memberEndpoints);
            }
        }
        return member;
    }

    public static void validateMemberEndpoints(ClusterMember member, String memberEndpoints) {
        ClusterMember endpoints = ClusterMember.parseEndpoints(-1, memberEndpoints);
        if (!ClusterMember.areSameEndpoints(member, endpoints)) {
            throw new ClusterException("clusterMembers and endpoints differ: " + member.endpoints() + " != " + memberEndpoints);
        }
    }

    public static boolean areSameEndpoints(ClusterMember lhs, ClusterMember rhs) {
        return lhs.ingressEndpoint().equals(rhs.ingressEndpoint()) && lhs.consensusEndpoint().equals(rhs.consensusEndpoint()) && lhs.logEndpoint().equals(rhs.logEndpoint()) && lhs.catchupEndpoint().equals(rhs.catchupEndpoint()) && lhs.archiveEndpoint().equals(rhs.archiveEndpoint());
    }

    public static boolean isUnanimousCandidate(ClusterMember[] clusterMembers, ClusterMember candidate) {
        for (ClusterMember member : clusterMembers) {
            if (-1L != member.logPosition && ClusterMember.compareLog(candidate, member) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isQuorumCandidate(ClusterMember[] clusterMembers, ClusterMember candidate) {
        int possibleVotes = 0;
        for (ClusterMember member : clusterMembers) {
            if (-1L == member.logPosition || ClusterMember.compareLog(candidate, member) < 0) continue;
            ++possibleVotes;
        }
        return possibleVotes >= ClusterMember.quorumThreshold(clusterMembers.length);
    }

    public static int compareLog(long lhsLogLeadershipTermId, long lhsLogPosition, long rhsLogLeadershipTermId, long rhsLogPosition) {
        if (lhsLogLeadershipTermId > rhsLogLeadershipTermId) {
            return 1;
        }
        if (lhsLogLeadershipTermId < rhsLogLeadershipTermId) {
            return -1;
        }
        if (lhsLogPosition > rhsLogPosition) {
            return 1;
        }
        if (lhsLogPosition < rhsLogPosition) {
            return -1;
        }
        return 0;
    }

    public static int compareLog(ClusterMember lhs, ClusterMember rhs) {
        return ClusterMember.compareLog(lhs.leadershipTermId, lhs.logPosition, rhs.leadershipTermId, rhs.logPosition);
    }

    public static boolean notDuplicateEndpoint(ClusterMember[] members, String endpoints) {
        for (ClusterMember member : members) {
            if (!member.endpoints().equals(endpoints)) continue;
            return false;
        }
        return true;
    }

    public static int findMemberIndex(ClusterMember[] clusterMembers, int memberId) {
        int length = clusterMembers.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            if (clusterMembers[i].id() != memberId) continue;
            index = i;
        }
        return index;
    }

    public static ClusterMember findMember(ClusterMember[] clusterMembers, int memberId) {
        for (ClusterMember member : clusterMembers) {
            if (member.id() != memberId) continue;
            return member;
        }
        return null;
    }

    public static ClusterMember[] addMember(ClusterMember[] oldMembers, ClusterMember newMember) {
        return ArrayUtil.add(oldMembers, newMember);
    }

    public static ClusterMember[] removeMember(ClusterMember[] oldMembers, int memberId) {
        int memberIndex = ClusterMember.findMemberIndex(oldMembers, memberId);
        if (-1 != memberIndex && 1 == oldMembers.length) {
            return EMPTY_MEMBERS;
        }
        return ArrayUtil.remove(oldMembers, memberIndex);
    }

    public static int highMemberId(ClusterMember[] clusterMembers) {
        int highId = -1;
        for (ClusterMember member : clusterMembers) {
            highId = Math.max(highId, member.id());
        }
        return highId;
    }

    public static String ingressEndpoints(ClusterMember[] members) {
        StringBuilder builder = new StringBuilder(100);
        int length = members.length;
        for (int i = 0; i < length; ++i) {
            if (0 != i) {
                builder.append(',');
            }
            ClusterMember member = members[i];
            builder.append(member.id()).append('=').append(member.ingressEndpoint());
        }
        return builder.toString();
    }

    private static void trySetMemberPublication(ClusterMember member, ChannelUri channelUri, int streamId, Aeron aeron, ErrorHandler errorHandler) {
        try {
            member.publication = aeron.addExclusivePublication(channelUri.toString(), streamId);
        }
        catch (RegistrationException ex) {
            errorHandler.onError(new ClusterException("failed to add consensus publication for member: " + member.id + " - " + ex.getMessage(), AeronException.Category.WARN));
        }
    }

    public String toString() {
        return "ClusterMember{id=" + this.id + ", isBallotSent=" + this.isBallotSent + ", isLeader=" + this.isLeader + ", hasRequestedJoin=" + this.hasRequestedJoin + ", leadershipTermId=" + this.leadershipTermId + ", logPosition=" + this.logPosition + ", candidateTermId=" + this.candidateTermId + ", catchupReplaySessionId=" + this.catchupReplaySessionId + ", correlationId=" + this.changeCorrelationId + ", removalPosition=" + this.removalPosition + ", timeOfLastAppendPositionNs=" + this.timeOfLastAppendPositionNs + ", ingressEndpoint='" + this.ingressEndpoint + '\'' + ", consensusEndpoint='" + this.consensusEndpoint + '\'' + ", logEndpoint='" + this.logEndpoint + '\'' + ", catchupEndpoint='" + this.catchupEndpoint + '\'' + ", archiveEndpoint='" + this.archiveEndpoint + '\'' + ", endpoints='" + this.endpoints + '\'' + ", publication=" + this.publication + ", vote=" + this.vote + '}';
    }
}

