/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.ClusterMembersExtendedResponseDecoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class ClusterMembersExtendedResponseEncoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 43;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 7;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ClusterMembersExtendedResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final ActiveMembersEncoder activeMembers = new ActiveMembersEncoder(this);
    private final PassiveMembersEncoder passiveMembers = new PassiveMembersEncoder(this);

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 43;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 7;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ClusterMembersExtendedResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 24);
        return this;
    }

    public ClusterMembersExtendedResponseEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(24).templateId(43).schemaId(111).version(7);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int correlationIdId() {
        return 1;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 0;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ClusterMembersExtendedResponseEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int currentTimeNsId() {
        return 2;
    }

    public static int currentTimeNsSinceVersion() {
        return 0;
    }

    public static int currentTimeNsEncodingOffset() {
        return 8;
    }

    public static int currentTimeNsEncodingLength() {
        return 8;
    }

    public static String currentTimeNsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long currentTimeNsNullValue() {
        return Long.MIN_VALUE;
    }

    public static long currentTimeNsMinValue() {
        return -9223372036854775807L;
    }

    public static long currentTimeNsMaxValue() {
        return Long.MAX_VALUE;
    }

    public ClusterMembersExtendedResponseEncoder currentTimeNs(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int leaderMemberIdId() {
        return 3;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 16;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ClusterMembersExtendedResponseEncoder leaderMemberId(int value) {
        this.buffer.putInt(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int memberIdId() {
        return 4;
    }

    public static int memberIdSinceVersion() {
        return 0;
    }

    public static int memberIdEncodingOffset() {
        return 20;
    }

    public static int memberIdEncodingLength() {
        return 4;
    }

    public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int memberIdMinValue() {
        return -2147483647;
    }

    public static int memberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ClusterMembersExtendedResponseEncoder memberId(int value) {
        this.buffer.putInt(this.offset + 20, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long activeMembersId() {
        return 5L;
    }

    public ActiveMembersEncoder activeMembersCount(int count) {
        this.activeMembers.wrap(this.buffer, count);
        return this.activeMembers;
    }

    public static long passiveMembersId() {
        return 15L;
    }

    public PassiveMembersEncoder passiveMembersCount(int count) {
        this.passiveMembers.wrap(this.buffer, count);
        return this.passiveMembers;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ClusterMembersExtendedResponseDecoder decoder = new ClusterMembersExtendedResponseDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 24, 7);
        return decoder.appendTo(builder);
    }

    public static final class PassiveMembersEncoder {
        public static final int HEADER_SIZE = 4;
        private final ClusterMembersExtendedResponseEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        PassiveMembersEncoder(ClusterMembersExtendedResponseEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            buffer.putShort(limit + 0, (short)28, ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, ByteOrder.LITTLE_ENDIAN);
        }

        public PassiveMembersEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + PassiveMembersEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putShort(this.initialLimit + 2, (short)this.count, ByteOrder.LITTLE_ENDIAN);
            return this.count;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 28;
        }

        public static int leadershipTermIdId() {
            return 16;
        }

        public static int leadershipTermIdSinceVersion() {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset() {
            return 0;
        }

        public static int leadershipTermIdEncodingLength() {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long leadershipTermIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long leadershipTermIdMinValue() {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public PassiveMembersEncoder leadershipTermId(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int logPositionId() {
            return 17;
        }

        public static int logPositionSinceVersion() {
            return 0;
        }

        public static int logPositionEncodingOffset() {
            return 8;
        }

        public static int logPositionEncodingLength() {
            return 8;
        }

        public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long logPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long logPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public PassiveMembersEncoder logPosition(long value) {
            this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int timeOfLastAppendNsId() {
            return 18;
        }

        public static int timeOfLastAppendNsSinceVersion() {
            return 0;
        }

        public static int timeOfLastAppendNsEncodingOffset() {
            return 16;
        }

        public static int timeOfLastAppendNsEncodingLength() {
            return 8;
        }

        public static String timeOfLastAppendNsMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long timeOfLastAppendNsNullValue() {
            return Long.MIN_VALUE;
        }

        public static long timeOfLastAppendNsMinValue() {
            return -9223372036854775807L;
        }

        public static long timeOfLastAppendNsMaxValue() {
            return Long.MAX_VALUE;
        }

        public PassiveMembersEncoder timeOfLastAppendNs(long value) {
            this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int memberIdId() {
            return 19;
        }

        public static int memberIdSinceVersion() {
            return 0;
        }

        public static int memberIdEncodingOffset() {
            return 24;
        }

        public static int memberIdEncodingLength() {
            return 4;
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int memberIdMinValue() {
            return -2147483647;
        }

        public static int memberIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public PassiveMembersEncoder memberId(int value) {
            this.buffer.putInt(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int ingressEndpointId() {
            return 20;
        }

        public static String ingressEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String ingressEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int ingressEndpointHeaderLength() {
            return 4;
        }

        public PassiveMembersEncoder putIngressEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder putIngressEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder ingressEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public PassiveMembersEncoder ingressEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }

        public static int consensusEndpointId() {
            return 21;
        }

        public static String consensusEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String consensusEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int consensusEndpointHeaderLength() {
            return 4;
        }

        public PassiveMembersEncoder putConsensusEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder putConsensusEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder consensusEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public PassiveMembersEncoder consensusEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }

        public static int logEndpointId() {
            return 22;
        }

        public static String logEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String logEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int logEndpointHeaderLength() {
            return 4;
        }

        public PassiveMembersEncoder putLogEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder putLogEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder logEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public PassiveMembersEncoder logEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }

        public static int catchupEndpointId() {
            return 23;
        }

        public static String catchupEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String catchupEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int catchupEndpointHeaderLength() {
            return 4;
        }

        public PassiveMembersEncoder putCatchupEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder putCatchupEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder catchupEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public PassiveMembersEncoder catchupEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }

        public static int archiveEndpointId() {
            return 24;
        }

        public static String archiveEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String archiveEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int archiveEndpointHeaderLength() {
            return 4;
        }

        public PassiveMembersEncoder putArchiveEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder putArchiveEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PassiveMembersEncoder archiveEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public PassiveMembersEncoder archiveEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }
    }

    public static final class ActiveMembersEncoder {
        public static final int HEADER_SIZE = 4;
        private final ClusterMembersExtendedResponseEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        ActiveMembersEncoder(ClusterMembersExtendedResponseEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            buffer.putShort(limit + 0, (short)28, ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, ByteOrder.LITTLE_ENDIAN);
        }

        public ActiveMembersEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + ActiveMembersEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putShort(this.initialLimit + 2, (short)this.count, ByteOrder.LITTLE_ENDIAN);
            return this.count;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 28;
        }

        public static int leadershipTermIdId() {
            return 6;
        }

        public static int leadershipTermIdSinceVersion() {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset() {
            return 0;
        }

        public static int leadershipTermIdEncodingLength() {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long leadershipTermIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long leadershipTermIdMinValue() {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public ActiveMembersEncoder leadershipTermId(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int logPositionId() {
            return 7;
        }

        public static int logPositionSinceVersion() {
            return 0;
        }

        public static int logPositionEncodingOffset() {
            return 8;
        }

        public static int logPositionEncodingLength() {
            return 8;
        }

        public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long logPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long logPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public ActiveMembersEncoder logPosition(long value) {
            this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int timeOfLastAppendNsId() {
            return 8;
        }

        public static int timeOfLastAppendNsSinceVersion() {
            return 0;
        }

        public static int timeOfLastAppendNsEncodingOffset() {
            return 16;
        }

        public static int timeOfLastAppendNsEncodingLength() {
            return 8;
        }

        public static String timeOfLastAppendNsMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long timeOfLastAppendNsNullValue() {
            return Long.MIN_VALUE;
        }

        public static long timeOfLastAppendNsMinValue() {
            return -9223372036854775807L;
        }

        public static long timeOfLastAppendNsMaxValue() {
            return Long.MAX_VALUE;
        }

        public ActiveMembersEncoder timeOfLastAppendNs(long value) {
            this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int memberIdId() {
            return 9;
        }

        public static int memberIdSinceVersion() {
            return 0;
        }

        public static int memberIdEncodingOffset() {
            return 24;
        }

        public static int memberIdEncodingLength() {
            return 4;
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int memberIdMinValue() {
            return -2147483647;
        }

        public static int memberIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public ActiveMembersEncoder memberId(int value) {
            this.buffer.putInt(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int ingressEndpointId() {
            return 10;
        }

        public static String ingressEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String ingressEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int ingressEndpointHeaderLength() {
            return 4;
        }

        public ActiveMembersEncoder putIngressEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder putIngressEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder ingressEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public ActiveMembersEncoder ingressEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }

        public static int consensusEndpointId() {
            return 11;
        }

        public static String consensusEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String consensusEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int consensusEndpointHeaderLength() {
            return 4;
        }

        public ActiveMembersEncoder putConsensusEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder putConsensusEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder consensusEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public ActiveMembersEncoder consensusEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }

        public static int logEndpointId() {
            return 12;
        }

        public static String logEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String logEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int logEndpointHeaderLength() {
            return 4;
        }

        public ActiveMembersEncoder putLogEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder putLogEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder logEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public ActiveMembersEncoder logEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }

        public static int catchupEndpointId() {
            return 13;
        }

        public static String catchupEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String catchupEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int catchupEndpointHeaderLength() {
            return 4;
        }

        public ActiveMembersEncoder putCatchupEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder putCatchupEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder catchupEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public ActiveMembersEncoder catchupEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }

        public static int archiveEndpointId() {
            return 14;
        }

        public static String archiveEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String archiveEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int archiveEndpointHeaderLength() {
            return 4;
        }

        public ActiveMembersEncoder putArchiveEndpoint(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder putArchiveEndpoint(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ActiveMembersEncoder archiveEndpoint(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public ActiveMembersEncoder archiveEndpoint(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i) {
                char charValue = value.charAt(i);
                byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
                this.buffer.putByte(limit + 4 + i, byteValue);
            }
            return this;
        }
    }
}

