/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.DirectBufferVector;
import io.aeron.Publication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.service.ClientSession;
import io.aeron.cluster.service.ClusteredServiceAgent;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.RegistrationException;
import io.aeron.logbuffer.BufferClaim;
import java.util.Arrays;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;

final class ContainerClientSession
implements ClientSession {
    private final long id;
    private final int responseStreamId;
    private final String responseChannel;
    private final byte[] encodedPrincipal;
    private final ClusteredServiceAgent clusteredServiceAgent;
    private Publication responsePublication;
    private boolean isClosing;

    ContainerClientSession(long sessionId, int responseStreamId, String responseChannel, byte[] encodedPrincipal, ClusteredServiceAgent clusteredServiceAgent) {
        this.id = sessionId;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.encodedPrincipal = encodedPrincipal;
        this.clusteredServiceAgent = clusteredServiceAgent;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int responseStreamId() {
        return this.responseStreamId;
    }

    @Override
    public String responseChannel() {
        return this.responseChannel;
    }

    @Override
    public byte[] encodedPrincipal() {
        return this.encodedPrincipal;
    }

    @Override
    public void close() {
        if (null != this.clusteredServiceAgent.getClientSession(this.id)) {
            this.clusteredServiceAgent.closeClientSession(this.id);
        }
    }

    @Override
    public boolean isClosing() {
        return this.isClosing;
    }

    @Override
    public long offer(DirectBuffer buffer, int offset, int length) {
        return this.clusteredServiceAgent.offer(this.id, this.responsePublication, buffer, offset, length);
    }

    @Override
    public long offer(DirectBufferVector[] vectors) {
        return this.clusteredServiceAgent.offer(this.id, this.responsePublication, vectors);
    }

    @Override
    public long tryClaim(int length, BufferClaim bufferClaim) {
        return this.clusteredServiceAgent.tryClaim(this.id, this.responsePublication, length, bufferClaim);
    }

    void connect(Aeron aeron) {
        try {
            if (null == this.responsePublication) {
                this.responsePublication = aeron.addPublication(this.responseChannel, this.responseStreamId);
            }
        }
        catch (RegistrationException ex) {
            this.clusteredServiceAgent.handleError(new ClusterException("failed to connect session response publication: " + ex.getMessage(), AeronException.Category.WARN));
        }
    }

    void markClosing() {
        this.isClosing = true;
    }

    void resetClosing() {
        this.isClosing = false;
    }

    void disconnect(ErrorHandler errorHandler) {
        CloseHelper.close(errorHandler, this.responsePublication);
        this.responsePublication = null;
    }

    public String toString() {
        return "ClientSession{id=" + this.id + ", responseStreamId=" + this.responseStreamId + ", responseChannel='" + this.responseChannel + '\'' + ", encodedPrincipal=" + Arrays.toString(this.encodedPrincipal) + ", clusteredServiceAgent=" + this.clusteredServiceAgent + ", responsePublication=" + this.responsePublication + ", isClosing=" + this.isClosing + '}';
    }
}

