/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.driver.status.StreamCounter;
import io.aeron.samples.SamplesUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.agrona.concurrent.status.CountersReader;

public final class StreamStat {
    private final CountersReader counters;

    public static void main(String[] args) {
        CountersReader counters = SamplesUtil.mapCounters();
        StreamStat streamStat = new StreamStat(counters);
        streamStat.print(System.out);
    }

    public StreamStat(CountersReader counters) {
        this.counters = counters;
    }

    public Map<StreamCompositeKey, List<StreamPosition>> snapshot() {
        HashMap<StreamCompositeKey, List<StreamPosition>> streams = new HashMap<StreamCompositeKey, List<StreamPosition>>();
        this.counters.forEach((counterId, typeId, keyBuffer, label) -> {
            if (typeId >= 1 && typeId <= 5 || typeId == 9 || typeId == 10 || typeId == 12) {
                StreamCompositeKey key = new StreamCompositeKey(keyBuffer.getInt(8), keyBuffer.getInt(12), keyBuffer.getStringAscii(16));
                StreamPosition position = new StreamPosition(keyBuffer.getLong(0), this.counters.getCounterValue(counterId), typeId);
                streams.computeIfAbsent(key, ignore -> new ArrayList()).add(position);
            }
        });
        return streams;
    }

    public int print(PrintStream out) {
        Map<StreamCompositeKey, List<StreamPosition>> streams = this.snapshot();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<StreamCompositeKey, List<StreamPosition>> entry : streams.entrySet()) {
            builder.setLength(0);
            StreamCompositeKey key = entry.getKey();
            builder.append("sessionId=").append(key.sessionId()).append(" streamId=").append(key.streamId()).append(" channel=").append(key.channel()).append(" :");
            for (StreamPosition streamPosition : entry.getValue()) {
                builder.append(' ').append(StreamCounter.labelName(streamPosition.typeId())).append(':').append(streamPosition.id()).append(':').append(streamPosition.value());
            }
            out.println(builder);
        }
        return streams.size();
    }

    public static final class StreamPosition {
        private final long id;
        private final long value;
        private final int typeId;

        public StreamPosition(long id, long value, int typeId) {
            this.id = id;
            this.value = value;
            this.typeId = typeId;
        }

        public long id() {
            return this.id;
        }

        public long value() {
            return this.value;
        }

        public int typeId() {
            return this.typeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StreamPosition)) {
                return false;
            }
            StreamPosition that = (StreamPosition)o;
            return this.id == that.id && this.value == that.value && this.typeId == that.typeId;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (int)(this.value ^ this.value >>> 32);
            result = 31 * result + this.typeId;
            return result;
        }

        public String toString() {
            return "StreamPosition{id=" + this.id + ", value=" + this.value + ", typeId=" + this.typeId + '}';
        }
    }

    public static final class StreamCompositeKey {
        private final int sessionId;
        private final int streamId;
        private final String channel;

        public StreamCompositeKey(int sessionId, int streamId, String channel) {
            Objects.requireNonNull(channel, "Channel cannot be null");
            this.sessionId = sessionId;
            this.streamId = streamId;
            this.channel = channel;
        }

        public int sessionId() {
            return this.sessionId;
        }

        public int streamId() {
            return this.streamId;
        }

        public String channel() {
            return this.channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StreamCompositeKey)) {
                return false;
            }
            StreamCompositeKey that = (StreamCompositeKey)o;
            return this.sessionId == that.sessionId && this.streamId == that.streamId && this.channel.equals(that.channel);
        }

        public int hashCode() {
            int result = this.sessionId;
            result = 31 * result + this.streamId;
            result = 31 * result + this.channel.hashCode();
            return result;
        }

        public String toString() {
            return "StreamCompositeKey{sessionId=" + this.sessionId + ", streamId=" + this.streamId + ", channel='" + this.channel + '\'' + '}';
        }
    }
}

