/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.archive.Archive;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.status.RecordingPos;
import io.aeron.driver.MediaDriver;
import io.aeron.samples.SampleConfiguration;
import io.aeron.samples.archive.Samples;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.SystemUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import org.agrona.console.ContinueBarrier;

public class EmbeddedRecordingThroughput
implements AutoCloseable {
    private static final long NUMBER_OF_MESSAGES = SampleConfiguration.NUMBER_OF_MESSAGES;
    private static final int MESSAGE_LENGTH = SampleConfiguration.MESSAGE_LENGTH;
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private final ArchivingMediaDriver archivingMediaDriver;
    private final Aeron aeron;
    private final AeronArchive aeronArchive;
    private final UnsafeBuffer buffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned(MESSAGE_LENGTH, 64));

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles(args);
        try (EmbeddedRecordingThroughput test = new EmbeddedRecordingThroughput();){
            test.startRecording();
            long previousRecordingId = -1L;
            ContinueBarrier barrier = new ContinueBarrier("Execute again?");
            do {
                if (-1L != previousRecordingId) {
                    test.truncateRecording(previousRecordingId);
                }
                previousRecordingId = test.streamMessagesForRecording();
            } while (barrier.await());
        }
    }

    EmbeddedRecordingThroughput() {
        String archiveDirName = Archive.Configuration.archiveDirName();
        File archiveDir = "aeron-archive".equals(archiveDirName) ? Samples.createTempDir() : new File(archiveDirName);
        this.archivingMediaDriver = ArchivingMediaDriver.launch(new MediaDriver.Context().spiesSimulateConnection(true).dirDeleteOnStart(true), new Archive.Context().recordingEventsEnabled(false).archiveDir(archiveDir));
        this.aeron = Aeron.connect();
        this.aeronArchive = AeronArchive.connect(new AeronArchive.Context().aeron(this.aeron));
    }

    @Override
    public void close() {
        CloseHelper.closeAll(this.aeronArchive, this.aeron, this.archivingMediaDriver, () -> this.archivingMediaDriver.archive().context().deleteDirectory(), () -> this.archivingMediaDriver.mediaDriver().context().deleteDirectory());
    }

    private long streamMessagesForRecording() {
        try (ExclusivePublication publication = this.aeron.addExclusivePublication(CHANNEL, STREAM_ID);){
            YieldingIdleStrategy idleStrategy = YieldingIdleStrategy.INSTANCE;
            while (!publication.isConnected()) {
                idleStrategy.idle();
            }
            long startNs = System.nanoTime();
            UnsafeBuffer buffer = this.buffer;
            for (long i = 0L; i < NUMBER_OF_MESSAGES; ++i) {
                buffer.putLong(0, i);
                idleStrategy.reset();
                while (publication.offer(buffer, 0, MESSAGE_LENGTH) < 0L) {
                    idleStrategy.idle();
                }
            }
            long stopPosition = publication.position();
            CountersReader counters = this.aeron.countersReader();
            int counterId = RecordingPos.findCounterIdBySession(counters, publication.sessionId());
            idleStrategy.reset();
            while (counters.getCounterValue(counterId) < stopPosition) {
                idleStrategy.idle();
            }
            long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            double dataRate = (double)stopPosition * 1000.0 / (double)durationMs / 1048576.0;
            double recordingMb = (double)stopPosition / 1048576.0;
            long msgRate = NUMBER_OF_MESSAGES / durationMs * 1000L;
            System.out.printf("Recorded %.02f MB @ %.02f MB/s - %,d msg/sec - %d byte payload + 32 byte header%n", recordingMb, dataRate, msgRate, MESSAGE_LENGTH);
            long l = RecordingPos.getRecordingId(counters, counterId);
            return l;
        }
    }

    private void startRecording() {
        this.aeronArchive.startRecording(CHANNEL, STREAM_ID, SourceLocation.LOCAL);
    }

    private void truncateRecording(long previousRecordingId) {
        this.aeronArchive.truncateRecording(previousRecordingId, 0L);
    }
}

