/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Aeron;
import io.aeron.CncFileDescriptor;
import io.aeron.DriverProxy;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorConsumer;
import org.agrona.concurrent.errors.ErrorLogReader;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public class CommonContext
implements Cloneable {
    public static final String DRIVER_TIMEOUT_PROP_NAME = "aeron.driver.timeout";
    public static final String DEBUG_TIMEOUT_PROP_NAME = "aeron.debug.timeout";
    public static final long DEFAULT_DRIVER_TIMEOUT_MS = 10000L;
    public static final long DRIVER_TIMEOUT_MS;
    public static final int NULL_SESSION_ID = -1;
    public static final String AERON_DIR_PROP_NAME = "aeron.dir";
    public static final String AERON_DIR_PROP_DEFAULT;
    public static final String IPC_MEDIA = "ipc";
    public static final String UDP_MEDIA = "udp";
    public static final String IPC_CHANNEL = "aeron:ipc";
    public static final String UDP_CHANNEL = "aeron:udp";
    public static final String SPY_PREFIX = "aeron-spy:";
    public static final String ENDPOINT_PARAM_NAME = "endpoint";
    public static final String INTERFACE_PARAM_NAME = "interface";
    public static final String INITIAL_TERM_ID_PARAM_NAME = "init-term-id";
    public static final String TERM_ID_PARAM_NAME = "term-id";
    public static final String TERM_OFFSET_PARAM_NAME = "term-offset";
    public static final String TERM_LENGTH_PARAM_NAME = "term-length";
    public static final String MTU_LENGTH_PARAM_NAME = "mtu";
    public static final String TTL_PARAM_NAME = "ttl";
    public static final String MDC_CONTROL_PARAM_NAME = "control";
    public static final String MDC_CONTROL_MODE_PARAM_NAME = "control-mode";
    public static final String MDC_CONTROL_MODE_MANUAL = "manual";
    public static final String MDC_CONTROL_MODE_DYNAMIC = "dynamic";
    public static final String SESSION_ID_PARAM_NAME = "session-id";
    public static final String LINGER_PARAM_NAME = "linger";
    public static final String RELIABLE_STREAM_PARAM_NAME = "reliable";
    public static final String TAGS_PARAM_NAME = "tags";
    public static final String TAG_PREFIX = "tag:";
    public static final String SPARSE_PARAM_NAME = "sparse";
    public static final String ALIAS_PARAM_NAME = "alias";
    public static final String EOS_PARAM_NAME = "eos";
    public static final String TETHER_PARAM_NAME = "tether";
    public static final String GROUP_PARAM_NAME = "group";
    public static final String REJOIN_PARAM_NAME = "rejoin";
    public static final String CONGESTION_CONTROL_PARAM_NAME = "cc";
    public static final String FLOW_CONTROL_PARAM_NAME = "fc";
    public static final String GROUP_TAG_PARAM_NAME = "gtag";
    public static final String SPIES_SIMULATE_CONNECTION_PARAM_NAME = "ssc";
    public static final String SOCKET_SNDBUF_PARAM_NAME = "so-sndbuf";
    public static final String SOCKET_RCVBUF_PARAM_NAME = "so-rcvbuf";
    public static final String RECEIVER_WINDOW_LENGTH_PARAM_NAME = "rcv-wnd";
    public static final String MEDIA_RCV_TIMESTAMP_OFFSET_PARAM_NAME = "media-rcv-ts-offset";
    public static final String CHANNEL_RECEIVE_TIMESTAMP_OFFSET_PARAM_NAME = "channel-rcv-ts-offset";
    public static final String CHANNEL_SEND_TIMESTAMP_OFFSET_PARAM_NAME = "channel-snd-ts-offset";
    public static final String RESERVED_OFFSET = "reserved";
    private static final AtomicIntegerFieldUpdater<CommonContext> IS_CONCLUDED_UPDATER;
    private static final Map<String, Boolean> DEBUG_FIELDS_SEEN;
    private volatile int isConcluded;
    private long driverTimeoutMs = DRIVER_TIMEOUT_MS;
    private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
    private File aeronDirectory;
    private File cncFile;
    private UnsafeBuffer countersMetaDataBuffer;
    private UnsafeBuffer countersValuesBuffer;

    public CommonContext clone() {
        try {
            return (CommonContext)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getAeronDirectoryName() {
        return System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT);
    }

    public static String generateRandomDirName() {
        return AERON_DIR_PROP_DEFAULT + "-" + UUID.randomUUID();
    }

    public CommonContext conclude() {
        if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
            throw new ConcurrentConcludeException();
        }
        this.concludeAeronDirectory();
        this.cncFile = new File(this.aeronDirectory, "cnc.dat");
        return this;
    }

    public boolean isConcluded() {
        return 1 == this.isConcluded;
    }

    public CommonContext concludeAeronDirectory() {
        if (null == this.aeronDirectory) {
            this.aeronDirectory = new File(this.aeronDirectoryName);
        }
        return this;
    }

    public String aeronDirectoryName() {
        return this.aeronDirectoryName;
    }

    public File aeronDirectory() {
        return this.aeronDirectory;
    }

    public CommonContext aeronDirectoryName(String dirName) {
        this.aeronDirectoryName = dirName;
        return this;
    }

    public static File newDefaultCncFile() {
        return new File(System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT), "cnc.dat");
    }

    public static File newCncFile(String aeronDirectoryName) {
        return new File(aeronDirectoryName, "cnc.dat");
    }

    public UnsafeBuffer countersMetaDataBuffer() {
        return this.countersMetaDataBuffer;
    }

    public CommonContext countersMetaDataBuffer(UnsafeBuffer countersMetaDataBuffer) {
        this.countersMetaDataBuffer = countersMetaDataBuffer;
        return this;
    }

    public UnsafeBuffer countersValuesBuffer() {
        return this.countersValuesBuffer;
    }

    public CommonContext countersValuesBuffer(UnsafeBuffer countersValuesBuffer) {
        this.countersValuesBuffer = countersValuesBuffer;
        return this;
    }

    public File cncFile() {
        return this.cncFile;
    }

    public CommonContext driverTimeoutMs(long driverTimeoutMs) {
        this.driverTimeoutMs = driverTimeoutMs;
        return this;
    }

    public long driverTimeoutMs() {
        return CommonContext.checkDebugTimeout(this.driverTimeoutMs, TimeUnit.MILLISECONDS);
    }

    public static long checkDebugTimeout(long timeout, TimeUnit timeUnit) {
        String debugTimeoutString = System.getProperty(DEBUG_TIMEOUT_PROP_NAME);
        if (null == debugTimeoutString || !SystemUtil.isDebuggerAttached()) {
            return timeout;
        }
        try {
            long debugTimeoutNs = SystemUtil.parseDuration(DEBUG_TIMEOUT_PROP_NAME, debugTimeoutString);
            long debugTimeout = timeUnit.convert(debugTimeoutNs, TimeUnit.NANOSECONDS);
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String methodName = stackTrace[2].getMethodName();
            String className = stackTrace[2].getClassName();
            String debugFieldName = className + "." + methodName;
            if (null == DEBUG_FIELDS_SEEN.putIfAbsent(debugFieldName, true)) {
                String message = "Using debug timeout [" + debugTimeout + "] for " + debugFieldName + " replacing [" + timeout + "]";
                System.out.println(message);
            }
            return debugTimeout;
        }
        catch (NumberFormatException ignore) {
            return timeout;
        }
    }

    public void deleteAeronDirectory() {
        IoUtil.delete(this.aeronDirectory, false);
    }

    public MappedByteBuffer mapExistingCncFile(Consumer<String> logger) {
        File cncFile = new File(this.aeronDirectory, "cnc.dat");
        if (cncFile.exists() && cncFile.length() > 0L) {
            if (null != logger) {
                logger.accept("INFO: Aeron CnC file exists: " + cncFile);
            }
            return IoUtil.mapExistingFile(cncFile, "cnc.dat");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDriverActive(File directory, long driverTimeoutMs, Consumer<String> logger) {
        File cncFile = new File(directory, "cnc.dat");
        if (cncFile.exists() && cncFile.length() > 0L) {
            logger.accept("INFO: Aeron CnC file exists: " + cncFile);
            MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, "CnC file");
            try {
                boolean bl = CommonContext.isDriverActive(driverTimeoutMs, logger, cncByteBuffer);
                return bl;
            }
            finally {
                BufferUtil.free(cncByteBuffer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDriverActive(long driverTimeoutMs, Consumer<String> logger) {
        MappedByteBuffer cncByteBuffer = this.mapExistingCncFile(logger);
        try {
            boolean bl = CommonContext.isDriverActive(driverTimeoutMs, logger, cncByteBuffer);
            return bl;
        }
        finally {
            BufferUtil.free(cncByteBuffer);
        }
    }

    public static boolean isDriverActive(long driverTimeoutMs, Consumer<String> logger, ByteBuffer cncByteBuffer) {
        int cncVersion;
        if (null == cncByteBuffer) {
            return false;
        }
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        long startTimeMs = System.currentTimeMillis();
        while (0 == (cncVersion = cncMetaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0)))) {
            if (System.currentTimeMillis() > startTimeMs + driverTimeoutMs) {
                throw new DriverTimeoutException("CnC file is created but not initialised.");
            }
            Aeron.sleep(1L);
        }
        CncFileDescriptor.checkVersion(cncVersion);
        ManyToOneRingBuffer toDriverBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(cncByteBuffer, cncMetaDataBuffer));
        long timestampMs = toDriverBuffer.consumerHeartbeatTime();
        long nowMs = System.currentTimeMillis();
        long timestampAgeMs = nowMs - timestampMs;
        logger.accept("INFO: Aeron toDriver consumer heartbeat is (ms): " + timestampAgeMs);
        return timestampAgeMs <= driverTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requestDriverTermination(File directory, DirectBuffer tokenBuffer, int tokenOffset, int tokenLength) {
        File cncFile = new File(directory, "cnc.dat");
        if (cncFile.exists() && cncFile.length() > 0L) {
            MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, "CnC file");
            try {
                UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
                int cncVersion = cncMetaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0));
                CncFileDescriptor.checkVersion(cncVersion);
                ManyToOneRingBuffer toDriverBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(cncByteBuffer, cncMetaDataBuffer));
                long clientId = toDriverBuffer.nextCorrelationId();
                DriverProxy driverProxy = new DriverProxy(toDriverBuffer, clientId);
                boolean bl = driverProxy.terminateDriver(tokenBuffer, tokenOffset, tokenLength);
                return bl;
            }
            finally {
                BufferUtil.free(cncByteBuffer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveErrorLog(PrintStream out) {
        MappedByteBuffer cncByteBuffer = this.mapExistingCncFile(null);
        try {
            int n = this.saveErrorLog(out, cncByteBuffer);
            return n;
        }
        finally {
            BufferUtil.free(cncByteBuffer);
        }
    }

    public int saveErrorLog(PrintStream out, ByteBuffer cncByteBuffer) {
        if (null == cncByteBuffer) {
            return 0;
        }
        return CommonContext.printErrorLog(CommonContext.errorLogBuffer(cncByteBuffer), out);
    }

    public void close() {
    }

    public static int printErrorLog(AtomicBuffer errorBuffer, PrintStream out) {
        int distinctErrorCount = 0;
        if (errorBuffer.capacity() > 0 && ErrorLogReader.hasErrors(errorBuffer)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            ErrorConsumer errorConsumer = (count, firstTimestamp, lastTimestamp, ex) -> out.format("***%n%d observations from %s to %s for:%n %s%n", count, dateFormat.format(new Date(firstTimestamp)), dateFormat.format(new Date(lastTimestamp)), ex);
            distinctErrorCount = ErrorLogReader.read(errorBuffer, errorConsumer);
            out.format("%n%d distinct errors observed.%n", distinctErrorCount);
        }
        return distinctErrorCount;
    }

    public static AtomicBuffer errorLogBuffer(ByteBuffer cncByteBuffer) {
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        CncFileDescriptor.checkVersion(cncVersion);
        return CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, cncMetaDataBuffer);
    }

    static {
        File devShmDir;
        DRIVER_TIMEOUT_MS = Long.getLong(DRIVER_TIMEOUT_PROP_NAME, 10000L);
        IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CommonContext.class, "isConcluded");
        DEBUG_FIELDS_SEEN = new ConcurrentHashMap<String, Boolean>();
        String baseDirName = null;
        if (SystemUtil.isLinux() && (devShmDir = new File("/dev/shm")).exists()) {
            baseDirName = "/dev/shm/aeron";
        }
        if (null == baseDirName) {
            baseDirName = SystemUtil.tmpDirName() + "aeron";
        }
        AERON_DIR_PROP_DEFAULT = baseDirName + '-' + System.getProperty("user.name", "default");
    }

    public static enum InferableBoolean {
        FORCE_FALSE,
        FORCE_TRUE,
        INFER;


        public static InferableBoolean parse(String value) {
            if (null == value || "infer".equals(value)) {
                return INFER;
            }
            return "true".equals(value) ? FORCE_TRUE : FORCE_FALSE;
        }
    }
}

