/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Image;
import io.aeron.ImageControlledFragmentAssembler;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterMembersDecoder;
import io.aeron.cluster.codecs.ClusterSessionDecoder;
import io.aeron.cluster.codecs.ConsensusModuleDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.SnapshotMarkerDecoder;
import io.aeron.cluster.codecs.TimerDecoder;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;

class ConsensusModuleSnapshotLoader
implements ControlledFragmentHandler {
    static final int FRAGMENT_LIMIT = 10;
    private boolean inSnapshot = false;
    private boolean isDone = false;
    private int appVersion;
    private TimeUnit timeUnit;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SnapshotMarkerDecoder snapshotMarkerDecoder = new SnapshotMarkerDecoder();
    private final ClusterSessionDecoder clusterSessionDecoder = new ClusterSessionDecoder();
    private final TimerDecoder timerDecoder = new TimerDecoder();
    private final ConsensusModuleDecoder consensusModuleDecoder = new ConsensusModuleDecoder();
    private final ClusterMembersDecoder clusterMembersDecoder = new ClusterMembersDecoder();
    private final ImageControlledFragmentAssembler fragmentAssembler = new ImageControlledFragmentAssembler(this);
    private final Image image;
    private final ConsensusModuleAgent consensusModuleAgent;

    ConsensusModuleSnapshotLoader(Image image, ConsensusModuleAgent agent) {
        this.image = image;
        this.consensusModuleAgent = agent;
    }

    boolean isDone() {
        return this.isDone;
    }

    public int appVersion() {
        return this.appVersion;
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    int poll() {
        return this.image.controlledPoll(this.fragmentAssembler, 10);
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        switch (templateId) {
            case 1: {
                this.consensusModuleAgent.onLoadPendingMessage(buffer, offset, length);
                break;
            }
            case 100: {
                this.snapshotMarkerDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long typeId = this.snapshotMarkerDecoder.typeId();
                if (typeId != 1L) {
                    throw new ClusterException("unexpected snapshot type: " + typeId);
                }
                switch (this.snapshotMarkerDecoder.mark()) {
                    case BEGIN: {
                        if (this.inSnapshot) {
                            throw new ClusterException("already in snapshot");
                        }
                        this.inSnapshot = true;
                        this.appVersion = this.snapshotMarkerDecoder.appVersion();
                        this.timeUnit = ClusterClock.map(this.snapshotMarkerDecoder.timeUnit());
                        return ControlledFragmentHandler.Action.CONTINUE;
                    }
                    case END: {
                        if (!this.inSnapshot) {
                            throw new ClusterException("missing begin snapshot");
                        }
                        this.isDone = true;
                        return ControlledFragmentHandler.Action.BREAK;
                    }
                }
                break;
            }
            case 103: {
                this.clusterSessionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onLoadSession(this.clusterSessionDecoder.clusterSessionId(), this.clusterSessionDecoder.correlationId(), this.clusterSessionDecoder.openedLogPosition(), this.clusterSessionDecoder.timeOfLastActivity(), this.clusterSessionDecoder.closeReason(), this.clusterSessionDecoder.responseStreamId(), this.clusterSessionDecoder.responseChannel());
                break;
            }
            case 104: {
                this.timerDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onScheduleTimer(this.timerDecoder.correlationId(), this.timerDecoder.deadline());
                break;
            }
            case 105: {
                this.consensusModuleDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onLoadConsensusModuleState(this.consensusModuleDecoder.nextSessionId(), this.consensusModuleDecoder.nextServiceSessionId(), this.consensusModuleDecoder.logServiceSessionId(), this.consensusModuleDecoder.pendingMessageCapacity());
                break;
            }
            case 106: {
                this.clusterMembersDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onLoadClusterMembers(this.clusterMembersDecoder.memberId(), this.clusterMembersDecoder.highMemberId(), this.clusterMembersDecoder.clusterMembers());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

