/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.ConsensusModuleSnapshotTaker;
import java.util.concurrent.TimeUnit;
import org.agrona.DeadlineTimerWheel;
import org.agrona.collections.Long2LongHashMap;

class TimerService
extends DeadlineTimerWheel
implements DeadlineTimerWheel.TimerHandler {
    private static final int POLL_LIMIT = 20;
    private boolean isAbort;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final Long2LongHashMap timerIdByCorrelationIdMap = new Long2LongHashMap(Long.MAX_VALUE);
    private final Long2LongHashMap correlationIdByTimerIdMap = new Long2LongHashMap(Long.MAX_VALUE);

    TimerService(ConsensusModuleAgent consensusModuleAgent, TimeUnit timeUnit, long startTime, long tickResolution, int ticksPerWheel) {
        super(timeUnit, startTime, tickResolution, ticksPerWheel);
        this.consensusModuleAgent = consensusModuleAgent;
    }

    int poll(long now) {
        int expired = 0;
        this.isAbort = false;
        while (!this.isAbort && (expired += super.poll(now, this, 20)) < 20 && super.currentTickTime() < now) {
        }
        return expired;
    }

    @Override
    public boolean onTimerExpiry(TimeUnit timeUnit, long now, long timerId) {
        long correlationId = this.correlationIdByTimerIdMap.get(timerId);
        if (this.consensusModuleAgent.onTimerEvent(correlationId)) {
            this.correlationIdByTimerIdMap.remove(timerId);
            this.timerIdByCorrelationIdMap.remove(correlationId);
            return true;
        }
        this.isAbort = true;
        return false;
    }

    void scheduleTimerForCorrelationId(long correlationId, long deadline) {
        this.cancelTimerByCorrelationId(correlationId);
        long timerId = super.scheduleTimer(deadline);
        this.timerIdByCorrelationIdMap.put(correlationId, timerId);
        this.correlationIdByTimerIdMap.put(timerId, correlationId);
    }

    boolean cancelTimerByCorrelationId(long correlationId) {
        long timerId = this.timerIdByCorrelationIdMap.remove(correlationId);
        if (Long.MAX_VALUE != timerId) {
            super.cancelTimer(timerId);
            this.correlationIdByTimerIdMap.remove(timerId);
            return true;
        }
        return false;
    }

    void snapshot(ConsensusModuleSnapshotTaker snapshotTaker) {
        Long2LongHashMap.EntryIterator iter = this.timerIdByCorrelationIdMap.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            long correlationId = iter.getLongKey();
            long deadline = super.deadline(iter.getLongValue());
            snapshotTaker.snapshotTimer(correlationId, deadline);
        }
    }
}

