/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CommonContext;
import io.aeron.samples.SamplesUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Function;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorLogReader;

public class ErrorStat {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    private static final String ERROR_FILE_NAME_PROP = "aeron.samples.error.file.name";
    private static final String ERROR_FILE_NAME = System.getProperty("aeron.samples.error.file.name");
    private static final String ERROR_FILE_OFFSET_PROP = "aeron.samples.error.file.offset";
    private static final int ERROR_FILE_OFFSET = Integer.parseInt(System.getProperty("aeron.samples.error.file.offset", "0"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Function<MappedByteBuffer, AtomicBuffer> mmapToErrorBuffer;
        MappedByteBuffer errorMmap;
        if (null != ERROR_FILE_NAME) {
            File errorFile = new File(ERROR_FILE_NAME);
            System.out.println("Error file " + errorFile);
            errorMmap = SamplesUtil.mapExistingFileReadOnly(errorFile);
            mmapToErrorBuffer = mmap -> new UnsafeBuffer((ByteBuffer)mmap, ERROR_FILE_OFFSET, errorMmap.capacity() - ERROR_FILE_OFFSET);
        } else {
            File cncFile = CommonContext.newDefaultCncFile();
            System.out.println("Command `n Control file " + cncFile);
            errorMmap = SamplesUtil.mapExistingFileReadOnly(cncFile);
            mmapToErrorBuffer = CommonContext::errorLogBuffer;
        }
        try {
            AtomicBuffer buffer = mmapToErrorBuffer.apply(errorMmap);
            int distinctErrorCount = ErrorLogReader.read(buffer, ErrorStat::accept);
            System.out.format("%n%d distinct errors observed.%n", distinctErrorCount);
        }
        finally {
            IoUtil.unmap(errorMmap);
        }
    }

    private static void accept(int observationCount, long firstObservationTimestamp, long lastObservationTimestamp, String encodedException) {
        System.out.format("***%n%d observations from %s to %s for:%n %s%n", observationCount, DATE_FORMAT.format(new Date(firstObservationTimestamp)), DATE_FORMAT.format(new Date(lastObservationTimestamp)), encodedException);
    }
}

