/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.samples.RateReporterRhsPadding;
import java.util.concurrent.locks.LockSupport;
import org.agrona.UnsafeAccess;

public final class RateReporter
extends RateReporterRhsPadding
implements Runnable {
    private final long reportIntervalNs;
    private final long parkNs;
    private long lastTotalBytes;
    private long lastTotalMessages;
    private long lastTimestamp;
    private volatile boolean running = true;
    private final Reporter reportingFunc;

    public RateReporter(long reportInterval, Reporter reportingFunc) {
        this.reportIntervalNs = reportInterval;
        this.parkNs = reportInterval;
        this.reportingFunc = reportingFunc;
        this.lastTimestamp = System.nanoTime();
    }

    @Override
    public void run() {
        do {
            LockSupport.parkNanos(this.parkNs);
            long currentTotalMessages = this.totalMessages;
            long currentTotalBytes = this.totalBytes;
            long currentTimestamp = System.nanoTime();
            long timeSpanNs = currentTimestamp - this.lastTimestamp;
            double messagesPerSec = (double)(currentTotalMessages - this.lastTotalMessages) * (double)this.reportIntervalNs / (double)timeSpanNs;
            double bytesPerSec = (double)(currentTotalBytes - this.lastTotalBytes) * (double)this.reportIntervalNs / (double)timeSpanNs;
            this.reportingFunc.onReport(messagesPerSec, bytesPerSec, currentTotalMessages, currentTotalBytes);
            this.lastTotalBytes = currentTotalBytes;
            this.lastTotalMessages = currentTotalMessages;
            this.lastTimestamp = currentTimestamp;
        } while (this.running);
    }

    public void halt() {
        this.running = false;
    }

    public void onMessage(long length) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, TOTAL_BYTES_OFFSET, this.totalBytes + length);
        UnsafeAccess.UNSAFE.putOrderedLong(this, TOTAL_MESSAGES_OFFSET, this.totalMessages + 1L);
    }

    @FunctionalInterface
    public static interface Reporter {
        public void onReport(double var1, double var3, long var5, long var7);
    }
}

