/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.protocol.HeaderFlyweight;
import io.aeron.samples.RateReporter;
import io.aeron.samples.SampleConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.agrona.LangUtil;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersReader;

public class SamplesUtil {
    public static Consumer<Subscription> subscriberLoop(FragmentHandler fragmentHandler, int limit, AtomicBoolean running) {
        return SamplesUtil.subscriberLoop(fragmentHandler, limit, running, SampleConfiguration.newIdleStrategy());
    }

    public static Consumer<Subscription> subscriberLoop(FragmentHandler fragmentHandler, int limit, AtomicBoolean running, IdleStrategy idleStrategy) {
        return subscription -> {
            FragmentAssembler assembler = new FragmentAssembler(fragmentHandler);
            while (running.get()) {
                int fragmentsRead = subscription.poll(assembler, limit);
                idleStrategy.idle(fragmentsRead);
            }
        };
    }

    public static FragmentHandler printAsciiMessage(int streamId) {
        return (buffer, offset, length, header) -> {
            String msg = buffer.getStringWithoutLengthAscii(offset, length);
            System.out.printf("Message to stream %d from session %d (%d@%d) <<%s>>%n", streamId, header.sessionId(), length, offset, msg);
        };
    }

    public static FragmentHandler rateReporterHandler(RateReporter reporter) {
        return (buffer, offset, length, header) -> reporter.onMessage(length);
    }

    public static void printError(String channel, int streamId, int sessionId, String message, HeaderFlyweight cause) {
        System.out.println(message);
    }

    public static void printRate(double messagesPerSec, double bytesPerSec, long totalMessages, long totalBytes) {
        System.out.printf("%.04g msgs/sec, %.04g payload bytes/sec, totals %d messages %d MB%n", messagesPerSec, bytesPerSec, totalMessages, totalBytes / 0x100000L);
    }

    public static void printAvailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.printf("Available image on %s streamId=%d sessionId=%d from %s%n", subscription.channel(), subscription.streamId(), image.sessionId(), image.sourceIdentity());
    }

    public static void printUnavailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.printf("Unavailable image on %s streamId=%d sessionId=%d%n", subscription.channel(), subscription.streamId(), image.sessionId());
    }

    public static MappedByteBuffer mapExistingFileReadOnly(File location) {
        if (!location.exists()) {
            String msg = "file not found: " + location.getAbsolutePath();
            throw new IllegalStateException(msg);
        }
        MappedByteBuffer mappedByteBuffer = null;
        try (RandomAccessFile file = new RandomAccessFile(location, "r");
             FileChannel channel = file.getChannel();){
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return mappedByteBuffer;
    }

    public static CountersReader mapCounters() {
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        MappedByteBuffer cncByteBuffer = SamplesUtil.mapExistingFileReadOnly(cncFile);
        UnsafeBuffer cncMetaData = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaData.getInt(CncFileDescriptor.cncVersionOffset(0));
        CncFileDescriptor.checkVersion(cncVersion);
        return new CountersReader(CncFileDescriptor.createCountersMetaDataBuffer(cncByteBuffer, cncMetaData), CncFileDescriptor.createCountersValuesBuffer(cncByteBuffer, cncMetaData));
    }

    public static CountersReader mapCounters(MutableInteger cncFileVersion) {
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        MappedByteBuffer cncByteBuffer = SamplesUtil.mapExistingFileReadOnly(cncFile);
        UnsafeBuffer cncMetaData = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaData.getInt(CncFileDescriptor.cncVersionOffset(0));
        cncFileVersion.set(cncVersion);
        CncFileDescriptor.checkVersion(cncVersion);
        return new CountersReader(CncFileDescriptor.createCountersMetaDataBuffer(cncByteBuffer, cncMetaData), CncFileDescriptor.createCountersValuesBuffer(cncByteBuffer, cncMetaData));
    }
}

