/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.cluster;

import io.aeron.CommonContext;
import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.service.ClusteredService;
import io.aeron.cluster.service.ClusteredServiceContainer;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.MinMulticastFlowControlSupplier;
import io.aeron.driver.ThreadingMode;
import java.io.File;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.NoOpLock;

public final class ClusterConfig {
    public static final int PORTS_PER_NODE = 100;
    public static final int ARCHIVE_CONTROL_PORT_OFFSET = 1;
    public static final int CLIENT_FACING_PORT_OFFSET = 2;
    public static final int MEMBER_FACING_PORT_OFFSET = 3;
    public static final int LOG_PORT_OFFSET = 4;
    public static final int TRANSFER_PORT_OFFSET = 5;
    private final MediaDriver.Context mediaDriverContext;
    private final Archive.Context archiveContext;
    private final AeronArchive.Context aeronArchiveContext;
    private final ConsensusModule.Context consensusModuleContext;
    private final ClusteredServiceContainer.Context clusteredServiceContext;

    ClusterConfig(MediaDriver.Context mediaDriverContext, Archive.Context archiveContext, AeronArchive.Context aeronArchiveContext, ConsensusModule.Context consensusModuleContext, ClusteredServiceContainer.Context clusteredServiceContext) {
        this.mediaDriverContext = mediaDriverContext;
        this.archiveContext = archiveContext;
        this.aeronArchiveContext = aeronArchiveContext;
        this.consensusModuleContext = consensusModuleContext;
        this.clusteredServiceContext = clusteredServiceContext;
    }

    public static ClusterConfig create(int nodeId, List<String> ingressHostnames, List<String> clusterHostnames, int portBase, ClusteredService clusteredService) {
        if (nodeId >= ingressHostnames.size()) {
            throw new IllegalArgumentException("nodeId=" + nodeId + " >= ingressHostnames.size()=" + ingressHostnames.size());
        }
        String clusterMembers = ClusterConfig.clusterMembers(ingressHostnames, clusterHostnames, portBase);
        String aeronDirName = CommonContext.getAeronDirectoryName() + "-" + nodeId + "-driver";
        File baseDir = new File(System.getProperty("user.dir"), "aeron-cluster-" + nodeId);
        String hostname = clusterHostnames.get(nodeId);
        MediaDriver.Context mediaDriverContext = new MediaDriver.Context().aeronDirectoryName(aeronDirName).threadingMode(ThreadingMode.SHARED).termBufferSparseFile(true).multicastFlowControlSupplier(new MinMulticastFlowControlSupplier());
        AeronArchive.Context replicationArchiveContext = new AeronArchive.Context().controlResponseChannel("aeron:udp?endpoint=" + hostname + ":0");
        Archive.Context archiveContext = new Archive.Context().aeronDirectoryName(aeronDirName).archiveDir(new File(baseDir, "archive")).controlChannel(ClusterConfig.udpChannel(nodeId, hostname, portBase, 1)).archiveClientContext(replicationArchiveContext).localControlChannel("aeron:ipc?term-length=64k").recordingEventsEnabled(false).threadingMode(ArchiveThreadingMode.SHARED);
        AeronArchive.Context aeronArchiveContext = new AeronArchive.Context().lock(NoOpLock.INSTANCE).controlRequestChannel(archiveContext.localControlChannel()).controlRequestStreamId(archiveContext.localControlStreamId()).controlResponseChannel(archiveContext.localControlChannel()).aeronDirectoryName(aeronDirName);
        ConsensusModule.Context consensusModuleContext = new ConsensusModule.Context().clusterMemberId(nodeId).clusterMembers(clusterMembers).clusterDir(new File(baseDir, "consensus-module")).archiveContext(aeronArchiveContext.clone()).replicationChannel("aeron:udp?endpoint=" + hostname + ":0");
        ClusteredServiceContainer.Context clusteredServiceContext = new ClusteredServiceContainer.Context().aeronDirectoryName(aeronDirName).archiveContext(aeronArchiveContext.clone()).clusterDir(new File(baseDir, "service")).clusteredService(clusteredService);
        return new ClusterConfig(mediaDriverContext, archiveContext, aeronArchiveContext, consensusModuleContext, clusteredServiceContext);
    }

    public static ClusterConfig create(int nodeId, List<String> hostnames, int portBase, ClusteredService clusteredService) {
        return ClusterConfig.create(nodeId, hostnames, hostnames, portBase, clusteredService);
    }

    public void errorHandler(ErrorHandler errorHandler) {
        this.mediaDriverContext.errorHandler(errorHandler);
        this.archiveContext.errorHandler(errorHandler);
        this.aeronArchiveContext.errorHandler(errorHandler);
        this.consensusModuleContext.errorHandler(errorHandler);
        this.clusteredServiceContext.errorHandler(errorHandler);
    }

    public void aeronDirectoryName(String aeronDir) {
        this.mediaDriverContext.aeronDirectoryName(aeronDir);
        this.archiveContext.aeronDirectoryName(aeronDir);
        this.aeronArchiveContext.aeronDirectoryName(aeronDir);
        this.consensusModuleContext.aeronDirectoryName(aeronDir);
        this.clusteredServiceContext.aeronDirectoryName(aeronDir);
    }

    public MediaDriver.Context mediaDriverContext() {
        return this.mediaDriverContext;
    }

    public Archive.Context archiveContext() {
        return this.archiveContext;
    }

    public AeronArchive.Context aeronArchiveContext() {
        return this.aeronArchiveContext;
    }

    public ConsensusModule.Context consensusModuleContext() {
        return this.consensusModuleContext;
    }

    public ClusteredServiceContainer.Context clusteredServiceContext() {
        return this.clusteredServiceContext;
    }

    public static String clusterMembers(List<String> ingressHostnames, List<String> clusterHostnames, int portBase) {
        if (ingressHostnames.size() != clusterHostnames.size()) {
            throw new IllegalArgumentException("ingressHostnames and clusterHostnames must be the same size");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ingressHostnames.size(); ++i) {
            sb.append(i);
            sb.append(',').append(ClusterConfig.endpoint(i, ingressHostnames.get(i), portBase, 2));
            sb.append(',').append(ClusterConfig.endpoint(i, clusterHostnames.get(i), portBase, 3));
            sb.append(',').append(ClusterConfig.endpoint(i, clusterHostnames.get(i), portBase, 4));
            sb.append(',').append(ClusterConfig.endpoint(i, clusterHostnames.get(i), portBase, 5));
            sb.append(',').append(ClusterConfig.endpoint(i, clusterHostnames.get(i), portBase, 1));
            sb.append('|');
        }
        return sb.toString();
    }

    public static String ingressEndpoints(List<String> hostnames, int portBase, int clientFacingPortOffset) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hostnames.size(); ++i) {
            sb.append(i).append('=');
            sb.append(hostnames.get(i)).append(':').append(ClusterConfig.calculatePort(i, portBase, clientFacingPortOffset));
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    static int calculatePort(int nodeId, int portBase, int offset) {
        return portBase + nodeId * 100 + offset;
    }

    private static String udpChannel(int nodeId, String hostname, int portBase, int portOffset) {
        int port = ClusterConfig.calculatePort(nodeId, portBase, portOffset);
        return "aeron:udp?endpoint=" + hostname + ":" + port;
    }

    private static String endpoint(int nodeId, String hostname, int portBase, int portOffset) {
        return hostname + ":" + ClusterConfig.calculatePort(nodeId, portBase, portOffset);
    }
}

