/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.ControlSessionDemuxer;
import io.aeron.archive.ControlSessionProxy;
import io.aeron.archive.Session;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.security.Authenticator;
import java.util.ArrayDeque;
import java.util.function.BooleanSupplier;
import org.agrona.CloseHelper;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.UnsafeBuffer;

final class ControlSession
implements Session {
    private static final long RESEND_INTERVAL_MS = 200L;
    private static final String SESSION_REJECTED_MSG = "authentication rejected";
    private final long controlSessionId;
    private final long connectTimeoutMs;
    private final long controlPublicationId;
    private long correlationId;
    private long resendDeadlineMs;
    private long activityDeadlineMs;
    private Session activeListing = null;
    private ExclusivePublication controlPublication;
    private final Aeron aeron;
    private final ArchiveConductor conductor;
    private final CachedEpochClock cachedEpochClock;
    private final ControlResponseProxy controlResponseProxy;
    private final Authenticator authenticator;
    private final ControlSessionProxy controlSessionProxy;
    private final ArrayDeque<BooleanSupplier> queuedResponses = new ArrayDeque(8);
    private final ControlSessionDemuxer demuxer;
    private final String invalidVersionMessage;
    private State state = State.INIT;

    ControlSession(long controlSessionId, long correlationId, long connectTimeoutMs, long controlPublicationId, String invalidVersionMessage, ControlSessionDemuxer demuxer, Aeron aeron, ArchiveConductor conductor, CachedEpochClock cachedEpochClock, ControlResponseProxy controlResponseProxy, Authenticator authenticator, ControlSessionProxy controlSessionProxy) {
        this.controlSessionId = controlSessionId;
        this.correlationId = correlationId;
        this.connectTimeoutMs = connectTimeoutMs;
        this.invalidVersionMessage = invalidVersionMessage;
        this.demuxer = demuxer;
        this.aeron = aeron;
        this.controlPublicationId = controlPublicationId;
        this.conductor = conductor;
        this.cachedEpochClock = cachedEpochClock;
        this.controlResponseProxy = controlResponseProxy;
        this.authenticator = authenticator;
        this.controlSessionProxy = controlSessionProxy;
        this.activityDeadlineMs = cachedEpochClock.time() + connectTimeoutMs;
    }

    @Override
    public long sessionId() {
        return this.controlSessionId;
    }

    @Override
    public void abort() {
        this.state(State.DONE);
        if (null != this.activeListing) {
            this.activeListing.abort();
        }
    }

    @Override
    public void close() {
        if (null != this.activeListing) {
            this.activeListing.abort();
        }
        CloseHelper.close(this.conductor.context().countedErrorHandler(), this.controlPublication);
        this.demuxer.removeControlSession(this);
        if (!this.conductor.context().controlSessionsCounter().isClosed()) {
            this.conductor.context().controlSessionsCounter().decrementOrdered();
        }
    }

    @Override
    public boolean isDone() {
        return this.state == State.DONE;
    }

    @Override
    public int doWork() {
        int workCount = 0;
        long nowMs = this.cachedEpochClock.time();
        switch (this.state) {
            case INIT: {
                workCount += this.waitForPublication(nowMs);
                break;
            }
            case CONNECTING: {
                workCount += this.waitForConnection(nowMs);
                break;
            }
            case CONNECTED: {
                workCount += this.sendConnectResponse(nowMs);
                break;
            }
            case CHALLENGED: {
                workCount += this.waitForChallengeResponse(nowMs);
                break;
            }
            case AUTHENTICATED: {
                workCount += this.waitForRequest(nowMs);
                break;
            }
            case ACTIVE: {
                workCount += this.sendQueuedResponses(nowMs);
                break;
            }
            case REJECTED: {
                workCount += this.sendReject(nowMs);
                break;
            }
            case INACTIVE: {
                this.state(State.DONE);
            }
        }
        return workCount;
    }

    long correlationId() {
        return this.correlationId;
    }

    State state() {
        return this.state;
    }

    ArchiveConductor archiveConductor() {
        return this.conductor;
    }

    ExclusivePublication controlPublication() {
        return this.controlPublication;
    }

    boolean hasActiveListing() {
        return null != this.activeListing;
    }

    void activeListing(Session activeListing) {
        this.activeListing = activeListing;
    }

    void onChallengeResponse(long correlationId, byte[] encodedCredentials) {
        if (State.CHALLENGED == this.state) {
            this.correlationId = correlationId;
            this.authenticator.onChallengeResponse(this.controlSessionId, encodedCredentials, this.cachedEpochClock.time());
        }
    }

    void onKeepAlive(long correlationId) {
        this.attemptToActivate();
    }

    void onStopRecording(long correlationId, int streamId, String channel) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.stopRecording(correlationId, streamId, channel, this);
        }
    }

    void onStopRecordingSubscription(long correlationId, long subscriptionId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.stopRecordingSubscription(correlationId, subscriptionId, this);
        }
    }

    void onStartRecording(long correlationId, int streamId, SourceLocation sourceLocation, boolean autoStop, String channel) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.startRecording(correlationId, streamId, sourceLocation, autoStop, channel, this);
        }
    }

    void onListRecordingsForUri(long correlationId, long fromRecordingId, int recordCount, int streamId, byte[] channelFragment) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.newListRecordingsForUriSession(correlationId, fromRecordingId, recordCount, streamId, channelFragment, this);
        }
    }

    void onListRecordings(long correlationId, long fromRecordingId, int recordCount) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.newListRecordingsSession(correlationId, fromRecordingId, recordCount, this);
        }
    }

    void onListRecording(long correlationId, long recordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.listRecording(correlationId, recordingId, this);
        }
    }

    void onFindLastMatchingRecording(long correlationId, long minRecordingId, int sessionId, int streamId, byte[] channelFragment) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.findLastMatchingRecording(correlationId, minRecordingId, sessionId, streamId, channelFragment, this);
        }
    }

    void onStartReplay(long correlationId, long recordingId, long position, long length, int replayStreamId, String replayChannel) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.startReplay(correlationId, recordingId, position, length, replayStreamId, replayChannel, null, this);
        }
    }

    void onStartBoundedReplay(long correlationId, long recordingId, long position, long length, int limitCounterId, int replayStreamId, String replayChannel) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.startBoundedReplay(correlationId, recordingId, position, length, limitCounterId, replayStreamId, replayChannel, this);
        }
    }

    void onStopReplay(long correlationId, long replaySessionId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.stopReplay(correlationId, replaySessionId, this);
        }
    }

    void onStopAllReplays(long correlationId, long recordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.stopAllReplays(correlationId, recordingId, this);
        }
    }

    void onExtendRecording(long correlationId, long recordingId, int streamId, SourceLocation sourceLocation, boolean autoStop, String channel) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.extendRecording(correlationId, recordingId, streamId, sourceLocation, autoStop, channel, this);
        }
    }

    void onGetRecordingPosition(long correlationId, long recordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.getRecordingPosition(correlationId, recordingId, this);
        }
    }

    void onTruncateRecording(long correlationId, long recordingId, long position) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.truncateRecording(correlationId, recordingId, position, this);
        }
    }

    void onPurgeRecording(long correlationId, long recordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.purgeRecording(correlationId, recordingId, this);
        }
    }

    void onGetStopPosition(long correlationId, long recordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.getStopPosition(correlationId, recordingId, this);
        }
    }

    void onListRecordingSubscriptions(long correlationId, int pseudoIndex, int subscriptionCount, boolean applyStreamId, int streamId, String channelFragment) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.listRecordingSubscriptions(correlationId, pseudoIndex, subscriptionCount, applyStreamId, streamId, channelFragment, this);
        }
    }

    void onStopRecordingByIdentity(long correlationId, long recordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.stopRecordingByIdentity(correlationId, recordingId, this);
        }
    }

    void onReplicate(long correlationId, long srcRecordingId, long dstRecordingId, long stopPosition, long channelTagId, long subscriptionTagId, int srcControlStreamId, String srcControlChannel, String liveDestination, String replicationChannel) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.replicate(correlationId, srcRecordingId, dstRecordingId, stopPosition, channelTagId, subscriptionTagId, srcControlStreamId, srcControlChannel, liveDestination, replicationChannel, this);
        }
    }

    void onStopReplication(long correlationId, long replicationId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.stopReplication(correlationId, replicationId, this);
        }
    }

    void onGetStartPosition(long correlationId, long recordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.getStartPosition(correlationId, recordingId, this);
        }
    }

    void onDetachSegments(long correlationId, long recordingId, long newStartPosition) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.detachSegments(correlationId, recordingId, newStartPosition, this);
        }
    }

    void onDeleteDetachedSegments(long correlationId, long recordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.deleteDetachedSegments(correlationId, recordingId, this);
        }
    }

    void onPurgeSegments(long correlationId, long recordingId, long newStartPosition) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.purgeSegments(correlationId, recordingId, newStartPosition, this);
        }
    }

    void onAttachSegments(long correlationId, long recordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.attachSegments(correlationId, recordingId, this);
        }
    }

    void onMigrateSegments(long correlationId, long srcRecordingId, long dstRecordingId) {
        this.attemptToActivate();
        if (State.ACTIVE == this.state) {
            this.conductor.migrateSegments(correlationId, srcRecordingId, dstRecordingId, this);
        }
    }

    void sendOkResponse(long correlationId, ControlResponseProxy proxy) {
        this.sendResponse(correlationId, 0L, ControlResponseCode.OK, null, proxy);
    }

    void sendOkResponse(long correlationId, long relevantId, ControlResponseProxy proxy) {
        this.sendResponse(correlationId, relevantId, ControlResponseCode.OK, null, proxy);
    }

    void sendErrorResponse(long correlationId, String errorMessage, ControlResponseProxy proxy) {
        this.sendResponse(correlationId, 0L, ControlResponseCode.ERROR, errorMessage, proxy);
    }

    void sendErrorResponse(long correlationId, long relevantId, String errorMessage, ControlResponseProxy proxy) {
        this.sendResponse(correlationId, relevantId, ControlResponseCode.ERROR, errorMessage, proxy);
    }

    void sendRecordingUnknown(long correlationId, long recordingId, ControlResponseProxy proxy) {
        this.sendResponse(correlationId, recordingId, ControlResponseCode.RECORDING_UNKNOWN, null, proxy);
    }

    void sendSubscriptionUnknown(long correlationId, ControlResponseProxy proxy) {
        this.sendResponse(correlationId, 0L, ControlResponseCode.SUBSCRIPTION_UNKNOWN, null, proxy);
    }

    void sendResponse(long correlationId, long relevantId, ControlResponseCode code, String errorMessage, ControlResponseProxy proxy) {
        if (!proxy.sendResponse(this.controlSessionId, correlationId, relevantId, code, errorMessage, this)) {
            this.queueResponse(correlationId, relevantId, code, errorMessage);
        }
    }

    void attemptErrorResponse(long correlationId, String errorMessage, ControlResponseProxy proxy) {
        proxy.sendResponse(this.controlSessionId, correlationId, 0L, ControlResponseCode.ERROR, errorMessage, this);
    }

    void attemptErrorResponse(long correlationId, int errorCode, String errorMessage, ControlResponseProxy proxy) {
        proxy.sendResponse(this.controlSessionId, correlationId, errorCode, ControlResponseCode.ERROR, errorMessage, this);
    }

    int sendDescriptor(long correlationId, UnsafeBuffer descriptorBuffer, ControlResponseProxy proxy) {
        return proxy.sendDescriptor(this.controlSessionId, correlationId, descriptorBuffer, this);
    }

    boolean sendSubscriptionDescriptor(long correlationId, Subscription subscription, ControlResponseProxy proxy) {
        return proxy.sendSubscriptionDescriptor(this.controlSessionId, correlationId, subscription, this);
    }

    void attemptSignal(long correlationId, long recordingId, long subscriptionId, long position, RecordingSignal recordingSignal) {
        this.controlResponseProxy.attemptSendSignal(this.controlSessionId, correlationId, recordingId, subscriptionId, position, recordingSignal, this.controlPublication);
    }

    int maxPayloadLength() {
        return this.controlPublication.maxPayloadLength();
    }

    void challenged() {
        this.state(State.CHALLENGED);
    }

    void authenticate(byte[] encodedPrincipal) {
        this.activityDeadlineMs = -1L;
        this.state(State.AUTHENTICATED);
    }

    void reject() {
        this.state(State.REJECTED);
    }

    private void queueResponse(long correlationId, long relevantId, ControlResponseCode code, String message) {
        this.queuedResponses.offer(() -> this.controlResponseProxy.sendResponse(this.controlSessionId, correlationId, relevantId, code, message, this));
    }

    private int waitForPublication(long nowMs) {
        int workCount = 0;
        this.controlPublication = this.aeron.getExclusivePublication(this.controlPublicationId);
        if (null != this.controlPublication) {
            this.activityDeadlineMs = nowMs + this.connectTimeoutMs;
            this.state(State.CONNECTING);
            ++workCount;
        }
        return workCount;
    }

    private int waitForConnection(long nowMs) {
        int workCount = 0;
        if (this.controlPublication.isConnected()) {
            this.state(State.CONNECTED);
            ++workCount;
        } else if (this.hasNoActivity(nowMs)) {
            this.state(State.INACTIVE);
            ++workCount;
        }
        return workCount;
    }

    private int sendConnectResponse(long nowMs) {
        int workCount = 0;
        if (this.hasNoActivity(nowMs)) {
            this.state(State.INACTIVE);
            ++workCount;
        } else if (nowMs > this.resendDeadlineMs) {
            this.resendDeadlineMs = nowMs + 200L;
            if (null != this.invalidVersionMessage) {
                this.controlResponseProxy.sendResponse(this.controlSessionId, this.correlationId, this.controlSessionId, ControlResponseCode.ERROR, this.invalidVersionMessage, this);
            } else {
                this.authenticator.onConnectedSession(this.controlSessionProxy.controlSession(this), nowMs);
            }
            ++workCount;
        }
        return workCount;
    }

    private int waitForChallengeResponse(long nowMs) {
        if (this.hasNoActivity(nowMs)) {
            this.state(State.INACTIVE);
        } else {
            this.authenticator.onChallengedSession(this.controlSessionProxy.controlSession(this), nowMs);
        }
        return 1;
    }

    private int waitForRequest(long nowMs) {
        int workCount = 0;
        if (this.hasNoActivity(nowMs)) {
            this.state(State.INACTIVE);
            ++workCount;
        } else if (nowMs > this.resendDeadlineMs) {
            this.resendDeadlineMs = nowMs + 200L;
            if (this.controlResponseProxy.sendResponse(this.controlSessionId, this.correlationId, this.controlSessionId, ControlResponseCode.OK, null, this)) {
                this.activityDeadlineMs = -1L;
                ++workCount;
            }
        }
        return workCount;
    }

    private int sendQueuedResponses(long nowMs) {
        int workCount = 0;
        if (!this.controlPublication.isConnected()) {
            this.state(State.INACTIVE);
        } else if (!this.queuedResponses.isEmpty()) {
            if (this.queuedResponses.peekFirst().getAsBoolean()) {
                this.queuedResponses.pollFirst();
                this.activityDeadlineMs = -1L;
                ++workCount;
            } else if (-1L == this.activityDeadlineMs) {
                this.activityDeadlineMs = nowMs + this.connectTimeoutMs;
            } else if (this.hasNoActivity(nowMs)) {
                this.state(State.INACTIVE);
            }
        }
        return workCount;
    }

    private int sendReject(long nowMs) {
        int workCount = 0;
        if (this.hasNoActivity(nowMs)) {
            this.state(State.INACTIVE);
            ++workCount;
        } else if (nowMs > this.resendDeadlineMs) {
            this.resendDeadlineMs = nowMs + 200L;
            this.controlResponseProxy.sendResponse(this.controlSessionId, this.correlationId, 10L, ControlResponseCode.ERROR, SESSION_REJECTED_MSG, this);
            ++workCount;
        }
        return workCount;
    }

    private boolean hasNoActivity(long nowMs) {
        return -1L != this.activityDeadlineMs && nowMs > this.activityDeadlineMs;
    }

    private void attemptToActivate() {
        if (State.AUTHENTICATED == this.state && null == this.invalidVersionMessage) {
            this.state(State.ACTIVE);
        }
    }

    private void state(State state) {
        this.stateChange(this.state, state, this.controlSessionId);
        this.state = state;
    }

    void stateChange(State oldState, State newState, long controlSessionId) {
    }

    public String toString() {
        return "ControlSession{controlSessionId=" + this.controlSessionId + ", correlationId=" + this.correlationId + ", state=" + (Object)((Object)this.state) + ", controlPublication=" + this.controlPublication + '}';
    }

    static enum State {
        INIT,
        CONNECTING,
        CONNECTED,
        CHALLENGED,
        AUTHENTICATED,
        ACTIVE,
        INACTIVE,
        REJECTED,
        DONE;

    }
}

