/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ExclusivePublication;
import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.codecs.ChangeType;
import io.aeron.cluster.codecs.ClusterAction;
import io.aeron.cluster.codecs.ClusterActionRequestEncoder;
import io.aeron.cluster.codecs.MembershipChangeEventEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.NewLeadershipTermEventEncoder;
import io.aeron.cluster.codecs.SessionCloseEventEncoder;
import io.aeron.cluster.codecs.SessionMessageHeaderEncoder;
import io.aeron.cluster.codecs.SessionOpenEventEncoder;
import io.aeron.cluster.codecs.TimerEventEncoder;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class LogPublisher {
    private static final int SEND_ATTEMPTS = 3;
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final SessionMessageHeaderEncoder sessionHeaderEncoder = new SessionMessageHeaderEncoder();
    private final SessionOpenEventEncoder sessionOpenEventEncoder = new SessionOpenEventEncoder();
    private final SessionCloseEventEncoder sessionCloseEventEncoder = new SessionCloseEventEncoder();
    private final TimerEventEncoder timerEventEncoder = new TimerEventEncoder();
    private final ClusterActionRequestEncoder clusterActionRequestEncoder = new ClusterActionRequestEncoder();
    private final NewLeadershipTermEventEncoder newLeadershipTermEventEncoder = new NewLeadershipTermEventEncoder();
    private final MembershipChangeEventEncoder membershipChangeEventEncoder = new MembershipChangeEventEncoder();
    private final UnsafeBuffer sessionHeaderBuffer = new UnsafeBuffer(new byte[32]);
    private final ExpandableArrayBuffer expandableArrayBuffer = new ExpandableArrayBuffer();
    private final BufferClaim bufferClaim = new BufferClaim();
    private ExclusivePublication publication;

    LogPublisher() {
        this.sessionHeaderEncoder.wrapAndApplyHeader(this.sessionHeaderBuffer, 0, new MessageHeaderEncoder());
    }

    void publication(ExclusivePublication publication) {
        if (null != this.publication) {
            this.publication.close();
        }
        this.publication = publication;
    }

    void disconnect(ErrorHandler errorHandler) {
        if (null != this.publication) {
            CloseHelper.close(errorHandler, this.publication);
            this.publication = null;
        }
    }

    boolean isConnected() {
        if (null == this.publication) {
            return false;
        }
        return this.publication.isConnected();
    }

    long position() {
        if (null == this.publication) {
            return 0L;
        }
        return this.publication.position();
    }

    int sessionId() {
        return this.publication.sessionId();
    }

    void addDestination(boolean isLogChannelMultiDestination, String followerLogEndpoint) {
        if (isLogChannelMultiDestination && null != this.publication) {
            this.publication.asyncAddDestination("aeron:udp?endpoint=" + followerLogEndpoint);
        }
    }

    void removeDestination(boolean isLogChannelMultiDestination, String followerLogEndpoint) {
        if (isLogChannelMultiDestination && null != this.publication) {
            this.publication.asyncRemoveDestination("aeron:udp?endpoint=" + followerLogEndpoint);
        }
    }

    long appendMessage(long leadershipTermId, long clusterSessionId, long timestamp, DirectBuffer buffer, int offset, int length) {
        long result;
        this.sessionHeaderEncoder.leadershipTermId(leadershipTermId).clusterSessionId(clusterSessionId).timestamp(timestamp);
        int attempts = 3;
        while ((result = this.publication.offer(this.sessionHeaderBuffer, 0, 32, buffer, offset, length, null)) <= 0L) {
            LogPublisher.checkResult(result);
            if (--attempts > 0) continue;
        }
        return result;
    }

    long appendSessionOpen(ClusterSession session, long leadershipTermId, long timestamp) {
        long result;
        byte[] encodedPrincipal = session.encodedPrincipal();
        String channel = session.responseChannel();
        this.sessionOpenEventEncoder.wrapAndApplyHeader(this.expandableArrayBuffer, 0, this.messageHeaderEncoder).leadershipTermId(leadershipTermId).clusterSessionId(session.id()).correlationId(session.correlationId()).timestamp(timestamp).responseStreamId(session.responseStreamId()).responseChannel(channel).putEncodedPrincipal(encodedPrincipal, 0, encodedPrincipal.length);
        int length = 8 + this.sessionOpenEventEncoder.encodedLength();
        int attempts = 3;
        while ((result = this.publication.offer(this.expandableArrayBuffer, 0, length, null)) <= 0L) {
            LogPublisher.checkResult(result);
            if (--attempts > 0) continue;
        }
        return result;
    }

    boolean appendSessionClose(ClusterSession session, long leadershipTermId, long timestamp) {
        int length = 36;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(36, this.bufferClaim)) > 0L) {
                this.sessionCloseEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).clusterSessionId(session.id()).timestamp(timestamp).closeReason(session.closeReason());
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    long appendTimer(long correlationId, long leadershipTermId, long timestamp) {
        long result;
        int length = 32;
        int attempts = 3;
        do {
            if ((result = this.publication.tryClaim(32, this.bufferClaim)) > 0L) {
                this.timerEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).correlationId(correlationId).timestamp(timestamp);
                this.bufferClaim.commit();
                break;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return result;
    }

    boolean appendClusterAction(long leadershipTermId, long timestamp, ClusterAction action) {
        int length = 36;
        int fragmentLength = 68;
        int alignedFragmentLength = BitUtil.align(68, 32);
        int attempts = 3;
        do {
            long logPosition = this.publication.position() + (long)alignedFragmentLength;
            long result = this.publication.tryClaim(36, this.bufferClaim);
            if (result > 0L) {
                this.clusterActionRequestEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).timestamp(timestamp).action(action);
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean appendNewLeadershipTermEvent(long leadershipTermId, long timestamp, long termBaseLogPosition, int leaderMemberId, int logSessionId, TimeUnit timeUnit, int appVersion) {
        int length = 56;
        int fragmentLength = 88;
        int alignedFragmentLength = BitUtil.align(88, 32);
        int attempts = 3;
        do {
            long logPosition = this.publication.position() + (long)alignedFragmentLength;
            long result = this.publication.tryClaim(56, this.bufferClaim);
            if (result > 0L) {
                this.newLeadershipTermEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).timestamp(timestamp).termBaseLogPosition(termBaseLogPosition).leaderMemberId(leaderMemberId).logSessionId(logSessionId).timeUnit(ClusterClock.map(timeUnit)).appVersion(appVersion);
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    long appendMembershipChangeEvent(long leadershipTermId, long timestamp, int leaderMemberId, int clusterSize, ChangeType changeType, int memberId, String clusterMembers) {
        long result;
        int fragmentedLength = this.computeMembershipChangeEventFragmentedLength(clusterMembers);
        this.membershipChangeEventEncoder.wrapAndApplyHeader(this.expandableArrayBuffer, 0, this.messageHeaderEncoder).leadershipTermId(leadershipTermId).timestamp(timestamp).leaderMemberId(leaderMemberId).clusterSize(clusterSize).changeType(changeType).memberId(memberId).clusterMembers(clusterMembers);
        int length = 8 + this.membershipChangeEventEncoder.encodedLength();
        int attempts = 3;
        do {
            this.membershipChangeEventEncoder.wrap(this.expandableArrayBuffer, 8).logPosition(this.publication.position() + (long)fragmentedLength);
            result = this.publication.offer(this.expandableArrayBuffer, 0, length, null);
            if (result > 0L) break;
            LogPublisher.checkResult(result);
        } while (--attempts > 0);
        return result;
    }

    private int computeMembershipChangeEventFragmentedLength(String clusterMembers) {
        int messageLength = 48 + MembershipChangeEventEncoder.clusterMembersHeaderLength() + clusterMembers.length();
        int maxPayloadLength = this.publication.maxPayloadLength();
        int numMaxPayloads = messageLength / maxPayloadLength;
        int remainingPayload = messageLength % maxPayloadLength;
        int lastFrameLength = remainingPayload > 0 ? BitUtil.align(remainingPayload + 32, 32) : 0;
        return numMaxPayloads * (maxPayloadLength + 32) + lastFrameLength;
    }

    private static void checkResult(long result) {
        if (result == -4L || result == -5L) {
            throw new AeronException("unexpected publication state: " + result);
        }
    }
}

