/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class ServiceAckDecoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 33;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 7;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ServiceAckDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 33;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 7;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ServiceAckDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ServiceAckDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (33 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ServiceAckDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int logPositionId() {
        return 1;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 0;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logPosition() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int timestampId() {
        return 2;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 8;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long timestamp() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int ackIdId() {
        return 3;
    }

    public static int ackIdSinceVersion() {
        return 0;
    }

    public static int ackIdEncodingOffset() {
        return 16;
    }

    public static int ackIdEncodingLength() {
        return 8;
    }

    public static String ackIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long ackIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long ackIdMinValue() {
        return -9223372036854775807L;
    }

    public static long ackIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long ackId() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int relevantIdId() {
        return 4;
    }

    public static int relevantIdSinceVersion() {
        return 0;
    }

    public static int relevantIdEncodingOffset() {
        return 24;
    }

    public static int relevantIdEncodingLength() {
        return 8;
    }

    public static String relevantIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long relevantIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long relevantIdMinValue() {
        return -9223372036854775807L;
    }

    public static long relevantIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long relevantId() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int serviceIdId() {
        return 5;
    }

    public static int serviceIdSinceVersion() {
        return 0;
    }

    public static int serviceIdEncodingOffset() {
        return 32;
    }

    public static int serviceIdEncodingLength() {
        return 4;
    }

    public static String serviceIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int serviceIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int serviceIdMinValue() {
        return -2147483647;
    }

    public static int serviceIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int serviceId() {
        return this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ServiceAckDecoder decoder = new ServiceAckDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ServiceAck](sbeTemplateId=");
        builder.append(33);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 7) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(7);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 36) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(36);
        builder.append("):");
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("timestamp=");
        builder.append(this.timestamp());
        builder.append('|');
        builder.append("ackId=");
        builder.append(this.ackId());
        builder.append('|');
        builder.append("relevantId=");
        builder.append(this.relevantId());
        builder.append('|');
        builder.append("serviceId=");
        builder.append(this.serviceId());
        this.limit(originalLimit);
        return builder;
    }

    public ServiceAckDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

