/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;

public final class Header {
    private final int positionBitsToShift;
    private final int initialTermId;
    private int offset = 0;
    private DirectBuffer buffer;
    private final Object context;

    public Header(int initialTermId, int positionBitsToShift) {
        this(initialTermId, positionBitsToShift, null);
    }

    public Header(int initialTermId, int positionBitsToShift, Object context) {
        this.initialTermId = initialTermId;
        this.positionBitsToShift = positionBitsToShift;
        this.context = context;
    }

    public Object context() {
        return this.context;
    }

    public long position() {
        int frameLength = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        int resultingOffset = BitUtil.align(this.offset + frameLength, 32);
        int termId = this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
        return LogBufferDescriptor.computePosition(termId, resultingOffset, this.positionBitsToShift, this.initialTermId);
    }

    public int positionBitsToShift() {
        return this.positionBitsToShift;
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public void offset(int offset) {
        this.offset = offset;
    }

    public int offset() {
        return this.offset;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public void buffer(DirectBuffer buffer) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
    }

    public int frameLength() {
        return this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
    }

    public int sessionId() {
        return this.buffer.getInt(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public int termId() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public int termOffset() {
        return this.offset;
    }

    public int type() {
        return this.buffer.getShort(this.offset + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public byte flags() {
        return this.buffer.getByte(this.offset + 5);
    }

    public long reservedValue() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }
}

