/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs.mark;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Mark file header.
 */
@SuppressWarnings("all")
public final class MarkFileHeaderDecoder
{
    public static final int BLOCK_LENGTH = 128;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 100;
    public static final int SCHEMA_VERSION = 1;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final MarkFileHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public MarkFileHeaderDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public MarkFileHeaderDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public MarkFileHeaderDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int versionId()
    {
        return 1;
    }

    public static int versionSinceVersion()
    {
        return 0;
    }

    public static int versionEncodingOffset()
    {
        return 0;
    }

    public static int versionEncodingLength()
    {
        return 4;
    }

    public static String versionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int versionNullValue()
    {
        return -2147483648;
    }

    public static int versionMinValue()
    {
        return -2147483647;
    }

    public static int versionMaxValue()
    {
        return 2147483647;
    }

    public int version()
    {
        return buffer.getInt(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int activityTimestampId()
    {
        return 2;
    }

    public static int activityTimestampSinceVersion()
    {
        return 0;
    }

    public static int activityTimestampEncodingOffset()
    {
        return 8;
    }

    public static int activityTimestampEncodingLength()
    {
        return 8;
    }

    public static String activityTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long activityTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long activityTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long activityTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public long activityTimestamp()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int startTimestampId()
    {
        return 3;
    }

    public static int startTimestampSinceVersion()
    {
        return 0;
    }

    public static int startTimestampEncodingOffset()
    {
        return 16;
    }

    public static int startTimestampEncodingLength()
    {
        return 8;
    }

    public static String startTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public long startTimestamp()
    {
        return buffer.getLong(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int pidId()
    {
        return 4;
    }

    public static int pidSinceVersion()
    {
        return 0;
    }

    public static int pidEncodingOffset()
    {
        return 24;
    }

    public static int pidEncodingLength()
    {
        return 8;
    }

    public static String pidMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long pidNullValue()
    {
        return -9223372036854775808L;
    }

    public static long pidMinValue()
    {
        return -9223372036854775807L;
    }

    public static long pidMaxValue()
    {
        return 9223372036854775807L;
    }

    public long pid()
    {
        return buffer.getLong(offset + 24, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int controlStreamIdId()
    {
        return 5;
    }

    public static int controlStreamIdSinceVersion()
    {
        return 0;
    }

    public static int controlStreamIdEncodingOffset()
    {
        return 32;
    }

    public static int controlStreamIdEncodingLength()
    {
        return 4;
    }

    public static String controlStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int controlStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int controlStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int controlStreamIdMaxValue()
    {
        return 2147483647;
    }

    public int controlStreamId()
    {
        return buffer.getInt(offset + 32, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int localControlStreamIdId()
    {
        return 6;
    }

    public static int localControlStreamIdSinceVersion()
    {
        return 0;
    }

    public static int localControlStreamIdEncodingOffset()
    {
        return 36;
    }

    public static int localControlStreamIdEncodingLength()
    {
        return 4;
    }

    public static String localControlStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int localControlStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int localControlStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int localControlStreamIdMaxValue()
    {
        return 2147483647;
    }

    public int localControlStreamId()
    {
        return buffer.getInt(offset + 36, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int eventsStreamIdId()
    {
        return 7;
    }

    public static int eventsStreamIdSinceVersion()
    {
        return 0;
    }

    public static int eventsStreamIdEncodingOffset()
    {
        return 40;
    }

    public static int eventsStreamIdEncodingLength()
    {
        return 4;
    }

    public static String eventsStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int eventsStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int eventsStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int eventsStreamIdMaxValue()
    {
        return 2147483647;
    }

    public int eventsStreamId()
    {
        return buffer.getInt(offset + 40, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int headerLengthId()
    {
        return 8;
    }

    public static int headerLengthSinceVersion()
    {
        return 1;
    }

    public static int headerLengthEncodingOffset()
    {
        return 44;
    }

    public static int headerLengthEncodingLength()
    {
        return 4;
    }

    public static String headerLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int headerLengthNullValue()
    {
        return 0;
    }

    public static int headerLengthMinValue()
    {
        return -2147483647;
    }

    public static int headerLengthMaxValue()
    {
        return 2147483647;
    }

    public int headerLength()
    {
        if (parentMessage.actingVersion < 1)
        {
            return 0;
        }

        return buffer.getInt(offset + 44, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int errorBufferLengthId()
    {
        return 9;
    }

    public static int errorBufferLengthSinceVersion()
    {
        return 1;
    }

    public static int errorBufferLengthEncodingOffset()
    {
        return 48;
    }

    public static int errorBufferLengthEncodingLength()
    {
        return 4;
    }

    public static String errorBufferLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int errorBufferLengthNullValue()
    {
        return 0;
    }

    public static int errorBufferLengthMinValue()
    {
        return -2147483647;
    }

    public static int errorBufferLengthMaxValue()
    {
        return 2147483647;
    }

    public int errorBufferLength()
    {
        if (parentMessage.actingVersion < 1)
        {
            return 0;
        }

        return buffer.getInt(offset + 48, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int controlChannelId()
    {
        return 10;
    }

    public static int controlChannelSinceVersion()
    {
        return 0;
    }

    public static String controlChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String controlChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int controlChannelHeaderLength()
    {
        return 4;
    }

    public int controlChannelLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int skipControlChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getControlChannel(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getControlChannel(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapControlChannel(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String controlChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getControlChannel(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public static int localControlChannelId()
    {
        return 11;
    }

    public static int localControlChannelSinceVersion()
    {
        return 0;
    }

    public static String localControlChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String localControlChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int localControlChannelHeaderLength()
    {
        return 4;
    }

    public int localControlChannelLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int skipLocalControlChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getLocalControlChannel(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getLocalControlChannel(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapLocalControlChannel(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String localControlChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getLocalControlChannel(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public static int eventsChannelId()
    {
        return 12;
    }

    public static int eventsChannelSinceVersion()
    {
        return 0;
    }

    public static String eventsChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String eventsChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int eventsChannelHeaderLength()
    {
        return 4;
    }

    public int eventsChannelLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int skipEventsChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getEventsChannel(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getEventsChannel(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapEventsChannel(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String eventsChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getEventsChannel(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public static int aeronDirectoryId()
    {
        return 13;
    }

    public static int aeronDirectorySinceVersion()
    {
        return 0;
    }

    public static String aeronDirectoryCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String aeronDirectoryMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int aeronDirectoryHeaderLength()
    {
        return 4;
    }

    public int aeronDirectoryLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int skipAeronDirectory()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getAeronDirectory(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getAeronDirectory(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapAeronDirectory(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String aeronDirectory()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getAeronDirectory(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final MarkFileHeaderDecoder decoder = new MarkFileHeaderDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[MarkFileHeader](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("version=");
        builder.append(version());
        builder.append('|');
        builder.append("activityTimestamp=");
        builder.append(activityTimestamp());
        builder.append('|');
        builder.append("startTimestamp=");
        builder.append(startTimestamp());
        builder.append('|');
        builder.append("pid=");
        builder.append(pid());
        builder.append('|');
        builder.append("controlStreamId=");
        builder.append(controlStreamId());
        builder.append('|');
        builder.append("localControlStreamId=");
        builder.append(localControlStreamId());
        builder.append('|');
        builder.append("eventsStreamId=");
        builder.append(eventsStreamId());
        builder.append('|');
        builder.append("headerLength=");
        builder.append(headerLength());
        builder.append('|');
        builder.append("errorBufferLength=");
        builder.append(errorBufferLength());
        builder.append('|');
        builder.append("controlChannel=");
        builder.append('\'');
        getControlChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("localControlChannel=");
        builder.append('\'');
        getLocalControlChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("eventsChannel=");
        builder.append('\'');
        getEventsChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("aeronDirectory=");
        builder.append('\'');
        getAeronDirectory(builder);
        builder.append('\'');

        limit(originalLimit);

        return builder;
    }
    
    public MarkFileHeaderDecoder sbeSkip()
    {
        sbeRewind();
        skipControlChannel();
        skipLocalControlChannel();
        skipEventsChannel();
        skipAeronDirectory();

        return this;
    }
}
