/*
 * Copyright 2014-2022 Real Logic Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.aeron.driver;

import org.agrona.DirectBuffer;

import java.io.File;

/**
 * Default implementation of {@link TerminationValidator} that always denies termination.
 */
public class DefaultDenyTerminationValidator implements TerminationValidator
{
    /**
     * {@inheritDoc}
     */
    public boolean allowTermination(
        final File aeronDir, final DirectBuffer tokenBuffer, final int tokenOffset, final int tokenLength)
    {
        return false;
    }
}
