/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.ArchiveMarkFile;
import io.aeron.archive.ArchiveMigrationStep;
import io.aeron.archive.Catalog;
import io.aeron.archive.MigrationUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.SemanticVersion;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.UnsafeBuffer;

class ArchiveMigration_2_3
implements ArchiveMigrationStep {
    private static final int MINIMUM_VERSION = SemanticVersion.compose(3, 0, 0);

    ArchiveMigration_2_3() {
    }

    @Override
    public int minimumVersion() {
        return MINIMUM_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(PrintStream stream, ArchiveMarkFile markFile, Catalog catalog, File archiveDir) {
        int version = this.minimumVersion();
        try (FileChannel timestampFile = MigrationUtils.createMigrationTimestampFile(archiveDir, markFile.decoder().version(), version);){
            assert (null != timestampFile);
            File newFile = new File(archiveDir, "archive.catalog.updated");
            IoUtil.deleteIfExists(newFile);
            Path updatedCatalogFile = newFile.toPath();
            try (FileChannel channel = FileChannel.open(updatedCatalogFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
                int offset;
                MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                try {
                    offset = this.migrateCatalogFile(catalog, version, mappedByteBuffer);
                }
                finally {
                    BufferUtil.free(mappedByteBuffer);
                }
                channel.truncate(offset);
            }
            catalog.close();
            Path catalogFilePath = updatedCatalogFile.resolveSibling("archive.catalog");
            Files.delete(catalogFilePath);
            Files.move(updatedCatalogFile, catalogFilePath, new CopyOption[0]);
            markFile.encoder().version(version);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public String toString() {
        return "to " + MigrationUtils.fullVersionString(this.minimumVersion());
    }

    private int migrateCatalogFile(Catalog catalog, int version, MappedByteBuffer mappedByteBuffer) {
        UnsafeBuffer buffer = new UnsafeBuffer(mappedByteBuffer);
        int alignment = 64;
        int catalogHeaderLength = this.writeCatalogHeader(buffer, version, catalog.nextRecordingId(), 64);
        MutableInteger offset = new MutableInteger(catalogHeaderLength);
        catalog.forEach((recordingDescriptorOffset, headerEncoder, headerDecoder, descriptorEncoder, descriptorDecoder) -> {
            int strippedChannelLength = descriptorDecoder.strippedChannelLength();
            descriptorDecoder.skipStrippedChannel();
            int originalChannelLength = descriptorDecoder.originalChannelLength();
            descriptorDecoder.skipOriginalChannel();
            int sourceIdentityLength = descriptorDecoder.sourceIdentityLength();
            int frameLength = BitUtil.align(116 + strippedChannelLength + 4 + originalChannelLength + 4 + sourceIdentityLength, 64);
            DirectBuffer srcBuffer = headerDecoder.buffer();
            int headerLength = headerDecoder.encodedLength();
            int index = offset.get();
            buffer.putBytes(index, srcBuffer, 0, headerLength);
            buffer.putInt(offset.get(), frameLength - headerLength, ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(index += headerLength, srcBuffer, headerLength, frameLength - headerLength);
            offset.addAndGet(frameLength);
        });
        return offset.get();
    }

    private int writeCatalogHeader(UnsafeBuffer buffer, int version, long nextRecordingId, int alignment) {
        int catalogHeaderLength = 32;
        int index = 0;
        buffer.putInt(index, version, ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(index += 4, 32, ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(index += 4, nextRecordingId, ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(index += 8, alignment, ByteOrder.LITTLE_ENDIAN);
        return 32;
    }
}

