/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.Counter;
import io.aeron.ExclusivePublication;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;

class CreateReplayPublicationSession
implements Session {
    private final long correlationId;
    private final long recordingId;
    private final long replayPosition;
    private final long replayLength;
    private long publicationRegistrationId;
    private boolean isDone = false;
    private final Aeron aeron;
    private final Counter limitPositionCounter;
    private final ControlSession controlSession;
    private final ArchiveConductor conductor;

    CreateReplayPublicationSession(long correlationId, long recordingId, long replayPosition, long replayLength, long publicationRegistrationId, Counter limitPositionCounter, Aeron aeron, ControlSession controlSession, ArchiveConductor conductor) {
        this.correlationId = correlationId;
        this.recordingId = recordingId;
        this.replayPosition = replayPosition;
        this.replayLength = replayLength;
        this.publicationRegistrationId = publicationRegistrationId;
        this.limitPositionCounter = limitPositionCounter;
        this.aeron = aeron;
        this.controlSession = controlSession;
        this.conductor = conductor;
    }

    @Override
    public void close() {
        if (-1L != this.publicationRegistrationId) {
            this.aeron.asyncRemovePublication(this.publicationRegistrationId);
        }
    }

    @Override
    public void abort() {
        this.isDone = true;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public long sessionId() {
        return this.publicationRegistrationId;
    }

    @Override
    public int doWork() {
        ExclusivePublication publication;
        int workCount = 0;
        if (!this.isDone && null != (publication = this.aeron.getExclusivePublication(this.publicationRegistrationId))) {
            this.publicationRegistrationId = -1L;
            this.isDone = true;
            ++workCount;
            this.conductor.newReplaySession(this.recordingId, this.replayPosition, this.replayLength, this.correlationId, this.controlSession, this.limitPositionCounter, publication);
        }
        return workCount;
    }
}

