/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.RecordingSession;
import io.aeron.archive.ReplaySession;
import io.aeron.archive.SessionWorker;
import org.agrona.CloseHelper;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.CountedErrorHandler;

final class SharedModeArchiveConductor
extends ArchiveConductor {
    private AgentInvoker replayerAgentInvoker;
    private AgentInvoker recorderAgentInvoker;

    SharedModeArchiveConductor(Archive.Context ctx) {
        super(ctx);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.replayerAgentInvoker = new AgentInvoker(this.errorHandler, this.ctx.errorCounter(), this.replayer);
        this.recorderAgentInvoker = new AgentInvoker(this.errorHandler, this.ctx.errorCounter(), this.recorder);
        this.replayerAgentInvoker.start();
        this.recorderAgentInvoker.start();
    }

    @Override
    protected SessionWorker<RecordingSession> newRecorder() {
        return new SharedModeRecorder(this.errorHandler);
    }

    @Override
    protected SessionWorker<ReplaySession> newReplayer() {
        return new SharedModeReplayer(this.errorHandler);
    }

    @Override
    public int doWork() {
        return super.doWork() + this.replayerAgentInvoker.invoke() + this.invokeAeronInvoker() + this.invokeDriverConductor() + this.recorderAgentInvoker.invoke() + this.invokeAeronInvoker() + this.invokeDriverConductor();
    }

    @Override
    protected void closeSessionWorkers() {
        CloseHelper.close(this.ctx.countedErrorHandler(), this.recorderAgentInvoker);
        CloseHelper.close(this.ctx.countedErrorHandler(), this.replayerAgentInvoker);
    }

    class SharedModeReplayer
    extends SessionWorker<ReplaySession> {
        SharedModeReplayer(CountedErrorHandler errorHandler) {
            super("archive-replayer", errorHandler);
        }

        @Override
        protected void closeSession(ReplaySession session) {
            SharedModeArchiveConductor.this.closeReplaySession(session);
        }
    }

    class SharedModeRecorder
    extends SessionWorker<RecordingSession> {
        SharedModeRecorder(CountedErrorHandler errorHandler) {
            super("archive-recorder", errorHandler);
        }

        @Override
        protected void closeSession(RecordingSession session) {
            SharedModeArchiveConductor.this.closeRecordingSession(session);
        }
    }
}

