/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.Counter;
import io.aeron.RethrowingErrorHandler;
import io.aeron.archive.Archive;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.EgressPublisher;
import io.aeron.cluster.LogPublisher;
import io.aeron.cluster.MillisecondClusterClock;
import io.aeron.cluster.PriorityHeapTimerServiceSupplier;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.TimerServiceSupplier;
import io.aeron.cluster.WheelTimerServiceSupplier;
import io.aeron.cluster.client.AeronCluster;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.cluster.service.ClusterCounters;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ClusteredServiceContainer;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.status.DutyCycleStallTracker;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.security.AuthenticatorSupplier;
import io.aeron.security.AuthorisationService;
import io.aeron.security.AuthorisationServiceSupplier;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.SemanticVersion;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public final class ConsensusModule
implements AutoCloseable {
    private final Context ctx;
    private final ConsensusModuleAgent conductor;
    private final AgentRunner conductorRunner;

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles(args);
        try (ConsensusModule consensusModule = ConsensusModule.launch();){
            consensusModule.context().shutdownSignalBarrier().await();
            System.out.println("Shutdown ConsensusModule...");
        }
    }

    ConsensusModule(Context ctx) {
        try {
            ctx.conclude();
            this.ctx = ctx;
            this.conductor = new ConsensusModuleAgent(ctx);
            this.conductorRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), ctx.errorCounter(), this.conductor);
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (null != ctx.markFile) {
                ctx.markFile.signalFailedStart();
            }
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static ConsensusModule launch() {
        return ConsensusModule.launch(new Context());
    }

    public static ConsensusModule launch(Context ctx) {
        ConsensusModule consensusModule = new ConsensusModule(ctx);
        AgentRunner.startOnThread(consensusModule.conductorRunner, ctx.threadFactory());
        return consensusModule;
    }

    public Context context() {
        return this.ctx;
    }

    @Override
    public void close() {
        CloseHelper.close(this.conductorRunner);
    }

    public String toString() {
        return "ConsensusModule{conductor=" + this.conductor + '}';
    }

    public static final class Context
    implements Cloneable {
        private static final AtomicIntegerFieldUpdater<Context> IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isConcluded");
        private volatile int isConcluded;
        private boolean ownsAeronClient = false;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private boolean deleteDirOnStart = false;
        private String clusterDirectoryName = ClusteredServiceContainer.Configuration.clusterDirName();
        private File clusterDir;
        private RecordingLog recordingLog;
        private ClusterMarkFile markFile;
        private int fileSyncLevel = Archive.Configuration.fileSyncLevel();
        private int appVersion = SemanticVersion.compose(0, 0, 1);
        private int clusterId = ClusteredServiceContainer.Configuration.clusterId();
        private int clusterMemberId = Configuration.clusterMemberId();
        private int appointedLeaderId = Configuration.appointedLeaderId();
        private String clusterMembers = Configuration.clusterMembers();
        private String clusterConsensusEndpoints = Configuration.clusterConsensusEndpoints();
        private boolean clusterMembersIgnoreSnapshot = Configuration.clusterMembersIgnoreSnapshot();
        private String ingressChannel = AeronCluster.Configuration.ingressChannel();
        private int ingressStreamId = AeronCluster.Configuration.ingressStreamId();
        private boolean isIpcIngressAllowed = Configuration.isIpcIngressAllowed();
        private int ingressFragmentLimit = Configuration.ingressFragmentLimit();
        private String egressChannel = AeronCluster.Configuration.egressChannel();
        private String logChannel = Configuration.logChannel();
        private int logStreamId = Configuration.logStreamId();
        private String memberEndpoints = Configuration.memberEndpoints();
        private String replayChannel = ClusteredServiceContainer.Configuration.replayChannel();
        private int replayStreamId = ClusteredServiceContainer.Configuration.replayStreamId();
        private String controlChannel = ClusteredServiceContainer.Configuration.controlChannel();
        private int consensusModuleStreamId = ClusteredServiceContainer.Configuration.consensusModuleStreamId();
        private int serviceStreamId = ClusteredServiceContainer.Configuration.serviceStreamId();
        private String snapshotChannel = Configuration.snapshotChannel();
        private int snapshotStreamId = Configuration.snapshotStreamId();
        private String consensusChannel = Configuration.consensusChannel();
        private int consensusStreamId = Configuration.consensusStreamId();
        private String replicationChannel = Configuration.replicationChannel();
        private String followerCatchupChannel = Configuration.followerCatchupChannel();
        private String leaderArchiveControlChannel = Configuration.leaderArchiveControlChannel();
        private int logFragmentLimit = ClusteredServiceContainer.Configuration.logFragmentLimit();
        private int serviceCount = Configuration.serviceCount();
        private int errorBufferLength = Configuration.errorBufferLength();
        private int maxConcurrentSessions = Configuration.maxConcurrentSessions();
        private int ticksPerWheel = Configuration.ticksPerWheel();
        private long wheelTickResolutionNs = Configuration.wheelTickResolutionNs();
        private long sessionTimeoutNs = Configuration.sessionTimeoutNs();
        private long leaderHeartbeatTimeoutNs = Configuration.leaderHeartbeatTimeoutNs();
        private long leaderHeartbeatIntervalNs = Configuration.leaderHeartbeatIntervalNs();
        private long startupCanvassTimeoutNs = Configuration.startupCanvassTimeoutNs();
        private long electionTimeoutNs = Configuration.electionTimeoutNs();
        private long electionStatusIntervalNs = Configuration.electionStatusIntervalNs();
        private long dynamicJoinIntervalNs = Configuration.dynamicJoinIntervalNs();
        private long terminationTimeoutNs = Configuration.terminationTimeoutNs();
        private long cycleThresholdNs = Configuration.cycleThresholdNs();
        private String agentRoleName = Configuration.agentRoleName();
        private ThreadFactory threadFactory;
        private Supplier<IdleStrategy> idleStrategySupplier;
        private ClusterClock clusterClock;
        private EpochClock epochClock;
        private Random random;
        private TimerServiceSupplier timerServiceSupplier;
        private Function<Context, LongConsumer> clusterTimeConsumerSupplier;
        private DistinctErrorLog errorLog;
        private ErrorHandler errorHandler;
        private AtomicCounter errorCounter;
        private CountedErrorHandler countedErrorHandler;
        private Counter moduleStateCounter;
        private Counter electionStateCounter;
        private Counter clusterNodeRoleCounter;
        private Counter commitPosition;
        private Counter controlToggle;
        private Counter snapshotCounter;
        private Counter timedOutClientCounter;
        private ShutdownSignalBarrier shutdownSignalBarrier;
        private Runnable terminationHook;
        private AeronArchive.Context archiveContext;
        private AuthenticatorSupplier authenticatorSupplier;
        private AuthorisationServiceSupplier authorisationServiceSupplier;
        private LogPublisher logPublisher;
        private EgressPublisher egressPublisher;
        private DutyCycleTracker dutyCycleTracker;
        private boolean isLogMdc;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            ChannelUri channelUri;
            ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
            if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
                throw new ConcurrentConcludeException();
            }
            this.validateLogChannel();
            if (null == this.clusterDir) {
                this.clusterDir = new File(this.clusterDirectoryName);
            }
            if (this.deleteDirOnStart) {
                IoUtil.delete(this.clusterDir, false);
            }
            if (!this.clusterDir.exists() && !this.clusterDir.mkdirs()) {
                throw new ClusterException("failed to create cluster dir: " + this.clusterDir.getAbsolutePath());
            }
            if (null == this.clusterClock) {
                this.clusterClock = new MillisecondClusterClock();
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.clusterTimeConsumerSupplier) {
                this.clusterTimeConsumerSupplier = ctx -> timestamp -> {};
            }
            if (null == this.markFile) {
                this.markFile = new ClusterMarkFile(new File(this.clusterDir, "cluster-mark.dat"), ClusterComponentType.CONSENSUS_MODULE, this.errorBufferLength, this.epochClock, 0L);
            }
            if (null == this.errorLog) {
                this.errorLog = new DistinctErrorLog(this.markFile.errorBuffer(), this.epochClock, StandardCharsets.US_ASCII);
            }
            this.errorHandler = CommonContext.setupErrorHandler(this.errorHandler, this.errorLog);
            if (null == this.recordingLog) {
                this.recordingLog = new RecordingLog(this.clusterDir, true);
            }
            if (null == this.aeron) {
                this.ownsAeronClient = true;
                this.aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).errorHandler(this.errorHandler).epochClock(this.epochClock).useConductorAgentInvoker(true).subscriberErrorHandler(RethrowingErrorHandler.INSTANCE).awaitingIdleStrategy(YieldingIdleStrategy.INSTANCE).clientLock(NoOpLock.INSTANCE));
                if (null == this.errorCounter) {
                    this.errorCounter = this.aeron.addCounter(212, "Cluster Errors - clusterId=" + this.clusterId);
                }
            }
            if (null == this.ingressChannel) {
                throw new ClusterException("ingressChannel must be specified");
            }
            if (!(this.aeron.context().subscriberErrorHandler() instanceof RethrowingErrorHandler)) {
                throw new ClusterException("Aeron client must use a RethrowingErrorHandler");
            }
            if (null == this.aeron.conductorAgentInvoker()) {
                throw new ClusterException("Aeron client must use conductor agent invoker");
            }
            if (null == this.errorCounter) {
                throw new ClusterException("error counter must be supplied if aeron client is");
            }
            if (null == this.countedErrorHandler) {
                this.countedErrorHandler = new CountedErrorHandler(this.errorHandler, this.errorCounter);
                if (this.ownsAeronClient) {
                    this.aeron.context().errorHandler(this.countedErrorHandler);
                }
            }
            if (null == this.moduleStateCounter) {
                CountersReader counters = this.aeron.countersReader();
                if (-1 != ClusterCounters.find(counters, 200, this.clusterId)) {
                    throw new ClusterException("existing consensus module detected for clusterId=" + this.clusterId);
                }
                this.moduleStateCounter = ClusterCounters.allocate(this.aeron, buffer, "Consensus Module state", 200, this.clusterId);
            }
            if (null == this.electionStateCounter) {
                this.electionStateCounter = ClusterCounters.allocate(this.aeron, buffer, "Cluster election state", 207, this.clusterId);
            }
            if (null == this.clusterNodeRoleCounter) {
                this.clusterNodeRoleCounter = ClusterCounters.allocate(this.aeron, buffer, "Cluster node role", 201, this.clusterId);
            }
            if (null == this.commitPosition) {
                this.commitPosition = ClusterCounters.allocate(this.aeron, buffer, "Cluster commit-pos:", 203, this.clusterId);
            }
            if (null == this.controlToggle) {
                this.controlToggle = ClusterCounters.allocate(this.aeron, buffer, "Cluster control toggle", 202, this.clusterId);
            }
            if (null == this.snapshotCounter) {
                this.snapshotCounter = ClusterCounters.allocate(this.aeron, buffer, "Cluster snapshot count", 205, this.clusterId);
            }
            if (null == this.timedOutClientCounter) {
                this.timedOutClientCounter = ClusterCounters.allocate(this.aeron, buffer, "Cluster timed out client count", 213, this.clusterId);
            }
            if (null == this.dutyCycleTracker) {
                this.dutyCycleTracker = new DutyCycleStallTracker(ClusterCounters.allocate(this.aeron, buffer, "Cluster max cycle time (ns)", 216, this.clusterId), ClusterCounters.allocate(this.aeron, buffer, "Cluster work cycle time exceeded count: threshold=" + this.cycleThresholdNs + "ns", 217, this.clusterId), this.cycleThresholdNs);
            }
            if (null == this.threadFactory) {
                this.threadFactory = Thread::new;
            }
            if (null == this.idleStrategySupplier) {
                this.idleStrategySupplier = ClusteredServiceContainer.Configuration.idleStrategySupplier(null);
            }
            if (null == this.timerServiceSupplier) {
                this.timerServiceSupplier = this.getTimerServiceSupplierFromSystemProperty();
            }
            if (null == this.archiveContext) {
                this.archiveContext = new AeronArchive.Context().controlRequestChannel(AeronArchive.Configuration.localControlChannel()).controlResponseChannel(AeronArchive.Configuration.localControlChannel()).controlRequestStreamId(AeronArchive.Configuration.localControlStreamId());
            }
            if (!this.archiveContext.controlRequestChannel().startsWith("aeron:ipc")) {
                throw new ClusterException("local archive control must be IPC");
            }
            if (!this.archiveContext.controlResponseChannel().startsWith("aeron:ipc")) {
                throw new ClusterException("local archive control must be IPC");
            }
            if (null == this.replicationChannel) {
                throw new ClusterException("replicationChannel must be set");
            }
            this.archiveContext.aeron(this.aeron).errorHandler(this.countedErrorHandler).ownsAeronClient(false).lock(NoOpLock.INSTANCE);
            if (null == this.shutdownSignalBarrier) {
                this.shutdownSignalBarrier = new ShutdownSignalBarrier();
            }
            if (null == this.terminationHook) {
                this.terminationHook = () -> this.shutdownSignalBarrier.signalAll();
            }
            if (null == this.authenticatorSupplier) {
                this.authenticatorSupplier = Configuration.authenticatorSupplier();
            }
            if (null == this.authorisationServiceSupplier) {
                this.authorisationServiceSupplier = Configuration.authorisationServiceSupplier();
            }
            if (null == this.random) {
                this.random = new Random();
            }
            if (null == this.logPublisher) {
                this.logPublisher = new LogPublisher(this.logChannel());
            }
            if (null == this.egressPublisher) {
                this.egressPublisher = new EgressPublisher();
            }
            this.isLogMdc = (channelUri = ChannelUri.parse(this.logChannel())).isUdp() && null == channelUri.get("endpoint");
            this.concludeMarkFile();
        }

        public Context deleteDirOnStart(boolean deleteDirOnStart) {
            this.deleteDirOnStart = deleteDirOnStart;
            return this;
        }

        public boolean deleteDirOnStart() {
            return this.deleteDirOnStart;
        }

        public Context clusterDirectoryName(String clusterDirectoryName) {
            this.clusterDirectoryName = clusterDirectoryName;
            return this;
        }

        public String clusterDirectoryName() {
            return this.clusterDirectoryName;
        }

        public Context clusterDir(File clusterDir) {
            this.clusterDir = clusterDir;
            return this;
        }

        public File clusterDir() {
            return this.clusterDir;
        }

        public Context recordingLog(RecordingLog recordingLog) {
            this.recordingLog = recordingLog;
            return this;
        }

        public RecordingLog recordingLog() {
            return this.recordingLog;
        }

        public Context appVersion(int appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public int appVersion() {
            return this.appVersion;
        }

        int fileSyncLevel() {
            return this.fileSyncLevel;
        }

        public Context fileSyncLevel(int syncLevel) {
            this.fileSyncLevel = syncLevel;
            return this;
        }

        public Context clusterId(int clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public int clusterId() {
            return this.clusterId;
        }

        public Context clusterMemberId(int clusterMemberId) {
            this.clusterMemberId = clusterMemberId;
            return this;
        }

        public int clusterMemberId() {
            return this.clusterMemberId;
        }

        public Context appointedLeaderId(int appointedLeaderId) {
            this.appointedLeaderId = appointedLeaderId;
            return this;
        }

        public int appointedLeaderId() {
            return this.appointedLeaderId;
        }

        public Context clusterMembers(String clusterMembers) {
            this.clusterMembers = clusterMembers;
            return this;
        }

        public String clusterMembers() {
            return this.clusterMembers;
        }

        public Context clusterConsensusEndpoints(String endpoints) {
            this.clusterConsensusEndpoints = endpoints;
            return this;
        }

        public String clusterConsensusEndpoints() {
            return this.clusterConsensusEndpoints;
        }

        public Context clusterMembersIgnoreSnapshot(boolean ignore) {
            this.clusterMembersIgnoreSnapshot = ignore;
            return this;
        }

        public boolean clusterMembersIgnoreSnapshot() {
            return this.clusterMembersIgnoreSnapshot;
        }

        public Context ingressChannel(String channel) {
            this.ingressChannel = channel;
            return this;
        }

        public String ingressChannel() {
            return this.ingressChannel;
        }

        public Context ingressStreamId(int streamId) {
            this.ingressStreamId = streamId;
            return this;
        }

        public int ingressStreamId() {
            return this.ingressStreamId;
        }

        public Context ingressFragmentLimit(int ingressFragmentLimit) {
            this.ingressFragmentLimit = ingressFragmentLimit;
            return this;
        }

        public int ingressFragmentLimit() {
            return this.ingressFragmentLimit;
        }

        public Context egressChannel(String channel) {
            this.egressChannel = channel;
            return this;
        }

        public String egressChannel() {
            return this.egressChannel;
        }

        public Context isIpcIngressAllowed(boolean isIpcIngressAllowed) {
            this.isIpcIngressAllowed = isIpcIngressAllowed;
            return this;
        }

        public boolean isIpcIngressAllowed() {
            return this.isIpcIngressAllowed;
        }

        public Context logChannel(String channel) {
            this.logChannel = channel;
            return this;
        }

        public String logChannel() {
            return this.logChannel;
        }

        public Context logStreamId(int streamId) {
            this.logStreamId = streamId;
            return this;
        }

        public int logStreamId() {
            return this.logStreamId;
        }

        public Context memberEndpoints(String endpoints) {
            this.memberEndpoints = endpoints;
            return this;
        }

        public String memberEndpoints() {
            return this.memberEndpoints;
        }

        public Context replayChannel(String channel) {
            this.replayChannel = channel;
            return this;
        }

        public String replayChannel() {
            return this.replayChannel;
        }

        public Context replayStreamId(int streamId) {
            this.replayStreamId = streamId;
            return this;
        }

        public int replayStreamId() {
            return this.replayStreamId;
        }

        public Context controlChannel(String channel) {
            this.controlChannel = channel;
            return this;
        }

        public String controlChannel() {
            return this.controlChannel;
        }

        public Context serviceStreamId(int streamId) {
            this.serviceStreamId = streamId;
            return this;
        }

        public int serviceStreamId() {
            return this.serviceStreamId;
        }

        public Context consensusModuleStreamId(int streamId) {
            this.consensusModuleStreamId = streamId;
            return this;
        }

        public int consensusModuleStreamId() {
            return this.consensusModuleStreamId;
        }

        public Context snapshotChannel(String channel) {
            this.snapshotChannel = channel;
            return this;
        }

        public String snapshotChannel() {
            return this.snapshotChannel;
        }

        public Context snapshotStreamId(int streamId) {
            this.snapshotStreamId = streamId;
            return this;
        }

        public int snapshotStreamId() {
            return this.snapshotStreamId;
        }

        public Context consensusChannel(String channel) {
            this.consensusChannel = channel;
            return this;
        }

        public String consensusChannel() {
            return this.consensusChannel;
        }

        public Context consensusStreamId(int streamId) {
            this.consensusStreamId = streamId;
            return this;
        }

        public int consensusStreamId() {
            return this.consensusStreamId;
        }

        public Context replicationChannel(String channel) {
            this.replicationChannel = channel;
            return this;
        }

        public String replicationChannel() {
            return this.replicationChannel;
        }

        public Context followerCatchupChannel(String channel) {
            this.followerCatchupChannel = channel;
            return this;
        }

        public String followerCatchupChannel() {
            return this.followerCatchupChannel;
        }

        public Context leaderArchiveControlChannel(String channel) {
            this.leaderArchiveControlChannel = channel;
            return this;
        }

        public String leaderArchiveControlChannel() {
            return this.leaderArchiveControlChannel;
        }

        public Context logFragmentLimit(int logFragmentLimit) {
            this.logFragmentLimit = logFragmentLimit;
            return this;
        }

        public int logFragmentLimit() {
            return this.logFragmentLimit;
        }

        public Context wheelTickResolutionNs(long wheelTickResolutionNs) {
            this.wheelTickResolutionNs = wheelTickResolutionNs;
            return this;
        }

        public long wheelTickResolutionNs() {
            return this.wheelTickResolutionNs;
        }

        public Context ticksPerWheel(int ticksPerWheel) {
            this.ticksPerWheel = ticksPerWheel;
            return this;
        }

        public int ticksPerWheel() {
            return this.ticksPerWheel;
        }

        public Context serviceCount(int serviceCount) {
            this.serviceCount = serviceCount;
            return this;
        }

        public int serviceCount() {
            return this.serviceCount;
        }

        public Context maxConcurrentSessions(int maxSessions) {
            this.maxConcurrentSessions = maxSessions;
            return this;
        }

        public int maxConcurrentSessions() {
            return this.maxConcurrentSessions;
        }

        public Context sessionTimeoutNs(long sessionTimeoutNs) {
            this.sessionTimeoutNs = sessionTimeoutNs;
            return this;
        }

        public long sessionTimeoutNs() {
            return CommonContext.checkDebugTimeout(this.sessionTimeoutNs, TimeUnit.NANOSECONDS);
        }

        public Context leaderHeartbeatTimeoutNs(long heartbeatTimeoutNs) {
            this.leaderHeartbeatTimeoutNs = heartbeatTimeoutNs;
            return this;
        }

        public long leaderHeartbeatTimeoutNs() {
            return this.leaderHeartbeatTimeoutNs;
        }

        public Context leaderHeartbeatIntervalNs(long heartbeatIntervalNs) {
            this.leaderHeartbeatIntervalNs = heartbeatIntervalNs;
            return this;
        }

        public long leaderHeartbeatIntervalNs() {
            return this.leaderHeartbeatIntervalNs;
        }

        public Context startupCanvassTimeoutNs(long timeoutNs) {
            this.startupCanvassTimeoutNs = timeoutNs;
            return this;
        }

        public long startupCanvassTimeoutNs() {
            return this.startupCanvassTimeoutNs;
        }

        public Context electionTimeoutNs(long timeoutNs) {
            this.electionTimeoutNs = timeoutNs;
            return this;
        }

        public long electionTimeoutNs() {
            return this.electionTimeoutNs;
        }

        public Context electionStatusIntervalNs(long electionStatusIntervalNs) {
            this.electionStatusIntervalNs = electionStatusIntervalNs;
            return this;
        }

        public long electionStatusIntervalNs() {
            return this.electionStatusIntervalNs;
        }

        public Context dynamicJoinIntervalNs(long dynamicJoinIntervalNs) {
            this.dynamicJoinIntervalNs = dynamicJoinIntervalNs;
            return this;
        }

        public long dynamicJoinIntervalNs() {
            return this.dynamicJoinIntervalNs;
        }

        public Context terminationTimeoutNs(long terminationTimeoutNs) {
            this.terminationTimeoutNs = terminationTimeoutNs;
            return this;
        }

        public long terminationTimeoutNs() {
            return this.terminationTimeoutNs;
        }

        public Context cycleThresholdNs(long thresholdNs) {
            this.cycleThresholdNs = thresholdNs;
            return this;
        }

        public long cycleThresholdNs() {
            return this.cycleThresholdNs;
        }

        public Context dutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.dutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker dutyCycleTracker() {
            return this.dutyCycleTracker;
        }

        public String agentRoleName() {
            return this.agentRoleName;
        }

        public Context agentRoleName(String agentRoleName) {
            this.agentRoleName = agentRoleName;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Context idleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.idleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategySupplier.get();
        }

        public Context clusterClock(ClusterClock clock) {
            this.clusterClock = clock;
            return this;
        }

        public ClusterClock clusterClock() {
            return this.clusterClock;
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context clusterTimeConsumerSupplier(Function<Context, LongConsumer> clusterTimeConsumerSupplier) {
            this.clusterTimeConsumerSupplier = clusterTimeConsumerSupplier;
            return this;
        }

        public Function<Context, LongConsumer> clusterTimeConsumerSupplier() {
            return this.clusterTimeConsumerSupplier;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Context countedErrorHandler(CountedErrorHandler countedErrorHandler) {
            this.countedErrorHandler = countedErrorHandler;
            return this;
        }

        public CountedErrorHandler countedErrorHandler() {
            return this.countedErrorHandler;
        }

        public AtomicCounter errorCounter() {
            return this.errorCounter;
        }

        public Context errorCounter(AtomicCounter errorCounter) {
            this.errorCounter = errorCounter;
            return this;
        }

        public Counter moduleStateCounter() {
            return this.moduleStateCounter;
        }

        public Context moduleStateCounter(Counter moduleState) {
            this.moduleStateCounter = moduleState;
            return this;
        }

        public Counter electionStateCounter() {
            return this.electionStateCounter;
        }

        public Context electionStateCounter(Counter electionStateCounter) {
            this.electionStateCounter = electionStateCounter;
            return this;
        }

        public Counter commitPositionCounter() {
            return this.commitPosition;
        }

        public Context commitPositionCounter(Counter commitPosition) {
            this.commitPosition = commitPosition;
            return this;
        }

        public Counter clusterNodeRoleCounter() {
            return this.clusterNodeRoleCounter;
        }

        public Context clusterNodeRoleCounter(Counter nodeRole) {
            this.clusterNodeRoleCounter = nodeRole;
            return this;
        }

        public Counter controlToggleCounter() {
            return this.controlToggle;
        }

        public Context controlToggleCounter(Counter controlToggle) {
            this.controlToggle = controlToggle;
            return this;
        }

        public Counter snapshotCounter() {
            return this.snapshotCounter;
        }

        public Context snapshotCounter(Counter snapshotCounter) {
            this.snapshotCounter = snapshotCounter;
            return this;
        }

        public Counter timedOutClientCounter() {
            return this.timedOutClientCounter;
        }

        public Context timedOutClientCounter(Counter timedOutClientCounter) {
            this.timedOutClientCounter = timedOutClientCounter;
            return this;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public Context archiveContext(AeronArchive.Context archiveContext) {
            this.archiveContext = archiveContext;
            return this;
        }

        public AeronArchive.Context archiveContext() {
            return this.archiveContext;
        }

        public AuthenticatorSupplier authenticatorSupplier() {
            return this.authenticatorSupplier;
        }

        public Context authenticatorSupplier(AuthenticatorSupplier authenticatorSupplier) {
            this.authenticatorSupplier = authenticatorSupplier;
            return this;
        }

        public AuthorisationServiceSupplier authorisationServiceSupplier() {
            return this.authorisationServiceSupplier;
        }

        public Context authorisationServiceSupplier(AuthorisationServiceSupplier authorisationServiceSupplier) {
            this.authorisationServiceSupplier = authorisationServiceSupplier;
            return this;
        }

        public Context shutdownSignalBarrier(ShutdownSignalBarrier barrier) {
            this.shutdownSignalBarrier = barrier;
            return this;
        }

        public ShutdownSignalBarrier shutdownSignalBarrier() {
            return this.shutdownSignalBarrier;
        }

        public Context terminationHook(Runnable terminationHook) {
            this.terminationHook = terminationHook;
            return this;
        }

        public Runnable terminationHook() {
            return this.terminationHook;
        }

        public Context clusterMarkFile(ClusterMarkFile markFile) {
            this.markFile = markFile;
            return this;
        }

        public ClusterMarkFile clusterMarkFile() {
            return this.markFile;
        }

        public Context errorBufferLength(int errorBufferLength) {
            this.errorBufferLength = errorBufferLength;
            return this;
        }

        public int errorBufferLength() {
            return this.errorBufferLength;
        }

        public Context errorLog(DistinctErrorLog errorLog) {
            this.errorLog = errorLog;
            return this;
        }

        public DistinctErrorLog errorLog() {
            return this.errorLog;
        }

        public Context random(Random random) {
            this.random = random;
            return this;
        }

        public Random random() {
            return this.random;
        }

        public Context timerServiceSupplier(TimerServiceSupplier timerServiceSupplier) {
            this.timerServiceSupplier = timerServiceSupplier;
            return this;
        }

        public TimerServiceSupplier timerServiceSupplier() {
            return this.timerServiceSupplier;
        }

        public void deleteDirectory() {
            if (null != this.clusterDir) {
                IoUtil.delete(this.clusterDir, false);
            }
        }

        public void close() {
            CloseHelper.close(this.countedErrorHandler, this.recordingLog);
            CloseHelper.close(this.countedErrorHandler, this.markFile);
            if (this.errorHandler instanceof AutoCloseable) {
                CloseHelper.quietClose((AutoCloseable)((Object)this.errorHandler));
            }
            if (this.ownsAeronClient) {
                CloseHelper.close(this.aeron);
            } else if (!this.aeron.isClosed()) {
                CloseHelper.closeAll(this.moduleStateCounter, this.clusterNodeRoleCounter, this.electionStateCounter, this.commitPosition, this.controlToggle, this.snapshotCounter, this.timedOutClientCounter);
            }
        }

        Context logPublisher(LogPublisher logPublisher) {
            this.logPublisher = logPublisher;
            return this;
        }

        LogPublisher logPublisher() {
            return this.logPublisher;
        }

        Context egressPublisher(EgressPublisher egressPublisher) {
            this.egressPublisher = egressPublisher;
            return this;
        }

        EgressPublisher egressPublisher() {
            return this.egressPublisher;
        }

        boolean isLogMdc() {
            return this.isLogMdc;
        }

        private void concludeMarkFile() {
            ClusterMarkFile.checkHeaderLength(this.aeron.context().aeronDirectoryName(), this.controlChannel(), this.ingressChannel, null, this.authenticatorSupplier.getClass().toString());
            this.markFile.encoder().archiveStreamId(this.archiveContext.controlRequestStreamId()).serviceStreamId(this.serviceStreamId).consensusModuleStreamId(this.consensusModuleStreamId).ingressStreamId(this.ingressStreamId).memberId(this.clusterMemberId).serviceId(-1).clusterId(this.clusterId).aeronDirectory(this.aeron.context().aeronDirectoryName()).controlChannel(this.controlChannel).ingressChannel(this.ingressChannel).serviceName("").authenticator(this.authenticatorSupplier.getClass().toString());
            this.markFile.updateActivityTimestamp(this.epochClock.time());
            this.markFile.signalReady();
        }

        private TimerServiceSupplier getTimerServiceSupplierFromSystemProperty() {
            String timeServiceClassName = Configuration.timerServiceSupplier();
            if (WheelTimerServiceSupplier.class.getName().equals(timeServiceClassName)) {
                return new WheelTimerServiceSupplier(this.clusterClock.timeUnit(), 0L, BitUtil.findNextPositivePowerOfTwo(this.clusterClock.timeUnit().convert(this.wheelTickResolutionNs, TimeUnit.NANOSECONDS)), this.ticksPerWheel);
            }
            if (PriorityHeapTimerServiceSupplier.class.getName().equals(timeServiceClassName)) {
                return new PriorityHeapTimerServiceSupplier();
            }
            throw new ClusterException("invalid TimerServiceSupplier: " + timeServiceClassName);
        }

        private void validateLogChannel() {
            ChannelUri logChannelUri = ChannelUri.parse(this.logChannel);
            Context.verifyNotPresent(logChannelUri, "logChannel", "init-term-id");
            Context.verifyNotPresent(logChannelUri, "logChannel", "term-id");
            Context.verifyNotPresent(logChannelUri, "logChannel", "term-offset");
        }

        private static void verifyNotPresent(ChannelUri channelUri, String name, String paramName) {
            if (channelUri.containsKey(paramName)) {
                throw new ConfigurationException(name + " must not contain: " + paramName);
            }
        }

        public String toString() {
            return "ConsensusModule.Context\n{\n    isConcluded=" + (1 == this.isConcluded) + "\n    ownsAeronClient=" + this.ownsAeronClient + "\n    aeronDirectoryName='" + this.aeronDirectoryName + '\'' + "\n    aeron=" + this.aeron + "\n    deleteDirOnStart=" + this.deleteDirOnStart + "\n    clusterDirectoryName='" + this.clusterDirectoryName + '\'' + "\n    clusterDir=" + this.clusterDir + "\n    recordingLog=" + this.recordingLog + "\n    markFile=" + this.markFile + "\n    fileSyncLevel=" + this.fileSyncLevel + "\n    appVersion=" + this.appVersion + "\n    clusterId=" + this.clusterId + "\n    clusterMemberId=" + this.clusterMemberId + "\n    appointedLeaderId=" + this.appointedLeaderId + "\n    clusterMembers='" + this.clusterMembers + '\'' + "\n    clusterConsensusEndpoints='" + this.clusterConsensusEndpoints + '\'' + "\n    clusterMembersIgnoreSnapshot=" + this.clusterMembersIgnoreSnapshot + "\n    ingressChannel='" + this.ingressChannel + '\'' + "\n    ingressStreamId=" + this.ingressStreamId + "\n    ingressFragmentLimit=" + this.ingressFragmentLimit + "\n    logChannel='" + this.logChannel + '\'' + "\n    logStreamId=" + this.logStreamId + "\n    memberEndpoints='" + this.memberEndpoints + '\'' + "\n    replayChannel='" + this.replayChannel + '\'' + "\n    replayStreamId=" + this.replayStreamId + "\n    controlChannel='" + this.controlChannel + '\'' + "\n    consensusModuleStreamId=" + this.consensusModuleStreamId + "\n    serviceStreamId=" + this.serviceStreamId + "\n    snapshotChannel='" + this.snapshotChannel + '\'' + "\n    snapshotStreamId=" + this.snapshotStreamId + "\n    consensusChannel='" + this.consensusChannel + '\'' + "\n    consensusStreamId=" + this.consensusStreamId + "\n    replicationChannel='" + this.replicationChannel + '\'' + "\n    logFragmentLimit=" + this.logFragmentLimit + "\n    serviceCount=" + this.serviceCount + "\n    errorBufferLength=" + this.errorBufferLength + "\n    maxConcurrentSessions=" + this.maxConcurrentSessions + "\n    ticksPerWheel=" + this.ticksPerWheel + "\n    wheelTickResolutionNs=" + this.wheelTickResolutionNs + "\n    timerServiceSupplier=" + this.timerServiceSupplier + "\n    sessionTimeoutNs=" + this.sessionTimeoutNs + "\n    leaderHeartbeatTimeoutNs=" + this.leaderHeartbeatTimeoutNs + "\n    leaderHeartbeatIntervalNs=" + this.leaderHeartbeatIntervalNs + "\n    startupCanvassTimeoutNs=" + this.startupCanvassTimeoutNs + "\n    electionTimeoutNs=" + this.electionTimeoutNs + "\n    electionStatusIntervalNs=" + this.electionStatusIntervalNs + "\n    dynamicJoinIntervalNs=" + this.dynamicJoinIntervalNs + "\n    terminationTimeoutNs=" + this.terminationTimeoutNs + "\n    threadFactory=" + this.threadFactory + "\n    idleStrategySupplier=" + this.idleStrategySupplier + "\n    clusterClock=" + this.clusterClock + "\n    epochClock=" + this.epochClock + "\n    random=" + this.random + "\n    errorLog=" + this.errorLog + "\n    errorHandler=" + this.errorHandler + "\n    errorCounter=" + this.errorCounter + "\n    countedErrorHandler=" + this.countedErrorHandler + "\n    moduleStateCounter=" + this.moduleStateCounter + "\n    electionStateCounter=" + this.electionStateCounter + "\n    clusterNodeRoleCounter=" + this.clusterNodeRoleCounter + "\n    commitPosition=" + this.commitPosition + "\n    controlToggle=" + this.controlToggle + "\n    snapshotCounter=" + this.snapshotCounter + "\n    timedOutClientCounter=" + this.timedOutClientCounter + "\n    shutdownSignalBarrier=" + this.shutdownSignalBarrier + "\n    terminationHook=" + this.terminationHook + "\n    archiveContext=" + this.archiveContext + "\n    authenticatorSupplier=" + this.authenticatorSupplier + "\n    logPublisher=" + this.logPublisher + "\n    egressPublisher=" + this.egressPublisher + "\n    isLogMdc=" + this.isLogMdc + "\n    cycleThresholdNs=" + this.cycleThresholdNs + "\n    dutyCyleTracker=" + this.dutyCycleTracker + "\n}";
        }
    }

    public static final class Configuration {
        public static final long SNAPSHOT_TYPE_ID = 1L;
        public static final String CLUSTER_INGRESS_FRAGMENT_LIMIT_PROP_NAME = "aeron.cluster.ingress.fragment.limit";
        public static final int CLUSTER_INGRESS_FRAGMENT_LIMIT_DEFAULT = 50;
        public static final String CLUSTER_INGRESS_IPC_ALLOWED_PROP_NAME = "aeron.cluster.ingress.ipc.allowed";
        public static final String CLUSTER_INGRESS_IPC_ALLOWED_DEFAULT = "false";
        public static final int SERVICE_ID = -1;
        public static final String CLUSTER_MEMBER_ID_PROP_NAME = "aeron.cluster.member.id";
        public static final int CLUSTER_MEMBER_ID_DEFAULT = 0;
        public static final String APPOINTED_LEADER_ID_PROP_NAME = "aeron.cluster.appointed.leader.id";
        public static final int APPOINTED_LEADER_ID_DEFAULT = -1;
        public static final String CLUSTER_MEMBERS_PROP_NAME = "aeron.cluster.members";
        public static final String CLUSTER_MEMBERS_DEFAULT = "0,localhost:20000,localhost:20001,localhost:20002,localhost:0,localhost:8010";
        public static final String CLUSTER_CONSENSUS_ENDPOINTS_PROP_NAME = "aeron.cluster.consensus.endpoints";
        public static final String CLUSTER_CONSENSUS_ENDPOINTS_DEFAULT = "";
        public static final String CLUSTER_MEMBERS_IGNORE_SNAPSHOT_PROP_NAME = "aeron.cluster.members.ignore.snapshot";
        public static final String CLUSTER_MEMBERS_IGNORE_SNAPSHOT_DEFAULT = "false";
        public static final String LOG_CHANNEL_PROP_NAME = "aeron.cluster.log.channel";
        public static final String LOG_CHANNEL_DEFAULT = "aeron:udp?term-length=64m";
        public static final String MEMBER_ENDPOINTS_PROP_NAME = "aeron.cluster.member.endpoints";
        public static final String MEMBER_ENDPOINTS_DEFAULT = "";
        public static final String LOG_STREAM_ID_PROP_NAME = "aeron.cluster.log.stream.id";
        public static final int LOG_STREAM_ID_DEFAULT = 100;
        public static final String SNAPSHOT_CHANNEL_DEFAULT = "aeron:ipc?alias=snapshot";
        public static final int SNAPSHOT_STREAM_ID_DEFAULT = 107;
        public static final String SESSION_LIMIT_MSG = "concurrent session limit";
        public static final String SESSION_REJECTED_MSG = "session failed authentication";
        public static final String SESSION_INVALID_VERSION_MSG = "invalid client version";
        public static final String CONSENSUS_CHANNEL_PROP_NAME = "aeron.cluster.consensus.channel";
        public static final String CONSENSUS_CHANNEL_DEFAULT = "aeron:udp?term-length=64k";
        public static final String CONSENSUS_STREAM_ID_PROP_NAME = "aeron.cluster.consensus.stream.id";
        public static final int CONSENSUS_STREAM_ID_DEFAULT = 108;
        public static final String REPLICATION_CHANNEL_PROP_NAME = "aeron.cluster.replication.channel";
        public static final String FOLLOWER_CATCHUP_CHANNEL_PROP_NAME = "aeron.cluster.follower.catchup.channel";
        public static final String FOLLOWER_CATCHUP_CHANNEL_DEFAULT = "aeron:udp";
        public static final String LEADER_ARCHIVE_CONTROL_CHANNEL_PROP_NAME = "aeron.cluster.leader.archive.control.channel";
        public static final String LEADER_ARCHIVE_CONTROL_CHANNEL_DEFAULT = "aeron:udp?term-length=64k";
        public static final int CONSENSUS_MODULE_STATE_TYPE_ID = 200;
        public static final int CLUSTER_NODE_ROLE_TYPE_ID = 201;
        public static final int CONTROL_TOGGLE_TYPE_ID = 202;
        public static final int COMMIT_POSITION_TYPE_ID = 203;
        public static final int RECOVERY_STATE_TYPE_ID = 204;
        public static final int SNAPSHOT_COUNTER_TYPE_ID = 205;
        public static final int ELECTION_STATE_TYPE_ID = 207;
        public static final int CONSENSUS_MODULE_ERROR_COUNT_TYPE_ID = 212;
        public static final int CLUSTER_CLIENT_TIMEOUT_COUNT_TYPE_ID = 213;
        public static final int CLUSTER_INVALID_REQUEST_COUNT_TYPE_ID = 214;
        public static final String SERVICE_COUNT_PROP_NAME = "aeron.cluster.service.count";
        public static final int SERVICE_COUNT_DEFAULT = 1;
        public static final String MAX_CONCURRENT_SESSIONS_PROP_NAME = "aeron.cluster.max.sessions";
        public static final int MAX_CONCURRENT_SESSIONS_DEFAULT = 10;
        public static final String SESSION_TIMEOUT_PROP_NAME = "aeron.cluster.session.timeout";
        public static final long SESSION_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
        public static final String LEADER_HEARTBEAT_TIMEOUT_PROP_NAME = "aeron.cluster.leader.heartbeat.timeout";
        public static final long LEADER_HEARTBEAT_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
        public static final String LEADER_HEARTBEAT_INTERVAL_PROP_NAME = "aeron.cluster.leader.heartbeat.interval";
        public static final long LEADER_HEARTBEAT_INTERVAL_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(200L);
        public static final String STARTUP_CANVASS_TIMEOUT_PROP_NAME = "aeron.cluster.startup.canvass.timeout";
        public static final long STARTUP_CANVASS_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(60L);
        public static final String ELECTION_TIMEOUT_PROP_NAME = "aeron.cluster.election.timeout";
        public static final long ELECTION_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(1L);
        public static final String ELECTION_STATUS_INTERVAL_PROP_NAME = "aeron.cluster.election.status.interval";
        public static final long ELECTION_STATUS_INTERVAL_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(100L);
        public static final String DYNAMIC_JOIN_INTERVAL_PROP_NAME = "aeron.cluster.dynamic.join.interval";
        public static final long DYNAMIC_JOIN_INTERVAL_DEFAULT_NS = TimeUnit.SECONDS.toNanos(1L);
        public static final String AUTHENTICATOR_SUPPLIER_PROP_NAME = "aeron.cluster.authenticator.supplier";
        public static final String AUTHENTICATOR_SUPPLIER_DEFAULT = "io.aeron.security.DefaultAuthenticatorSupplier";
        public static final String AUTHORISATION_SERVICE_SUPPLIER_PROP_NAME = "aeron.cluster.authorisation.service.supplier";
        public static final AuthorisationServiceSupplier DEFAULT_AUTHORISATION_SERVICE_SUPPLIER = () -> AuthorisationService.DENY_ALL;
        public static final String ERROR_BUFFER_LENGTH_PROP_NAME = "aeron.cluster.error.buffer.length";
        public static final int ERROR_BUFFER_LENGTH_DEFAULT = 0x100000;
        public static final String TERMINATION_TIMEOUT_PROP_NAME = "aeron.cluster.termination.timeout";
        public static final String CYCLE_THRESHOLD_PROP_NAME = "aeron.cluster.cycle.threshold";
        public static final long CYCLE_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
        public static final long TERMINATION_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
        public static final String WHEEL_TICK_RESOLUTION_PROP_NAME = "aeron.cluster.wheel.tick.resolution";
        public static final long WHEEL_TICK_RESOLUTION_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(8L);
        public static final String TICKS_PER_WHEEL_PROP_NAME = "aeron.cluster.ticks.per.wheel";
        public static final int TICKS_PER_WHEEL_DEFAULT = 128;
        public static final String FILE_SYNC_LEVEL_PROP_NAME = "aeron.cluster.file.sync.level";
        public static final int FILE_SYNC_LEVEL_DEFAULT = 0;
        public static final String TIMER_SERVICE_SUPPLIER_PROP_NAME = "aeron.cluster.timer.service.supplier";
        public static final String TIMER_SERVICE_SUPPLIER_WHEEL = "io.aeron.cluster.WheelTimerServiceSupplier";
        public static final String TIMER_SERVICE_SUPPLIER_PRIORITY_HEAP = "io.aeron.cluster.PriorityHeapTimerServiceSupplier";
        public static final String TIMER_SERVICE_SUPPLIER_DEFAULT = "io.aeron.cluster.WheelTimerServiceSupplier";
        public static final String CLUSTER_CONSENSUS_MODULE_AGENT_ROLE_NAME_PROP_NAME = "aeron.cluster.consensus.module.agent.role.name";

        public static int ingressFragmentLimit() {
            return Integer.getInteger(CLUSTER_INGRESS_FRAGMENT_LIMIT_PROP_NAME, 50);
        }

        public static boolean isIpcIngressAllowed() {
            return "true".equalsIgnoreCase(System.getProperty(CLUSTER_INGRESS_IPC_ALLOWED_PROP_NAME, "false"));
        }

        public static int clusterMemberId() {
            return Integer.getInteger(CLUSTER_MEMBER_ID_PROP_NAME, 0);
        }

        public static int appointedLeaderId() {
            return Integer.getInteger(APPOINTED_LEADER_ID_PROP_NAME, -1);
        }

        public static String clusterMembers() {
            return System.getProperty(CLUSTER_MEMBERS_PROP_NAME, CLUSTER_MEMBERS_DEFAULT);
        }

        public static String clusterConsensusEndpoints() {
            return System.getProperty(CLUSTER_CONSENSUS_ENDPOINTS_PROP_NAME, "");
        }

        public static boolean clusterMembersIgnoreSnapshot() {
            return "true".equalsIgnoreCase(System.getProperty(CLUSTER_MEMBERS_IGNORE_SNAPSHOT_PROP_NAME, "false"));
        }

        public static String logChannel() {
            return System.getProperty(LOG_CHANNEL_PROP_NAME, LOG_CHANNEL_DEFAULT);
        }

        public static int logStreamId() {
            return Integer.getInteger(LOG_STREAM_ID_PROP_NAME, 100);
        }

        public static String memberEndpoints() {
            return System.getProperty(MEMBER_ENDPOINTS_PROP_NAME, "");
        }

        public static String snapshotChannel() {
            return System.getProperty("aeron.cluster.snapshot.channel", SNAPSHOT_CHANNEL_DEFAULT);
        }

        public static int snapshotStreamId() {
            return Integer.getInteger("aeron.cluster.snapshot.stream.id", 107);
        }

        public static int serviceCount() {
            return Integer.getInteger(SERVICE_COUNT_PROP_NAME, 1);
        }

        public static int maxConcurrentSessions() {
            return Integer.getInteger(MAX_CONCURRENT_SESSIONS_PROP_NAME, 10);
        }

        public static long sessionTimeoutNs() {
            return SystemUtil.getDurationInNanos(SESSION_TIMEOUT_PROP_NAME, SESSION_TIMEOUT_DEFAULT_NS);
        }

        public static long leaderHeartbeatTimeoutNs() {
            return SystemUtil.getDurationInNanos(LEADER_HEARTBEAT_TIMEOUT_PROP_NAME, LEADER_HEARTBEAT_TIMEOUT_DEFAULT_NS);
        }

        public static long leaderHeartbeatIntervalNs() {
            return SystemUtil.getDurationInNanos(LEADER_HEARTBEAT_INTERVAL_PROP_NAME, LEADER_HEARTBEAT_INTERVAL_DEFAULT_NS);
        }

        public static long startupCanvassTimeoutNs() {
            return SystemUtil.getDurationInNanos(STARTUP_CANVASS_TIMEOUT_PROP_NAME, STARTUP_CANVASS_TIMEOUT_DEFAULT_NS);
        }

        public static long electionTimeoutNs() {
            return SystemUtil.getDurationInNanos(ELECTION_TIMEOUT_PROP_NAME, ELECTION_TIMEOUT_DEFAULT_NS);
        }

        public static long electionStatusIntervalNs() {
            return SystemUtil.getDurationInNanos(ELECTION_STATUS_INTERVAL_PROP_NAME, ELECTION_STATUS_INTERVAL_DEFAULT_NS);
        }

        public static long dynamicJoinIntervalNs() {
            return SystemUtil.getDurationInNanos(DYNAMIC_JOIN_INTERVAL_PROP_NAME, DYNAMIC_JOIN_INTERVAL_DEFAULT_NS);
        }

        public static long terminationTimeoutNs() {
            return SystemUtil.getDurationInNanos(TERMINATION_TIMEOUT_PROP_NAME, TERMINATION_TIMEOUT_DEFAULT_NS);
        }

        public static long cycleThresholdNs() {
            return SystemUtil.getDurationInNanos(CYCLE_THRESHOLD_PROP_NAME, CYCLE_THRESHOLD_DEFAULT_NS);
        }

        public static int errorBufferLength() {
            return SystemUtil.getSizeAsInt(ERROR_BUFFER_LENGTH_PROP_NAME, 0x100000);
        }

        public static AuthenticatorSupplier authenticatorSupplier() {
            String supplierClassName = System.getProperty(AUTHENTICATOR_SUPPLIER_PROP_NAME, AUTHENTICATOR_SUPPLIER_DEFAULT);
            AuthenticatorSupplier supplier = null;
            try {
                supplier = (AuthenticatorSupplier)Class.forName(supplierClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
            }
            return supplier;
        }

        public static AuthorisationServiceSupplier authorisationServiceSupplier() {
            String supplierClassName = System.getProperty(AUTHORISATION_SERVICE_SUPPLIER_PROP_NAME);
            if (Strings.isEmpty(supplierClassName)) {
                return DEFAULT_AUTHORISATION_SERVICE_SUPPLIER;
            }
            try {
                return (AuthorisationServiceSupplier)Class.forName(supplierClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
                return null;
            }
        }

        public static String consensusChannel() {
            return System.getProperty(CONSENSUS_CHANNEL_PROP_NAME, "aeron:udp?term-length=64k");
        }

        public static int consensusStreamId() {
            return Integer.getInteger(CONSENSUS_STREAM_ID_PROP_NAME, 108);
        }

        public static String replicationChannel() {
            return System.getProperty(REPLICATION_CHANNEL_PROP_NAME);
        }

        public static String followerCatchupChannel() {
            return System.getProperty(FOLLOWER_CATCHUP_CHANNEL_PROP_NAME, FOLLOWER_CATCHUP_CHANNEL_DEFAULT);
        }

        public static String leaderArchiveControlChannel() {
            return System.getProperty(LEADER_ARCHIVE_CONTROL_CHANNEL_PROP_NAME, "aeron:udp?term-length=64k");
        }

        public static long wheelTickResolutionNs() {
            return SystemUtil.getDurationInNanos(WHEEL_TICK_RESOLUTION_PROP_NAME, WHEEL_TICK_RESOLUTION_DEFAULT_NS);
        }

        public static int ticksPerWheel() {
            return Integer.getInteger(TICKS_PER_WHEEL_PROP_NAME, 128);
        }

        public static int fileSyncLevel() {
            return Integer.getInteger(FILE_SYNC_LEVEL_PROP_NAME, 0);
        }

        public static String timerServiceSupplier() {
            return System.getProperty(TIMER_SERVICE_SUPPLIER_PROP_NAME, "io.aeron.cluster.WheelTimerServiceSupplier");
        }

        public static String agentRoleName() {
            return System.getProperty(CLUSTER_CONSENSUS_MODULE_AGENT_ROLE_NAME_PROP_NAME);
        }
    }

    public static enum State {
        INIT(0),
        ACTIVE(1),
        SUSPENDED(2),
        SNAPSHOT(3),
        QUITTING(4),
        TERMINATING(5),
        CLOSED(6);

        static final State[] STATES;
        private final int code;

        private State(int code) {
            if (code != this.ordinal()) {
                throw new IllegalArgumentException(this.name() + " - code must equal ordinal value: code=" + code);
            }
            this.code = code;
        }

        public final int code() {
            return this.code;
        }

        public static State get(AtomicCounter counter) {
            if (counter.isClosed()) {
                return CLOSED;
            }
            return State.get(counter.get());
        }

        public static State get(long code) {
            if (code < 0L || code > (long)(STATES.length - 1)) {
                throw new ClusterException("invalid state counter code: " + code);
            }
            return STATES[(int)code];
        }

        public static State find(CountersReader counters, int clusterId) {
            int counterId = ClusterCounters.find(counters, 200, clusterId);
            if (-1 != counterId) {
                return State.get(counters.getCounterValue(counterId));
            }
            return null;
        }

        static {
            STATES = State.values();
        }
    }
}

