/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ChannelUri;
import io.aeron.Counter;
import io.aeron.ExclusivePublication;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.ConsensusPublisher;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.SnapshotReplication;
import io.aeron.cluster.codecs.SnapshotRecordingsDecoder;
import java.util.ArrayList;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.CountedErrorHandler;

final class DynamicJoin {
    private final AeronArchive localArchive;
    private final ConsensusPublisher consensusPublisher;
    private final ConsensusModule.Context ctx;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final String[] clusterConsensusEndpoints;
    private final String consensusEndpoints;
    private final String consensusEndpoint;
    private final ArrayList<RecordingLog.Snapshot> leaderSnapshots = new ArrayList();
    private final long intervalNs;
    private ExclusivePublication consensusPublication;
    private State state = State.INIT;
    private ClusterMember[] clusterMembers;
    private ClusterMember leaderMember;
    private SnapshotReplication snapshotReplication;
    private Counter recoveryStateCounter;
    private long timeOfLastActivityNs = 0L;
    private long correlationId = -1L;
    private int memberId = -1;
    private int clusterConsensusEndpointsCursor = -1;
    private int snapshotCursor = 0;

    DynamicJoin(String consensusEndpoints, AeronArchive localArchive, ConsensusPublisher consensusPublisher, ConsensusModule.Context ctx, ConsensusModuleAgent consensusModuleAgent) {
        ClusterMember thisMember = ClusterMember.parseEndpoints(-1, ctx.memberEndpoints());
        this.localArchive = localArchive;
        this.consensusPublisher = consensusPublisher;
        this.ctx = ctx;
        this.consensusModuleAgent = consensusModuleAgent;
        this.intervalNs = ctx.dynamicJoinIntervalNs();
        this.consensusEndpoints = ctx.memberEndpoints();
        this.consensusEndpoint = thisMember.consensusEndpoint();
        this.clusterConsensusEndpoints = consensusEndpoints.split(",");
    }

    void close() {
        CountedErrorHandler countedErrorHandler = this.ctx.countedErrorHandler();
        CloseHelper.closeAll((ErrorHandler)countedErrorHandler, this.consensusPublication);
        if (null != this.snapshotReplication) {
            this.snapshotReplication.close(this.localArchive);
        }
    }

    ClusterMember[] clusterMembers() {
        return this.clusterMembers;
    }

    ClusterMember leader() {
        return this.leaderMember;
    }

    int memberId() {
        return this.memberId;
    }

    int doWork(long nowNs) {
        int workCount = 0;
        switch (this.state) {
            case INIT: {
                workCount += this.init(nowNs);
                break;
            }
            case PASSIVE_FOLLOWER: {
                workCount += this.passiveFollower(nowNs);
                break;
            }
            case SNAPSHOT_RETRIEVE: {
                workCount += this.snapshotRetrieve();
                break;
            }
            case SNAPSHOT_LOAD: {
                workCount += this.snapshotLoad(nowNs);
                break;
            }
            case JOIN_CLUSTER: {
                workCount += this.joinCluster(nowNs);
            }
        }
        return workCount;
    }

    void onClusterMembersChange(long correlationId, int leaderMemberId, String activeMembers, String passiveMembers) {
        if (State.INIT == this.state && correlationId == this.correlationId) {
            ClusterMember[] passiveFollowers;
            for (ClusterMember follower : passiveFollowers = ClusterMember.parse(passiveMembers)) {
                if (!this.consensusEndpoint.equals(follower.consensusEndpoint())) continue;
                this.memberId = follower.id();
                this.clusterMembers = ClusterMember.parse(activeMembers);
                this.leaderMember = ClusterMember.findMember(this.clusterMembers, leaderMemberId);
                if (null == this.leaderMember) break;
                if (!this.leaderMember.consensusEndpoint().equals(this.clusterConsensusEndpoints[this.clusterConsensusEndpointsCursor])) {
                    CloseHelper.close(this.ctx.countedErrorHandler(), this.consensusPublication);
                    ChannelUri consensusUri = ChannelUri.parse(this.ctx.consensusChannel());
                    consensusUri.put("endpoint", this.leaderMember.consensusEndpoint());
                    this.consensusPublication = this.ctx.aeron().addExclusivePublication(consensusUri.toString(), this.ctx.consensusStreamId());
                }
                this.timeOfLastActivityNs = 0L;
                this.state(State.PASSIVE_FOLLOWER);
                break;
            }
        }
    }

    void onSnapshotRecordings(long correlationId, SnapshotRecordingsDecoder snapshotRecordingsDecoder) {
        if (State.PASSIVE_FOLLOWER == this.state && correlationId == this.correlationId) {
            SnapshotRecordingsDecoder.SnapshotsDecoder snapshotsDecoder = snapshotRecordingsDecoder.snapshots();
            if (snapshotsDecoder.count() > 0) {
                for (SnapshotRecordingsDecoder.SnapshotsDecoder snapshot : snapshotsDecoder) {
                    if (snapshot.serviceId() > this.ctx.serviceCount()) continue;
                    this.leaderSnapshots.add(new RecordingLog.Snapshot(snapshot.recordingId(), snapshot.leadershipTermId(), snapshot.termBaseLogPosition(), snapshot.logPosition(), snapshot.timestamp(), snapshot.serviceId()));
                }
            }
            this.timeOfLastActivityNs = 0L;
            this.snapshotCursor = 0;
            this.correlationId = -1L;
            if (this.leaderSnapshots.isEmpty()) {
                this.state(State.SNAPSHOT_LOAD);
            } else {
                this.state(State.SNAPSHOT_RETRIEVE);
            }
        }
    }

    void onRecordingSignal(long correlationId, long recordingId, long position, RecordingSignal signal) {
        if (null != this.snapshotReplication) {
            this.snapshotReplication.onSignal(correlationId, recordingId, position, signal);
        }
    }

    private int init(long nowNs) {
        long correlationId;
        if (nowNs > this.timeOfLastActivityNs + this.intervalNs) {
            int cursor;
            if ((cursor = ++this.clusterConsensusEndpointsCursor) >= this.clusterConsensusEndpoints.length) {
                this.clusterConsensusEndpointsCursor = 0;
                cursor = 0;
            }
            CloseHelper.close(this.ctx.countedErrorHandler(), this.consensusPublication);
            ChannelUri uri = ChannelUri.parse(this.ctx.consensusChannel());
            uri.put("endpoint", this.clusterConsensusEndpoints[cursor]);
            this.consensusPublication = this.ctx.aeron().addExclusivePublication(uri.toString(), this.ctx.consensusStreamId());
            this.correlationId = -1L;
            this.timeOfLastActivityNs = nowNs;
            return 1;
        }
        if (-1L == this.correlationId && this.consensusPublication.isConnected() && this.consensusPublisher.addPassiveMember(this.consensusPublication, correlationId = this.ctx.aeron().nextCorrelationId(), this.consensusEndpoints)) {
            this.timeOfLastActivityNs = nowNs;
            this.correlationId = correlationId;
            return 1;
        }
        return 0;
    }

    private int passiveFollower(long nowNs) {
        if (nowNs > this.timeOfLastActivityNs + this.intervalNs) {
            this.correlationId = this.ctx.aeron().nextCorrelationId();
            if (this.consensusPublisher.snapshotRecordingQuery(this.consensusPublication, this.correlationId, this.memberId)) {
                this.timeOfLastActivityNs = nowNs;
                return 1;
            }
        }
        return 0;
    }

    private int snapshotRetrieve() {
        int workCount = 0;
        if (null == this.snapshotReplication) {
            long replicationId = this.localArchive.replicate(this.leaderSnapshots.get((int)this.snapshotCursor).recordingId, -1L, -1L, this.ctx.archiveContext().controlRequestStreamId(), this.leaderArchiveControlRequestChannel(), null, this.ctx.replicationChannel());
            this.snapshotReplication = new SnapshotReplication(replicationId, true);
            ++workCount;
        } else {
            workCount += this.consensusModuleAgent.pollArchiveEvents();
            if (this.snapshotReplication.isDone()) {
                if (this.snapshotReplication.isComplete()) {
                    this.consensusModuleAgent.retrievedSnapshot(this.snapshotReplication.recordingId(), this.leaderSnapshots.get(this.snapshotCursor));
                    this.snapshotReplication = null;
                    if (++this.snapshotCursor >= this.leaderSnapshots.size()) {
                        this.state(State.SNAPSHOT_LOAD);
                        ++workCount;
                    }
                } else {
                    long replicationId = this.localArchive.replicate(this.leaderSnapshots.get((int)this.snapshotCursor).recordingId, this.snapshotReplication.recordingId(), -1L, this.ctx.archiveContext().controlRequestStreamId(), this.leaderArchiveControlRequestChannel(), null, this.ctx.replicationChannel());
                    this.snapshotReplication = new SnapshotReplication(replicationId, false);
                    ++workCount;
                }
            }
        }
        return workCount;
    }

    private String leaderArchiveControlRequestChannel() {
        return ChannelUri.createDestinationUri(this.ctx.leaderArchiveControlChannel(), this.leaderMember.archiveEndpoint());
    }

    private int snapshotLoad(long nowNs) {
        int workCount = 0;
        if (null == this.recoveryStateCounter) {
            this.recoveryStateCounter = this.consensusModuleAgent.loadSnapshotsForDynamicJoin();
            ++workCount;
        } else if (this.consensusModuleAgent.pollForSnapshotLoadAck(this.recoveryStateCounter, nowNs)) {
            CloseHelper.close(this.ctx.countedErrorHandler(), this.recoveryStateCounter);
            this.recoveryStateCounter = null;
            this.state(State.JOIN_CLUSTER);
            ++workCount;
        }
        return workCount;
    }

    private int joinCluster(long nowNs) {
        long leadershipTermId;
        int workCount = 0;
        long l = leadershipTermId = this.leaderSnapshots.isEmpty() ? -1L : this.leaderSnapshots.get((int)0).leadershipTermId;
        if (this.consensusPublisher.joinCluster(this.consensusPublication, leadershipTermId, this.memberId) && this.consensusModuleAgent.dynamicJoinComplete(nowNs)) {
            this.state(State.DONE);
            this.close();
            ++workCount;
        }
        return workCount;
    }

    private void state(State newState) {
        this.logStateChange(this.state, newState, this.memberId);
        this.state = newState;
        this.correlationId = -1L;
    }

    private void logStateChange(State oldState, State newState, int memberId) {
    }

    static enum State {
        INIT,
        PASSIVE_FOLLOWER,
        SNAPSHOT_RETRIEVE,
        SNAPSHOT_LOAD,
        JOIN_CLUSTER,
        DONE;

    }
}

