/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.cluster.client.ClusterException;

final class SnapshotReplication {
    private final long replicationId;
    private long recordingId = -1L;
    private boolean isDone = false;
    private boolean hasSync = false;
    private final boolean isNew;

    SnapshotReplication(long replicationId, boolean isNew) {
        this.replicationId = replicationId;
        this.isNew = isNew;
    }

    void close(AeronArchive archive) {
        if (!this.isDone) {
            try {
                archive.stopReplication(this.replicationId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    long recordingId() {
        return this.recordingId;
    }

    boolean isComplete() {
        return this.hasSync;
    }

    boolean isDone() {
        return this.isDone;
    }

    void onSignal(long correlationId, long recordingId, long position, RecordingSignal signal) {
        if (correlationId == this.replicationId) {
            if (-1L != recordingId) {
                this.recordingId = recordingId;
            }
            if (RecordingSignal.EXTEND == signal) {
                if (this.isNew && 0L != position) {
                    throw new ClusterException("expected new extend signal at 0: position=" + position);
                }
            } else if (RecordingSignal.SYNC == signal) {
                this.hasSync = true;
            } else if (RecordingSignal.REPLICATE_END == signal) {
                this.isDone = true;
            }
        }
    }
}

