/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.EventCode;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.SessionEventDecoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class SessionEventEncoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 8;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SessionEventEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 8;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SessionEventEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 36);
        return this;
    }

    public SessionEventEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(36).templateId(2).schemaId(111).version(8);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int clusterSessionIdId() {
        return 1;
    }

    public static int clusterSessionIdSinceVersion() {
        return 0;
    }

    public static int clusterSessionIdEncodingOffset() {
        return 0;
    }

    public static int clusterSessionIdEncodingLength() {
        return 8;
    }

    public static String clusterSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long clusterSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long clusterSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long clusterSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionEventEncoder clusterSessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionEventEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int leadershipTermIdId() {
        return 3;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 16;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionEventEncoder leadershipTermId(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int leaderMemberIdId() {
        return 4;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 24;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public SessionEventEncoder leaderMemberId(int value) {
        this.buffer.putInt(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int codeId() {
        return 5;
    }

    public static int codeSinceVersion() {
        return 0;
    }

    public static int codeEncodingOffset() {
        return 28;
    }

    public static int codeEncodingLength() {
        return 4;
    }

    public static String codeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public SessionEventEncoder code(EventCode value) {
        this.buffer.putInt(this.offset + 28, value.value(), ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int versionId() {
        return 6;
    }

    public static int versionSinceVersion() {
        return 6;
    }

    public static int versionEncodingOffset() {
        return 32;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int versionNullValue() {
        return 0;
    }

    public static int versionMinValue() {
        return 1;
    }

    public static int versionMaxValue() {
        return 0xFFFFFF;
    }

    public SessionEventEncoder version(int value) {
        this.buffer.putInt(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int detailId() {
        return 7;
    }

    public static String detailCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String detailMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int detailHeaderLength() {
        return 4;
    }

    public SessionEventEncoder putDetail(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SessionEventEncoder putDetail(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SessionEventEncoder detail(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public SessionEventEncoder detail(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SessionEventDecoder decoder = new SessionEventDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 36, 8);
        return decoder.appendTo(builder);
    }
}

