/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs.mark;

import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.cluster.codecs.mark.MessageHeaderEncoder;
import io.aeron.cluster.codecs.mark.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class MarkFileHeaderEncoder {
    public static final int BLOCK_LENGTH = 128;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 110;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final MarkFileHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 128;
    }

    public int sbeTemplateId() {
        return 200;
    }

    public int sbeSchemaId() {
        return 110;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public MarkFileHeaderEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 128);
        return this;
    }

    public MarkFileHeaderEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(128).templateId(200).schemaId(110).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int versionId() {
        return 1;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 0;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder version(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int componentTypeId() {
        return 2;
    }

    public static int componentTypeSinceVersion() {
        return 0;
    }

    public static int componentTypeEncodingOffset() {
        return 4;
    }

    public static int componentTypeEncodingLength() {
        return 4;
    }

    public static String componentTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public MarkFileHeaderEncoder componentType(ClusterComponentType value) {
        this.buffer.putInt(this.offset + 4, value.value(), ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int activityTimestampId() {
        return 3;
    }

    public static int activityTimestampSinceVersion() {
        return 0;
    }

    public static int activityTimestampEncodingOffset() {
        return 8;
    }

    public static int activityTimestampEncodingLength() {
        return 8;
    }

    public static String activityTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long activityTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long activityTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long activityTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public MarkFileHeaderEncoder activityTimestamp(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int startTimestampId() {
        return 4;
    }

    public static int startTimestampSinceVersion() {
        return 0;
    }

    public static int startTimestampEncodingOffset() {
        return 16;
    }

    public static int startTimestampEncodingLength() {
        return 8;
    }

    public static String startTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long startTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public MarkFileHeaderEncoder startTimestamp(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int pidId() {
        return 5;
    }

    public static int pidSinceVersion() {
        return 0;
    }

    public static int pidEncodingOffset() {
        return 24;
    }

    public static int pidEncodingLength() {
        return 8;
    }

    public static String pidMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long pidNullValue() {
        return Long.MIN_VALUE;
    }

    public static long pidMinValue() {
        return -9223372036854775807L;
    }

    public static long pidMaxValue() {
        return Long.MAX_VALUE;
    }

    public MarkFileHeaderEncoder pid(long value) {
        this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int candidateTermIdId() {
        return 6;
    }

    public static int candidateTermIdSinceVersion() {
        return 0;
    }

    public static int candidateTermIdEncodingOffset() {
        return 32;
    }

    public static int candidateTermIdEncodingLength() {
        return 8;
    }

    public static String candidateTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long candidateTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long candidateTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long candidateTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public MarkFileHeaderEncoder candidateTermId(long value) {
        this.buffer.putLong(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int archiveStreamIdId() {
        return 7;
    }

    public static int archiveStreamIdSinceVersion() {
        return 0;
    }

    public static int archiveStreamIdEncodingOffset() {
        return 40;
    }

    public static int archiveStreamIdEncodingLength() {
        return 4;
    }

    public static String archiveStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int archiveStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int archiveStreamIdMinValue() {
        return -2147483647;
    }

    public static int archiveStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder archiveStreamId(int value) {
        this.buffer.putInt(this.offset + 40, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int serviceStreamIdId() {
        return 8;
    }

    public static int serviceStreamIdSinceVersion() {
        return 0;
    }

    public static int serviceStreamIdEncodingOffset() {
        return 44;
    }

    public static int serviceStreamIdEncodingLength() {
        return 4;
    }

    public static String serviceStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int serviceStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int serviceStreamIdMinValue() {
        return -2147483647;
    }

    public static int serviceStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder serviceStreamId(int value) {
        this.buffer.putInt(this.offset + 44, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int consensusModuleStreamIdId() {
        return 9;
    }

    public static int consensusModuleStreamIdSinceVersion() {
        return 0;
    }

    public static int consensusModuleStreamIdEncodingOffset() {
        return 48;
    }

    public static int consensusModuleStreamIdEncodingLength() {
        return 4;
    }

    public static String consensusModuleStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int consensusModuleStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int consensusModuleStreamIdMinValue() {
        return -2147483647;
    }

    public static int consensusModuleStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder consensusModuleStreamId(int value) {
        this.buffer.putInt(this.offset + 48, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int ingressStreamIdId() {
        return 10;
    }

    public static int ingressStreamIdSinceVersion() {
        return 0;
    }

    public static int ingressStreamIdEncodingOffset() {
        return 52;
    }

    public static int ingressStreamIdEncodingLength() {
        return 4;
    }

    public static String ingressStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int ingressStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int ingressStreamIdMinValue() {
        return -2147483647;
    }

    public static int ingressStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder ingressStreamId(int value) {
        this.buffer.putInt(this.offset + 52, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int memberIdId() {
        return 11;
    }

    public static int memberIdSinceVersion() {
        return 0;
    }

    public static int memberIdEncodingOffset() {
        return 56;
    }

    public static int memberIdEncodingLength() {
        return 4;
    }

    public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int memberIdMinValue() {
        return -2147483647;
    }

    public static int memberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder memberId(int value) {
        this.buffer.putInt(this.offset + 56, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int serviceIdId() {
        return 12;
    }

    public static int serviceIdSinceVersion() {
        return 0;
    }

    public static int serviceIdEncodingOffset() {
        return 60;
    }

    public static int serviceIdEncodingLength() {
        return 4;
    }

    public static String serviceIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int serviceIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int serviceIdMinValue() {
        return -2147483647;
    }

    public static int serviceIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder serviceId(int value) {
        this.buffer.putInt(this.offset + 60, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int headerLengthId() {
        return 13;
    }

    public static int headerLengthSinceVersion() {
        return 0;
    }

    public static int headerLengthEncodingOffset() {
        return 64;
    }

    public static int headerLengthEncodingLength() {
        return 4;
    }

    public static String headerLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int headerLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int headerLengthMinValue() {
        return -2147483647;
    }

    public static int headerLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder headerLength(int value) {
        this.buffer.putInt(this.offset + 64, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int errorBufferLengthId() {
        return 14;
    }

    public static int errorBufferLengthSinceVersion() {
        return 0;
    }

    public static int errorBufferLengthEncodingOffset() {
        return 68;
    }

    public static int errorBufferLengthEncodingLength() {
        return 4;
    }

    public static String errorBufferLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int errorBufferLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int errorBufferLengthMinValue() {
        return -2147483647;
    }

    public static int errorBufferLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder errorBufferLength(int value) {
        this.buffer.putInt(this.offset + 68, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int clusterIdId() {
        return 15;
    }

    public static int clusterIdSinceVersion() {
        return 0;
    }

    public static int clusterIdEncodingOffset() {
        return 72;
    }

    public static int clusterIdEncodingLength() {
        return 4;
    }

    public static String clusterIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int clusterIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int clusterIdMinValue() {
        return -2147483647;
    }

    public static int clusterIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder clusterId(int value) {
        this.buffer.putInt(this.offset + 72, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int aeronDirectoryId() {
        return 16;
    }

    public static String aeronDirectoryCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String aeronDirectoryMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int aeronDirectoryHeaderLength() {
        return 4;
    }

    public MarkFileHeaderEncoder putAeronDirectory(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder putAeronDirectory(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder aeronDirectory(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MarkFileHeaderEncoder aeronDirectory(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int controlChannelId() {
        return 17;
    }

    public static String controlChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String controlChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int controlChannelHeaderLength() {
        return 4;
    }

    public MarkFileHeaderEncoder putControlChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder putControlChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder controlChannel(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MarkFileHeaderEncoder controlChannel(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int ingressChannelId() {
        return 18;
    }

    public static String ingressChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String ingressChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int ingressChannelHeaderLength() {
        return 4;
    }

    public MarkFileHeaderEncoder putIngressChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder putIngressChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder ingressChannel(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MarkFileHeaderEncoder ingressChannel(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int serviceNameId() {
        return 19;
    }

    public static String serviceNameCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String serviceNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int serviceNameHeaderLength() {
        return 4;
    }

    public MarkFileHeaderEncoder putServiceName(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder putServiceName(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder serviceName(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MarkFileHeaderEncoder serviceName(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int authenticatorId() {
        return 20;
    }

    public static String authenticatorCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String authenticatorMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int authenticatorHeaderLength() {
        return 4;
    }

    public MarkFileHeaderEncoder putAuthenticator(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder putAuthenticator(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder authenticator(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MarkFileHeaderEncoder authenticator(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        MarkFileHeaderDecoder decoder = new MarkFileHeaderDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 128, 0);
        return decoder.appendTo(builder);
    }
}

