/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.CommonContext;
import io.aeron.driver.CongestionControlSupplier;
import io.aeron.driver.DefaultCongestionControlSupplier;
import io.aeron.driver.DefaultDenyTerminationValidator;
import io.aeron.driver.DefaultMulticastFlowControlSupplier;
import io.aeron.driver.DefaultReceiveChannelEndpointSupplier;
import io.aeron.driver.DefaultSendChannelEndpointSupplier;
import io.aeron.driver.DefaultUnicastFlowControlSupplier;
import io.aeron.driver.FlowControlSupplier;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ReceiveChannelEndpointSupplier;
import io.aeron.driver.SendChannelEndpointSupplier;
import io.aeron.driver.TerminationValidator;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.ConfigurationException;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.LangUtil;
import org.agrona.SystemUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.ControllableIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NoOpIdleStrategy;
import org.agrona.concurrent.SleepingIdleStrategy;
import org.agrona.concurrent.SleepingMillisIdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.agrona.concurrent.status.StatusIndicator;

public final class Configuration {
    public static final String PRINT_CONFIGURATION_ON_START_PROP_NAME = "aeron.print.configuration";
    public static final String DIR_WARN_IF_EXISTS_PROP_NAME = "aeron.dir.warn.if.exists";
    public static final String DIR_DELETE_ON_START_PROP_NAME = "aeron.dir.delete.on.start";
    public static final String DIR_DELETE_ON_SHUTDOWN_PROP_NAME = "aeron.dir.delete.on.shutdown";
    public static final String USE_WINDOWS_HIGH_RES_TIMER_PROP_NAME = "aeron.use.windows.high.res.timer";
    public static final String TETHER_SUBSCRIPTIONS_PROP_NAME = "aeron.tether.subscriptions";
    public static final String RELIABLE_STREAM_PROP_NAME = "aeron.reliable.stream";
    public static final String TERM_BUFFER_SPARSE_FILE_PROP_NAME = "aeron.term.buffer.sparse.file";
    public static final String GROUP_RECEIVER_CONSIDERATION_PROP_NAME = "aeron.receiver.group.consideration";
    public static final String FILE_PAGE_SIZE_PROP_NAME = "aeron.file.page.size";
    public static final int FILE_PAGE_SIZE_DEFAULT = 4096;
    public static final String PERFORM_STORAGE_CHECKS_PROP_NAME = "aeron.perform.storage.checks";
    public static final String TERM_BUFFER_LENGTH_PROP_NAME = "aeron.term.buffer.length";
    public static final int TERM_BUFFER_LENGTH_DEFAULT = 0x1000000;
    public static final String IPC_TERM_BUFFER_LENGTH_PROP_NAME = "aeron.ipc.term.buffer.length";
    public static final int TERM_BUFFER_IPC_LENGTH_DEFAULT = 0x4000000;
    public static final String LOW_FILE_STORE_WARNING_THRESHOLD_PROP_NAME = "aeron.low.file.store.warning.threshold";
    public static final long LOW_FILE_STORE_WARNING_THRESHOLD_DEFAULT = 0xA000000L;
    public static final String CONDUCTOR_BUFFER_LENGTH_PROP_NAME = "aeron.conductor.buffer.length";
    public static final int CONDUCTOR_BUFFER_LENGTH_DEFAULT = 0x100000 + RingBufferDescriptor.TRAILER_LENGTH;
    public static final String TO_CLIENTS_BUFFER_LENGTH_PROP_NAME = "aeron.clients.buffer.length";
    public static final int TO_CLIENTS_BUFFER_LENGTH_DEFAULT = 0x100000 + BroadcastBufferDescriptor.TRAILER_LENGTH;
    public static final String COUNTERS_VALUES_BUFFER_LENGTH_PROP_NAME = "aeron.counters.buffer.length";
    public static final int COUNTERS_VALUES_BUFFER_LENGTH_DEFAULT = 0x100000;
    public static final String ERROR_BUFFER_LENGTH_PROP_NAME = "aeron.error.buffer.length";
    public static final int ERROR_BUFFER_LENGTH_DEFAULT = 0x100000;
    public static final String LOSS_REPORT_BUFFER_LENGTH_PROP_NAME = "aeron.loss.report.buffer.length";
    public static final int LOSS_REPORT_BUFFER_LENGTH_DEFAULT = 0x100000;
    public static final String INITIAL_WINDOW_LENGTH_PROP_NAME = "aeron.rcv.initial.window.length";
    public static final int INITIAL_WINDOW_LENGTH_DEFAULT = 131072;
    public static final String STATUS_MESSAGE_TIMEOUT_PROP_NAME = "aeron.rcv.status.message.timeout";
    public static final long STATUS_MESSAGE_TIMEOUT_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(200L);
    public static final String SEND_TO_STATUS_POLL_RATIO_PROP_NAME = "aeron.send.to.status.poll.ratio";
    public static final int SEND_TO_STATUS_POLL_RATIO_DEFAULT = 6;
    public static final String SOCKET_RCVBUF_LENGTH_PROP_NAME = "aeron.socket.so_rcvbuf";
    public static final int SOCKET_RCVBUF_LENGTH_DEFAULT = 131072;
    public static final String SOCKET_SNDBUF_LENGTH_PROP_NAME = "aeron.socket.so_sndbuf";
    public static final int SOCKET_SNDBUF_LENGTH_DEFAULT = 0;
    public static final String SOCKET_MULTICAST_TTL_PROP_NAME = "aeron.socket.multicast.ttl";
    public static final int SOCKET_MULTICAST_TTL_DEFAULT = 0;
    public static final String PUBLICATION_LINGER_PROP_NAME = "aeron.publication.linger.timeout";
    public static final long PUBLICATION_LINGER_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
    public static final String CLIENT_LIVENESS_TIMEOUT_PROP_NAME = "aeron.client.liveness.timeout";
    public static final long CLIENT_LIVENESS_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final String IMAGE_LIVENESS_TIMEOUT_PROP_NAME = "aeron.image.liveness.timeout";
    public static final long IMAGE_LIVENESS_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final String PUBLICATION_TERM_WINDOW_LENGTH_PROP_NAME = "aeron.publication.term.window.length";
    public static final String IPC_PUBLICATION_TERM_WINDOW_LENGTH_PROP_NAME = "aeron.ipc.publication.term.window.length";
    public static final String PUBLICATION_UNBLOCK_TIMEOUT_PROP_NAME = "aeron.publication.unblock.timeout";
    public static final long PUBLICATION_UNBLOCK_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(15L);
    public static final String PUBLICATION_CONNECTION_TIMEOUT_PROP_NAME = "aeron.publication.connection.timeout";
    public static final long PUBLICATION_CONNECTION_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
    public static final String SPIES_SIMULATE_CONNECTION_PROP_NAME = "aeron.spies.simulate.connection";
    private static final String DEFAULT_IDLE_STRATEGY = "org.agrona.concurrent.BackoffIdleStrategy";
    public static final long IDLE_MAX_SPINS = 10L;
    public static final long IDLE_MAX_YIELDS = 20L;
    public static final long IDLE_MIN_PARK_NS = 1000L;
    public static final long IDLE_MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    public static final String CONTROLLABLE_IDLE_STRATEGY = "org.agrona.concurrent.ControllableIdleStrategy";
    public static final String SENDER_IDLE_STRATEGY_PROP_NAME = "aeron.sender.idle.strategy";
    public static final String RECEIVER_IDLE_STRATEGY_PROP_NAME = "aeron.receiver.idle.strategy";
    public static final String CONDUCTOR_IDLE_STRATEGY_PROP_NAME = "aeron.conductor.idle.strategy";
    public static final String SHARED_NETWORK_IDLE_STRATEGY_PROP_NAME = "aeron.sharednetwork.idle.strategy";
    public static final String SHARED_IDLE_STRATEGY_PROP_NAME = "aeron.shared.idle.strategy";
    public static final String UNICAST_FLOW_CONTROL_STRATEGY_PROP_NAME = "aeron.unicast.flow.control.strategy";
    public static final String UNICAST_FLOW_CONTROL_STRATEGY = System.getProperty("aeron.unicast.flow.control.strategy", "io.aeron.driver.UnicastFlowControl");
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY_PROP_NAME = "aeron.multicast.flow.control.strategy";
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY = System.getProperty("aeron.multicast.flow.control.strategy", "io.aeron.driver.MaxMulticastFlowControl");
    public static final String UNICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_PROP_NAME = "aeron.unicast.FlowControl.supplier";
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_PROP_NAME = "aeron.multicast.FlowControl.supplier";
    public static final int MAX_UDP_PAYLOAD_LENGTH = 65504;
    public static final String MTU_LENGTH_PROP_NAME = "aeron.mtu.length";
    public static final int MTU_LENGTH_DEFAULT = 1408;
    public static final String IPC_MTU_LENGTH_PROP_NAME = "aeron.ipc.mtu.length";
    public static final String THREADING_MODE_PROP_NAME = "aeron.threading.mode";
    public static final String TIMER_INTERVAL_PROP_NAME = "aeron.timer.interval";
    public static final long DEFAULT_TIMER_INTERVAL_NS = TimeUnit.SECONDS.toNanos(1L);
    public static final String COUNTER_FREE_TO_REUSE_TIMEOUT_PROP_NAME = "aeron.counters.free.to.reuse.timeout";
    public static final long DEFAULT_COUNTER_FREE_TO_REUSE_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(1L);
    public static final String SEND_CHANNEL_ENDPOINT_SUPPLIER_PROP_NAME = "aeron.SendChannelEndpoint.supplier";
    public static final String RECEIVE_CHANNEL_ENDPOINT_SUPPLIER_PROP_NAME = "aeron.ReceiveChannelEndpoint.supplier";
    @Deprecated
    public static final String SM_APPLICATION_SPECIFIC_FEEDBACK_PROP_NAME = "aeron.flow.control.sm.applicationSpecificFeedback";
    public static final String CONGESTION_CONTROL_STRATEGY_SUPPLIER_PROP_NAME = "aeron.CongestionControl.supplier";
    public static final String PUBLICATION_RESERVED_SESSION_ID_LOW_PROP_NAME = "aeron.publication.reserved.session.id.low";
    public static final int PUBLICATION_RESERVED_SESSION_ID_LOW_DEFAULT = -1;
    public static final String PUBLICATION_RESERVED_SESSION_ID_HIGH_PROP_NAME = "aeron.publication.reserved.session.id.high";
    public static final int PUBLICATION_RESERVED_SESSION_ID_HIGH_DEFAULT = 1000;
    public static final int COMMAND_DRAIN_LIMIT = 2;
    public static final int CMD_QUEUE_CAPACITY = 128;
    public static final long PENDING_SETUPS_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
    public static final long PUBLICATION_SETUP_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    public static final long PUBLICATION_HEARTBEAT_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    public static final String NAK_MULTICAST_GROUP_SIZE_PROP_NAME = "aeron.nak.multicast.group.size";
    public static final int NAK_MULTICAST_GROUP_SIZE_DEFAULT = 10;
    public static final String NAK_MULTICAST_MAX_BACKOFF_PROP_NAME = "aeron.nak.multicast.max.backoff";
    public static final long NAK_MAX_BACKOFF_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(60L);
    public static final String NAK_UNICAST_DELAY_PROP_NAME = "aeron.nak.unicast.delay";
    public static final long NAK_UNICAST_DELAY_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(60L);
    public static final String RETRANSMIT_UNICAST_DELAY_PROP_NAME = "aeron.retransmit.unicast.delay";
    public static final long RETRANSMIT_UNICAST_DELAY_DEFAULT_NS = TimeUnit.NANOSECONDS.toNanos(0L);
    public static final String RETRANSMIT_UNICAST_LINGER_PROP_NAME = "aeron.retransmit.unicast.linger";
    public static final long RETRANSMIT_UNICAST_LINGER_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(60L);
    public static final String UNTETHERED_WINDOW_LIMIT_TIMEOUT_PROP_NAME = "aeron.untethered.window.limit.timeout";
    public static final long UNTETHERED_WINDOW_LIMIT_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
    public static final String UNTETHERED_RESTING_TIMEOUT_PROP_NAME = "aeron.untethered.resting.timeout";
    public static final long UNTETHERED_RESTING_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final int MAX_RETRANSMITS_DEFAULT = 16;
    public static final String TERMINATION_VALIDATOR_PROP_NAME = "aeron.driver.termination.validator";
    public static final String REJOIN_STREAM_PROP_NAME = "aeron.rejoin.stream";
    public static final String RECEIVER_GROUP_TAG_PROP_NAME = "aeron.receiver.group.tag";
    public static final String FLOW_CONTROL_GROUP_TAG_PROP_NAME = "aeron.flow.control.group.tag";
    public static final String FLOW_CONTROL_GROUP_MIN_SIZE_PROP_NAME = "aeron.flow.control.group.min.size";
    public static final long FLOW_CONTROL_RECEIVER_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
    public static final String FLOW_CONTROL_RECEIVER_TIMEOUT_PROP_NAME = "aeron.flow.control.receiver.timeout";
    private static final String MIN_FLOW_CONTROL_TIMEOUT_OLD_PROP_NAME = "aeron.MinMulticastFlowControl.receiverTimeout";
    public static final String RESOLVER_NAME_PROP_NAME = "aeron.driver.resolver.name";
    public static final String RESOLVER_INTERFACE_PROP_NAME = "aeron.driver.resolver.interface";
    public static final String RESOLVER_BOOTSTRAP_NEIGHBOR_PROP_NAME = "aeron.driver.resolver.bootstrap.neighbor";
    public static final String RE_RESOLUTION_CHECK_INTERVAL_PROP_NAME = "aeron.driver.reresolution.check.interval";
    public static final long RE_RESOLUTION_CHECK_INTERVAL_DEFAULT_NS = TimeUnit.SECONDS.toNanos(1L);
    public static final String CONDUCTOR_CYCLE_THRESHOLD_PROP_NAME = "aeron.driver.conductor.cycle.threshold";
    public static final long CONDUCTOR_CYCLE_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
    public static final String SENDER_CYCLE_THRESHOLD_PROP_NAME = "aeron.driver.sender.cycle.threshold";
    public static final long SENDER_CYCLE_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
    public static final String RECEIVER_CYCLE_THRESHOLD_PROP_NAME = "aeron.driver.receiver.cycle.threshold";
    public static final long RECEIVER_CYCLE_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);

    public static boolean printConfigurationOnStart() {
        return "true".equals(System.getProperty(PRINT_CONFIGURATION_ON_START_PROP_NAME));
    }

    public static boolean useWindowsHighResTimer() {
        return "true".equals(System.getProperty(USE_WINDOWS_HIGH_RES_TIMER_PROP_NAME));
    }

    public static boolean warnIfDirExists() {
        return "true".equals(System.getProperty(DIR_WARN_IF_EXISTS_PROP_NAME));
    }

    public static boolean dirDeleteOnStart() {
        return "true".equals(System.getProperty(DIR_DELETE_ON_START_PROP_NAME));
    }

    public static boolean dirDeleteOnShutdown() {
        return "true".equals(System.getProperty(DIR_DELETE_ON_SHUTDOWN_PROP_NAME));
    }

    public static boolean termBufferSparseFile() {
        return "true".equals(System.getProperty(TERM_BUFFER_SPARSE_FILE_PROP_NAME));
    }

    public static boolean tetherSubscriptions() {
        return "true".equals(System.getProperty(TETHER_SUBSCRIPTIONS_PROP_NAME, "true"));
    }

    public static boolean reliableStream() {
        return "true".equals(System.getProperty(RELIABLE_STREAM_PROP_NAME, "true"));
    }

    public static boolean performStorageChecks() {
        return "true".equals(System.getProperty(PERFORM_STORAGE_CHECKS_PROP_NAME, "true"));
    }

    public static boolean spiesSimulateConnection() {
        return "true".equals(System.getProperty(SPIES_SIMULATE_CONNECTION_PROP_NAME, "false"));
    }

    public static CommonContext.InferableBoolean receiverGroupConsideration() {
        return CommonContext.InferableBoolean.parse(System.getProperty(GROUP_RECEIVER_CONSIDERATION_PROP_NAME));
    }

    public static int conductorBufferLength() {
        return SystemUtil.getSizeAsInt(CONDUCTOR_BUFFER_LENGTH_PROP_NAME, CONDUCTOR_BUFFER_LENGTH_DEFAULT);
    }

    public static int toClientsBufferLength() {
        return SystemUtil.getSizeAsInt(TO_CLIENTS_BUFFER_LENGTH_PROP_NAME, TO_CLIENTS_BUFFER_LENGTH_DEFAULT);
    }

    public static int counterValuesBufferLength() {
        return SystemUtil.getSizeAsInt(COUNTERS_VALUES_BUFFER_LENGTH_PROP_NAME, 0x100000);
    }

    public static int errorBufferLength() {
        return SystemUtil.getSizeAsInt(ERROR_BUFFER_LENGTH_PROP_NAME, 0x100000);
    }

    public static int nakMulticastGroupSize() {
        return Integer.getInteger(NAK_MULTICAST_GROUP_SIZE_PROP_NAME, 10);
    }

    public static long nakMulticastMaxBackoffNs() {
        return SystemUtil.getDurationInNanos(NAK_MULTICAST_MAX_BACKOFF_PROP_NAME, NAK_MAX_BACKOFF_DEFAULT_NS);
    }

    public static long nakUnicastDelayNs() {
        return SystemUtil.getDurationInNanos(NAK_UNICAST_DELAY_PROP_NAME, NAK_UNICAST_DELAY_DEFAULT_NS);
    }

    public static long timerIntervalNs() {
        return SystemUtil.getDurationInNanos(TIMER_INTERVAL_PROP_NAME, DEFAULT_TIMER_INTERVAL_NS);
    }

    public static long lowStorageWarningThreshold() {
        return SystemUtil.getSizeAsLong(LOW_FILE_STORE_WARNING_THRESHOLD_PROP_NAME, 0xA000000L);
    }

    public static int publicationTermWindowLength() {
        return SystemUtil.getSizeAsInt(PUBLICATION_TERM_WINDOW_LENGTH_PROP_NAME, 0);
    }

    public static int ipcPublicationTermWindowLength() {
        return SystemUtil.getSizeAsInt(IPC_PUBLICATION_TERM_WINDOW_LENGTH_PROP_NAME, 0);
    }

    public static long untetheredWindowLimitTimeoutNs() {
        return SystemUtil.getDurationInNanos(UNTETHERED_WINDOW_LIMIT_TIMEOUT_PROP_NAME, UNTETHERED_WINDOW_LIMIT_TIMEOUT_DEFAULT_NS);
    }

    public static long untetheredRestingTimeoutNs() {
        return SystemUtil.getDurationInNanos(UNTETHERED_RESTING_TIMEOUT_PROP_NAME, UNTETHERED_RESTING_TIMEOUT_DEFAULT_NS);
    }

    public static boolean rejoinStream() {
        return "true".equalsIgnoreCase(System.getProperty(REJOIN_STREAM_PROP_NAME, "true"));
    }

    public static Long groupTag() {
        return Long.getLong(RECEIVER_GROUP_TAG_PROP_NAME, null);
    }

    public static long flowControlGroupTag() {
        String propertyValue = System.getProperty("aeron.PreferredMulticastFlowControl.asf", "FFFFFFFFFFFFFFFF");
        long legacyAsfValue = new UnsafeBuffer(BitUtil.fromHex(propertyValue)).getLong(0, ByteOrder.LITTLE_ENDIAN);
        return Long.getLong(FLOW_CONTROL_GROUP_TAG_PROP_NAME, legacyAsfValue);
    }

    public static int flowControlGroupMinSize() {
        return Integer.getInteger(FLOW_CONTROL_GROUP_MIN_SIZE_PROP_NAME, 0);
    }

    public static long flowControlReceiverTimeoutNs() {
        return SystemUtil.getDurationInNanos(FLOW_CONTROL_RECEIVER_TIMEOUT_PROP_NAME, SystemUtil.getDurationInNanos(MIN_FLOW_CONTROL_TIMEOUT_OLD_PROP_NAME, FLOW_CONTROL_RECEIVER_TIMEOUT_DEFAULT_NS));
    }

    public static String resolverName() {
        return System.getProperty(RESOLVER_NAME_PROP_NAME);
    }

    public static String resolverInterface() {
        return System.getProperty(RESOLVER_INTERFACE_PROP_NAME);
    }

    public static String resolverBootstrapNeighbor() {
        return System.getProperty(RESOLVER_BOOTSTRAP_NEIGHBOR_PROP_NAME);
    }

    public static long reResolutionCheckIntervalNs() {
        return SystemUtil.getDurationInNanos(RE_RESOLUTION_CHECK_INTERVAL_PROP_NAME, RE_RESOLUTION_CHECK_INTERVAL_DEFAULT_NS);
    }

    public static int producerWindowLength(int termBufferLength, int defaultTermWindowLength) {
        int termWindowLength = termBufferLength >> 1;
        if (0 != defaultTermWindowLength) {
            termWindowLength = Math.min(defaultTermWindowLength, termWindowLength);
        }
        return termWindowLength;
    }

    public static int receiverWindowLength(int termBufferLength, int initialWindowLength) {
        return Math.min(initialWindowLength, termBufferLength >> 1);
    }

    public static int termBufferLength() {
        return SystemUtil.getSizeAsInt(TERM_BUFFER_LENGTH_PROP_NAME, 0x1000000);
    }

    public static int ipcTermBufferLength() {
        return SystemUtil.getSizeAsInt(IPC_TERM_BUFFER_LENGTH_PROP_NAME, 0x4000000);
    }

    public static int initialWindowLength() {
        return SystemUtil.getSizeAsInt(INITIAL_WINDOW_LENGTH_PROP_NAME, 131072);
    }

    public static int socketSndbufLength() {
        return SystemUtil.getSizeAsInt(SOCKET_SNDBUF_LENGTH_PROP_NAME, 0);
    }

    public static int socketRcvbufLength() {
        return SystemUtil.getSizeAsInt(SOCKET_RCVBUF_LENGTH_PROP_NAME, 131072);
    }

    public static int mtuLength() {
        return SystemUtil.getSizeAsInt(MTU_LENGTH_PROP_NAME, 1408);
    }

    public static int ipcMtuLength() {
        return SystemUtil.getSizeAsInt(IPC_MTU_LENGTH_PROP_NAME, 1408);
    }

    public static int socketMulticastTtl() {
        return Integer.getInteger(SOCKET_MULTICAST_TTL_PROP_NAME, 0);
    }

    public static int filePageSize() {
        return SystemUtil.getSizeAsInt(FILE_PAGE_SIZE_PROP_NAME, 4096);
    }

    public static int publicationReservedSessionIdLow() {
        return Integer.getInteger(PUBLICATION_RESERVED_SESSION_ID_LOW_PROP_NAME, -1);
    }

    public static int publicationReservedSessionIdHigh() {
        return Integer.getInteger(PUBLICATION_RESERVED_SESSION_ID_HIGH_PROP_NAME, 1000);
    }

    public static long statusMessageTimeoutNs() {
        return SystemUtil.getDurationInNanos(STATUS_MESSAGE_TIMEOUT_PROP_NAME, STATUS_MESSAGE_TIMEOUT_DEFAULT_NS);
    }

    public static int sendToStatusMessagePollRatio() {
        return Integer.getInteger(SEND_TO_STATUS_POLL_RATIO_PROP_NAME, 6);
    }

    public static long counterFreeToReuseTimeoutNs() {
        return SystemUtil.getDurationInNanos(COUNTER_FREE_TO_REUSE_TIMEOUT_PROP_NAME, DEFAULT_COUNTER_FREE_TO_REUSE_TIMEOUT_NS);
    }

    public static long clientLivenessTimeoutNs() {
        return SystemUtil.getDurationInNanos(CLIENT_LIVENESS_TIMEOUT_PROP_NAME, CLIENT_LIVENESS_TIMEOUT_DEFAULT_NS);
    }

    public static long imageLivenessTimeoutNs() {
        return SystemUtil.getDurationInNanos(IMAGE_LIVENESS_TIMEOUT_PROP_NAME, IMAGE_LIVENESS_TIMEOUT_DEFAULT_NS);
    }

    public static long publicationUnblockTimeoutNs() {
        return SystemUtil.getDurationInNanos(PUBLICATION_UNBLOCK_TIMEOUT_PROP_NAME, PUBLICATION_UNBLOCK_TIMEOUT_DEFAULT_NS);
    }

    public static long publicationConnectionTimeoutNs() {
        return SystemUtil.getDurationInNanos(PUBLICATION_CONNECTION_TIMEOUT_PROP_NAME, PUBLICATION_CONNECTION_TIMEOUT_DEFAULT_NS);
    }

    public static long publicationLingerTimeoutNs() {
        return SystemUtil.getDurationInNanos(PUBLICATION_LINGER_PROP_NAME, PUBLICATION_LINGER_DEFAULT_NS);
    }

    public static long retransmitUnicastDelayNs() {
        return SystemUtil.getDurationInNanos(RETRANSMIT_UNICAST_DELAY_PROP_NAME, RETRANSMIT_UNICAST_DELAY_DEFAULT_NS);
    }

    public static long retransmitUnicastLingerNs() {
        return SystemUtil.getDurationInNanos(RETRANSMIT_UNICAST_LINGER_PROP_NAME, RETRANSMIT_UNICAST_LINGER_DEFAULT_NS);
    }

    public static int lossReportBufferLength() {
        return SystemUtil.getSizeAsInt(LOSS_REPORT_BUFFER_LENGTH_PROP_NAME, 0x100000);
    }

    public static ThreadingMode threadingMode() {
        String propertyValue = System.getProperty(THREADING_MODE_PROP_NAME);
        if (null == propertyValue) {
            return ThreadingMode.DEDICATED;
        }
        return ThreadingMode.valueOf(propertyValue);
    }

    public static long conductorCycleThresholdNs() {
        return SystemUtil.getDurationInNanos(CONDUCTOR_CYCLE_THRESHOLD_PROP_NAME, CONDUCTOR_CYCLE_THRESHOLD_DEFAULT_NS);
    }

    public static long senderCycleThresholdNs() {
        return SystemUtil.getDurationInNanos(SENDER_CYCLE_THRESHOLD_PROP_NAME, SENDER_CYCLE_THRESHOLD_DEFAULT_NS);
    }

    public static long receiverCycleThresholdNs() {
        return SystemUtil.getDurationInNanos(RECEIVER_CYCLE_THRESHOLD_PROP_NAME, RECEIVER_CYCLE_THRESHOLD_DEFAULT_NS);
    }

    public static IdleStrategy agentIdleStrategy(String strategyName, StatusIndicator controllableStatus) {
        IdleStrategy idleStrategy = null;
        switch (strategyName) {
            case "noop": 
            case "org.agrona.concurrent.NoOpIdleStrategy": {
                idleStrategy = NoOpIdleStrategy.INSTANCE;
                break;
            }
            case "spin": 
            case "org.agrona.concurrent.BusySpinIdleStrategy": {
                idleStrategy = BusySpinIdleStrategy.INSTANCE;
                break;
            }
            case "yield": 
            case "org.agrona.concurrent.YieldingIdleStrategy": {
                idleStrategy = YieldingIdleStrategy.INSTANCE;
                break;
            }
            case "sleep-ns": 
            case "org.agrona.concurrent.SleepingIdleStrategy": {
                idleStrategy = new SleepingIdleStrategy();
                break;
            }
            case "sleep-ms": 
            case "org.agrona.concurrent.SleepingMillisIdleStrategy": {
                idleStrategy = new SleepingMillisIdleStrategy();
                break;
            }
            case "backoff": 
            case "org.agrona.concurrent.BackoffIdleStrategy": {
                idleStrategy = new BackoffIdleStrategy(10L, 20L, 1000L, IDLE_MAX_PARK_NS);
                break;
            }
            case "controllable": 
            case "org.agrona.concurrent.ControllableIdleStrategy": {
                Objects.requireNonNull(controllableStatus);
                controllableStatus.setOrdered(4L);
                idleStrategy = new ControllableIdleStrategy(controllableStatus);
                break;
            }
            default: {
                try {
                    idleStrategy = (IdleStrategy)Class.forName(strategyName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                catch (Exception ex) {
                    LangUtil.rethrowUnchecked(ex);
                }
            }
        }
        return idleStrategy;
    }

    public static IdleStrategy senderIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(System.getProperty(SENDER_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY), controllableStatus);
    }

    public static IdleStrategy receiverIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(System.getProperty(RECEIVER_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY), controllableStatus);
    }

    public static IdleStrategy conductorIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(System.getProperty(CONDUCTOR_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY), controllableStatus);
    }

    public static IdleStrategy sharedNetworkIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(System.getProperty(SHARED_NETWORK_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY), controllableStatus);
    }

    public static IdleStrategy sharedIdleStrategy(StatusIndicator controllableStatus) {
        return Configuration.agentIdleStrategy(System.getProperty(SHARED_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY), controllableStatus);
    }

    @Deprecated
    public static byte[] applicationSpecificFeedback() {
        String propertyValue = System.getProperty(SM_APPLICATION_SPECIFIC_FEEDBACK_PROP_NAME);
        if (null == propertyValue) {
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        return BitUtil.fromHex(propertyValue);
    }

    public static SendChannelEndpointSupplier sendChannelEndpointSupplier() {
        SendChannelEndpointSupplier supplier = null;
        try {
            String className = System.getProperty(SEND_CHANNEL_ENDPOINT_SUPPLIER_PROP_NAME);
            if (null == className) {
                return new DefaultSendChannelEndpointSupplier();
            }
            supplier = (SendChannelEndpointSupplier)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return supplier;
    }

    public static ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier() {
        ReceiveChannelEndpointSupplier supplier = null;
        try {
            String className = System.getProperty(RECEIVE_CHANNEL_ENDPOINT_SUPPLIER_PROP_NAME);
            if (null == className) {
                return new DefaultReceiveChannelEndpointSupplier();
            }
            supplier = (ReceiveChannelEndpointSupplier)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return supplier;
    }

    public static FlowControlSupplier unicastFlowControlSupplier() {
        FlowControlSupplier supplier = null;
        try {
            String className = System.getProperty(UNICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_PROP_NAME);
            if (null == className) {
                return new DefaultUnicastFlowControlSupplier();
            }
            supplier = (FlowControlSupplier)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return supplier;
    }

    public static FlowControlSupplier multicastFlowControlSupplier() {
        FlowControlSupplier supplier = null;
        try {
            String className = System.getProperty(MULTICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_PROP_NAME);
            if (null == className) {
                return new DefaultMulticastFlowControlSupplier();
            }
            supplier = (FlowControlSupplier)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return supplier;
    }

    public static CongestionControlSupplier congestionControlSupplier() {
        CongestionControlSupplier supplier = null;
        try {
            String className = System.getProperty(CONGESTION_CONTROL_STRATEGY_SUPPLIER_PROP_NAME);
            if (null == className) {
                return new DefaultCongestionControlSupplier();
            }
            supplier = (CongestionControlSupplier)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return supplier;
    }

    public static void validateInitialWindowLength(int initialWindowLength, int mtuLength) {
        if (mtuLength > initialWindowLength) {
            throw new ConfigurationException("mtuLength=" + mtuLength + " > initialWindowLength=" + initialWindowLength);
        }
    }

    public static void validateMtuLength(int mtuLength) {
        if (mtuLength <= 32) {
            throw new ConfigurationException("mtuLength=" + mtuLength + " <= HEADER_LENGTH=" + 32);
        }
        if (mtuLength > 65504) {
            throw new ConfigurationException("mtuLength=" + mtuLength + " > MAX_UDP_PAYLOAD_LENGTH=" + 65504);
        }
        if ((mtuLength & 0x1F) != 0) {
            throw new ConfigurationException("mtuLength=" + mtuLength + " is not a multiple of FRAME_ALIGNMENT=" + 32);
        }
    }

    public static TerminationValidator terminationValidator() {
        TerminationValidator validator = null;
        try {
            String className = System.getProperty(TERMINATION_VALIDATOR_PROP_NAME);
            if (null == className) {
                return new DefaultDenyTerminationValidator();
            }
            validator = (TerminationValidator)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return validator;
    }

    public static void validateSocketBufferLengths(MediaDriver.Context ctx) {
        int soRcvBuf;
        int soSndBuf;
        if (ctx.osMaxSocketSndbufLength() < ctx.socketSndbufLength()) {
            System.err.println("WARNING: Could not set desired SO_SNDBUF, adjust OS to allow aeron.socket.so_sndbuf attempted=" + ctx.socketSndbufLength() + ", actual=" + ctx.osMaxSocketSndbufLength());
        }
        if (ctx.osMaxSocketRcvbufLength() < ctx.socketRcvbufLength()) {
            System.err.println("WARNING: Could not set desired SO_RCVBUF, adjust OS to allow aeron.socket.so_sndbuf attempted=" + ctx.socketSndbufLength() + ", actual=" + ctx.osMaxSocketSndbufLength());
        }
        int n = soSndBuf = 0 == ctx.socketSndbufLength() ? ctx.osDefaultSocketSndbufLength() : ctx.socketSndbufLength();
        if (ctx.mtuLength() > soSndBuf) {
            throw new ConfigurationException("mtuLength=" + ctx.mtuLength() + " > SO_SNDBUF=" + soSndBuf + ", increase " + SOCKET_SNDBUF_LENGTH_PROP_NAME + " to match MTU");
        }
        int n2 = soRcvBuf = 0 == ctx.socketRcvbufLength() ? ctx.osDefaultSocketRcvbufLength() : ctx.socketRcvbufLength();
        if (ctx.initialWindowLength() > soRcvBuf) {
            throw new ConfigurationException("initialWindowLength=" + ctx.initialWindowLength() + " > SO_RCVBUF=" + soRcvBuf + ", increase " + SOCKET_RCVBUF_LENGTH_PROP_NAME + " limits to match initialWindowLength");
        }
    }

    public static void validatePageSize(int pageSize) {
        if (pageSize < 4096) {
            throw new ConfigurationException("page size less than min size of 4096: " + pageSize);
        }
        if (pageSize > 0x40000000) {
            throw new ConfigurationException("page size greater than max size of 1073741824: " + pageSize);
        }
        if (!BitUtil.isPowerOfTwo(pageSize)) {
            throw new ConfigurationException("page size not a power of 2: " + pageSize);
        }
    }

    public static void validateSessionIdRange(int low, int high) {
        if (low > high) {
            throw new ConfigurationException("low session id value " + low + " must be <= high value " + high);
        }
        if (Math.abs((long)high - (long)low) > Integer.MAX_VALUE) {
            throw new ConfigurationException("reserved range too large");
        }
    }

    public static int countersMetadataBufferLength(int counterValuesBufferLength) {
        return counterValuesBufferLength * 4;
    }

    public static void validateUnblockTimeout(long publicationUnblockTimeoutNs, long clientLivenessTimeoutNs, long timerIntervalNs) {
        if (publicationUnblockTimeoutNs <= clientLivenessTimeoutNs) {
            throw new ConfigurationException("publicationUnblockTimeoutNs=" + publicationUnblockTimeoutNs + " <= clientLivenessTimeoutNs=" + clientLivenessTimeoutNs);
        }
        if (clientLivenessTimeoutNs <= timerIntervalNs) {
            throw new ConfigurationException("clientLivenessTimeoutNs=" + clientLivenessTimeoutNs + " <= timerIntervalNs=" + timerIntervalNs);
        }
    }

    public static void validateUntetheredTimeouts(long untetheredWindowLimitTimeoutNs, long untetheredRestingTimeoutNs, long timerIntervalNs) {
        if (untetheredWindowLimitTimeoutNs <= timerIntervalNs) {
            throw new ConfigurationException("untetheredWindowLimitTimeoutNs=" + untetheredWindowLimitTimeoutNs + " <= timerIntervalNs=" + timerIntervalNs);
        }
        if (untetheredRestingTimeoutNs <= timerIntervalNs) {
            throw new ConfigurationException("untetheredRestingTimeoutNs=" + untetheredRestingTimeoutNs + " <= timerIntervalNs=" + timerIntervalNs);
        }
    }

    public static String sourceIdentity(InetSocketAddress srcAddress) {
        return srcAddress.getHostString() + ':' + srcAddress.getPort();
    }
}

