/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.Destination;
import io.aeron.driver.media.MultiSndDestination;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.CachedNanoClock;

class DynamicSndMultiDestination
extends MultiSndDestination {
    DynamicSndMultiDestination(CachedNanoClock nanoClock) {
        super(nanoClock);
    }

    @Override
    void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress address) {
        long receiverId = msg.receiverId();
        long nowNs = this.nanoClock.nanoTime();
        boolean isExisting = false;
        for (Destination destination : this.destinations) {
            if (receiverId != destination.receiverId || address.getPort() != destination.port) continue;
            destination.timeOfLastActivityNs = nowNs;
            isExisting = true;
            break;
        }
        if (!isExisting) {
            this.add(new Destination(nowNs, receiverId, address));
        }
    }

    @Override
    int send(DatagramChannel channel, ByteBuffer buffer, SendChannelEndpoint channelEndpoint, int bytesToSend) {
        int bytesSent;
        Destination destination;
        int i;
        int startingIndex;
        long nowNs = this.nanoClock.nanoTime();
        int position = buffer.position();
        int length = this.destinations.length;
        int toBeRemoved = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length; ++i) {
            destination = this.destinations[i];
            if (destination.timeOfLastActivityNs + SendChannelEndpoint.DESTINATION_TIMEOUT - nowNs >= 0L) {
                bytesSent = DynamicSndMultiDestination.send(channel, buffer, channelEndpoint, bytesToSend, position, destination.address);
                if (bytesSent >= bytesToSend) continue;
                this.roundRobinIndex = i;
                return bytesSent;
            }
            ++toBeRemoved;
        }
        for (i = 0; i < startingIndex; ++i) {
            destination = this.destinations[i];
            if (destination.timeOfLastActivityNs + SendChannelEndpoint.DESTINATION_TIMEOUT - nowNs >= 0L) {
                bytesSent = DynamicSndMultiDestination.send(channel, buffer, channelEndpoint, bytesToSend, position, destination.address);
                if (bytesSent >= bytesToSend) continue;
                this.roundRobinIndex = i;
                return bytesSent;
            }
            ++toBeRemoved;
        }
        if (toBeRemoved > 0) {
            this.removeInactiveDestinations(nowNs);
        }
        return bytesToSend;
    }

    private void add(Destination destination) {
        this.destinations = ArrayUtil.add(this.destinations, destination);
        this.numDestinationsCounter.setOrdered(this.destinations.length);
    }

    private void truncateDestinations(int removed) {
        int length = this.destinations.length;
        int newLength = length - removed;
        this.destinations = 0 == newLength ? EMPTY_DESTINATIONS : Arrays.copyOf(this.destinations, newLength);
        this.numDestinationsCounter.setOrdered(this.destinations.length);
    }

    private void removeInactiveDestinations(long nowNs) {
        int lastIndex;
        int removed = 0;
        for (int i = lastIndex = this.destinations.length - 1; i >= 0; --i) {
            Destination destination = this.destinations[i];
            if (destination.timeOfLastActivityNs + SendChannelEndpoint.DESTINATION_TIMEOUT - nowNs >= 0L) continue;
            if (i != lastIndex) {
                this.destinations[i] = this.destinations[lastIndex--];
            }
            ++removed;
        }
        if (removed > 0) {
            this.truncateDestinations(removed);
        }
    }
}

