/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.echo;

import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.samples.echo.api.EchoMonitorMBean;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

public class EchoPair
implements ControlledFragmentHandler,
AutoCloseable {
    public static final int FRAGMENT_LIMIT = 10;
    private final long correlationId;
    private final Subscription subscription;
    private final Publication publication;
    private long notConnectedCount = 0L;
    private long backPressureCount = 0L;
    private long adminActionCount = 0L;
    private long closedCount = 0L;
    private long maxSessionExceededCount = 0L;
    private long fragmentCount = 0L;
    private long byteCount = 0L;

    public EchoPair(long correlationId, Subscription subscription, Publication publication) {
        this.correlationId = correlationId;
        this.subscription = subscription;
        this.publication = publication;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        long offer = this.publication.offer(buffer, offset, length);
        if (-1L == offer) {
            ++this.notConnectedCount;
            return ControlledFragmentHandler.Action.ABORT;
        }
        if (-2L == offer) {
            ++this.backPressureCount;
            return ControlledFragmentHandler.Action.ABORT;
        }
        if (-3L == offer) {
            ++this.adminActionCount;
            return ControlledFragmentHandler.Action.ABORT;
        }
        if (-4L == offer) {
            ++this.closedCount;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (-5L == offer) {
            ++this.maxSessionExceededCount;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        ++this.fragmentCount;
        this.byteCount += (long)length;
        return ControlledFragmentHandler.Action.COMMIT;
    }

    public int poll() {
        return this.subscription.controlledPoll(this, 10);
    }

    public long correlationId() {
        return this.correlationId;
    }

    public EchoMonitorMBean monitor() {
        return new EchoMonitor();
    }

    @Override
    public void close() {
        CloseHelper.quietCloseAll(this.publication, this.subscription);
    }

    private class EchoMonitor
    implements EchoMonitorMBean {
        private EchoMonitor() {
        }

        @Override
        public long getCorrelationId() {
            return EchoPair.this.correlationId;
        }

        @Override
        public long getBackPressureCount() {
            return EchoPair.this.backPressureCount;
        }

        @Override
        public long getFragmentCount() {
            return EchoPair.this.fragmentCount;
        }

        @Override
        public long getByteCount() {
            return EchoPair.this.byteCount;
        }
    }
}

