/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.DirectBufferVector;
import io.aeron.ExclusivePublicationValues;
import io.aeron.LogBuffers;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public final class ExclusivePublication
extends ExclusivePublicationValues {
    byte p064;
    byte p065;
    byte p066;
    byte p067;
    byte p068;
    byte p069;
    byte p070;
    byte p071;
    byte p072;
    byte p073;
    byte p074;
    byte p075;
    byte p076;
    byte p077;
    byte p078;
    byte p079;
    byte p080;
    byte p081;
    byte p082;
    byte p083;
    byte p084;
    byte p085;
    byte p086;
    byte p087;
    byte p088;
    byte p089;
    byte p090;
    byte p091;
    byte p092;
    byte p093;
    byte p094;
    byte p095;
    byte p096;
    byte p097;
    byte p098;
    byte p099;
    byte p100;
    byte p101;
    byte p102;
    byte p103;
    byte p104;
    byte p105;
    byte p106;
    byte p107;
    byte p108;
    byte p109;
    byte p110;
    byte p111;
    byte p112;
    byte p113;
    byte p114;
    byte p115;
    byte p116;
    byte p117;
    byte p118;
    byte p119;
    byte p120;
    byte p121;
    byte p122;
    byte p123;
    byte p124;
    byte p125;
    byte p126;
    byte p127;

    ExclusivePublication(ClientConductor clientConductor, String channel, int streamId, int sessionId, ReadablePosition positionLimit, int channelStatusId, LogBuffers logBuffers, long originalRegistrationId, long registrationId) {
        super(clientConductor, channel, streamId, sessionId, positionLimit, channelStatusId, logBuffers, originalRegistrationId, registrationId);
        int index;
        UnsafeBuffer logMetaDataBuffer = logBuffers.metaDataBuffer();
        int termCount = LogBufferDescriptor.activeTermCount(logMetaDataBuffer);
        this.activePartitionIndex = index = LogBufferDescriptor.indexByTermCount(termCount);
        long rawTail = LogBufferDescriptor.rawTail(logMetaDataBuffer, index);
        this.termId = LogBufferDescriptor.termId(rawTail);
        this.termOffset = LogBufferDescriptor.termOffset(rawTail);
        this.termBeginPosition = LogBufferDescriptor.computeTermBeginPosition(this.termId, this.positionBitsToShift, this.initialTermId);
    }

    @Override
    public long position() {
        if (this.isClosed) {
            return -4L;
        }
        return this.termBeginPosition + (long)this.termOffset;
    }

    @Override
    public long availableWindow() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile() - (this.termBeginPosition + (long)this.termOffset);
    }

    public int termId() {
        return this.termId;
    }

    public int termOffset() {
        return this.termOffset;
    }

    @Override
    public long offer(DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long position = this.termBeginPosition + (long)this.termOffset;
            long limit = this.positionLimit.getVolatile();
            if (position < limit) {
                int result;
                int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer termBuffer = this.termBuffers[this.activePartitionIndex];
                if (length <= this.maxPayloadLength) {
                    this.checkPositiveLength(length);
                    result = this.appendUnfragmentedMessage(tailCounterOffset, termBuffer, buffer, offset, length, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    result = this.appendFragmentedMessage(termBuffer, tailCounterOffset, buffer, offset, length, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            long position = this.termBeginPosition + (long)this.termOffset;
            int length = ExclusivePublication.validateAndComputeLength(lengthOne, lengthTwo);
            if (position < limit) {
                int result;
                int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer termBuffer = this.termBuffers[this.activePartitionIndex];
                if (length <= this.maxPayloadLength) {
                    this.checkPositiveLength(length);
                    result = this.appendUnfragmentedMessage(termBuffer, tailCounterOffset, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    result = this.appendFragmentedMessage(termBuffer, tailCounterOffset, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBufferVector[] vectors, ReservedValueSupplier reservedValueSupplier) {
        int length = DirectBufferVector.validateAndComputeLength(vectors);
        long newPosition = -4L;
        if (!this.isClosed) {
            long position = this.termBeginPosition + (long)this.termOffset;
            long limit = this.positionLimit.getVolatile();
            if (position < limit) {
                int result;
                int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer termBuffer = this.termBuffers[this.activePartitionIndex];
                if (length <= this.maxPayloadLength) {
                    result = this.appendUnfragmentedMessage(termBuffer, tailCounterOffset, vectors, length, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    result = this.appendFragmentedMessage(termBuffer, tailCounterOffset, vectors, length, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long tryClaim(int length, BufferClaim bufferClaim) {
        this.checkPayloadLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long position = this.termBeginPosition + (long)this.termOffset;
            long limit = this.positionLimit.getVolatile();
            if (position < limit) {
                int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer termBuffer = this.termBuffers[this.activePartitionIndex];
                int result = this.claim(termBuffer, tailCounterOffset, length, bufferClaim);
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public long appendPadding(int length) {
        if (length > this.maxFramedLength) {
            throw new IllegalArgumentException("padding exceeds maxFramedLength of " + this.maxFramedLength + ", length=" + length);
        }
        long newPosition = -4L;
        if (!this.isClosed) {
            long position = this.termBeginPosition + (long)this.termOffset;
            long limit = this.positionLimit.getVolatile();
            if (position < limit) {
                this.checkPositiveLength(length);
                int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer termBuffer = this.termBuffers[this.activePartitionIndex];
                int result = this.appendPadding(termBuffer, tailCounterOffset, length);
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public long offerBlock(MutableDirectBuffer buffer, int offset, int length) {
        long limit;
        long position;
        if (this.isClosed) {
            return -4L;
        }
        if (this.termOffset >= this.termBufferLength) {
            this.rotateTerm();
        }
        if ((position = this.termBeginPosition + (long)this.termOffset) < (limit = this.positionLimit.getVolatile())) {
            this.checkBlockLength(length);
            this.checkFirstFrame(buffer, offset);
            int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
            UnsafeBuffer termBuffer = this.termBuffers[this.activePartitionIndex];
            int result = this.appendBlock(termBuffer, tailCounterOffset, buffer, offset, length);
            return this.newPosition(result);
        }
        return this.backPressureStatus(position, length);
    }

    private void checkBlockLength(int length) {
        int remaining = this.termBufferLength - this.termOffset;
        if (length > remaining) {
            throw new IllegalArgumentException("invalid block length " + length + ", remaining space in term is " + remaining);
        }
    }

    private void checkFirstFrame(MutableDirectBuffer buffer, int offset) {
        boolean frameType = true;
        int blockTermOffset = buffer.getInt(offset + 8, ByteOrder.LITTLE_ENDIAN);
        int blockSessionId = buffer.getInt(offset + 12, ByteOrder.LITTLE_ENDIAN);
        int blockStreamId = buffer.getInt(offset + 16, ByteOrder.LITTLE_ENDIAN);
        int blockTermId = buffer.getInt(offset + 20, ByteOrder.LITTLE_ENDIAN);
        int blockFrameType = buffer.getShort(offset + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        if (blockTermOffset != this.termOffset || blockSessionId != this.sessionId || blockStreamId != this.streamId || blockTermId != this.termId || 1 != blockFrameType) {
            throw new IllegalArgumentException("improperly formatted block: termOffset=" + blockTermOffset + " (expected=" + this.termOffset + "), sessionId=" + blockSessionId + " (expected=" + this.sessionId + "), streamId=" + blockStreamId + " (expected=" + this.streamId + "), termId=" + blockTermId + " (expected=" + this.termId + "), frameType=" + blockFrameType + " (expected=" + 1 + ")");
        }
    }

    private long newPosition(int resultingOffset) {
        if (resultingOffset > 0) {
            this.termOffset = resultingOffset;
            return this.termBeginPosition + (long)resultingOffset;
        }
        if (this.termBeginPosition + (long)this.termBufferLength >= this.maxPossiblePosition) {
            return -5L;
        }
        this.rotateTerm();
        return -3L;
    }

    private void rotateTerm() {
        int nextIndex = LogBufferDescriptor.nextPartitionIndex(this.activePartitionIndex);
        int nextTermId = this.termId + 1;
        this.activePartitionIndex = nextIndex;
        this.termOffset = 0;
        this.termId = nextTermId;
        this.termBeginPosition += (long)this.termBufferLength;
        int termCount = nextTermId - this.initialTermId;
        LogBufferDescriptor.initialiseTailWithTermId(this.logMetaDataBuffer, nextIndex, nextTermId);
        LogBufferDescriptor.activeTermCountOrdered(this.logMetaDataBuffer, termCount);
    }

    private int handleEndOfLog(UnsafeBuffer termBuffer, int termLength) {
        if (this.termOffset < termLength) {
            int offset = this.termOffset;
            int paddingLength = termLength - offset;
            this.headerWriter.write(termBuffer, offset, paddingLength, this.termId);
            FrameDescriptor.frameType(termBuffer, offset, 0);
            FrameDescriptor.frameLengthOrdered(termBuffer, offset, paddingLength);
        }
        return -1;
    }

    private int appendUnfragmentedMessage(int tailCounterOffset, UnsafeBuffer termBuffer, DirectBuffer srcBuffer, int srcOffset, int length, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        int termLength = termBuffer.capacity();
        int resultingOffset = this.termOffset + alignedLength;
        this.logMetaDataBuffer.putLongOrdered(tailCounterOffset, LogBufferDescriptor.packTail(this.termId, resultingOffset));
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLog(termBuffer, termLength);
        } else {
            this.headerWriter.write(termBuffer, this.termOffset, frameLength, this.termId);
            termBuffer.putBytes(this.termOffset + 32, srcBuffer, srcOffset, length);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get(termBuffer, this.termOffset, frameLength);
                termBuffer.putLong(this.termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, this.termOffset, frameLength);
        }
        return resultingOffset;
    }

    private int appendFragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBuffer srcBuffer, int srcOffset, int length, ReservedValueSupplier reservedValueSupplier) {
        int framedLength = ExclusivePublication.computeFramedLength(length, this.maxPayloadLength);
        int termLength = termBuffer.capacity();
        int resultingOffset = this.termOffset + framedLength;
        this.logMetaDataBuffer.putLongOrdered(tailCounterOffset, LogBufferDescriptor.packTail(this.termId, resultingOffset));
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLog(termBuffer, termLength);
        } else {
            int bytesToWrite;
            int frameOffset = this.termOffset;
            byte flags = -128;
            int remaining = length;
            do {
                bytesToWrite = Math.min(remaining, this.maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align(frameLength, 32);
                this.headerWriter.write(termBuffer, frameOffset, frameLength, this.termId);
                termBuffer.putBytes(frameOffset + 32, srcBuffer, srcOffset + (length - remaining), bytesToWrite);
                if (remaining <= this.maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                    termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
                flags = 0;
                frameOffset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return resultingOffset;
    }

    private int appendUnfragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = lengthOne + lengthTwo + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        int termLength = termBuffer.capacity();
        int resultingOffset = this.termOffset + alignedLength;
        this.logMetaDataBuffer.putLongOrdered(tailCounterOffset, LogBufferDescriptor.packTail(this.termId, resultingOffset));
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLog(termBuffer, termLength);
        } else {
            this.headerWriter.write(termBuffer, this.termOffset, frameLength, this.termId);
            termBuffer.putBytes(this.termOffset + 32, bufferOne, offsetOne, lengthOne);
            termBuffer.putBytes(this.termOffset + 32 + lengthOne, bufferTwo, offsetTwo, lengthTwo);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get(termBuffer, this.termOffset, frameLength);
                termBuffer.putLong(this.termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, this.termOffset, frameLength);
        }
        return resultingOffset;
    }

    private int appendFragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, int maxPayloadLength, ReservedValueSupplier reservedValueSupplier) {
        int length = lengthOne + lengthTwo;
        int framedLength = ExclusivePublication.computeFramedLength(length, maxPayloadLength);
        int termLength = termBuffer.capacity();
        int resultingOffset = this.termOffset + framedLength;
        this.logMetaDataBuffer.putLongOrdered(tailCounterOffset, LogBufferDescriptor.packTail(this.termId, resultingOffset));
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLog(termBuffer, termLength);
        } else {
            int bytesToWrite;
            int frameOffset = this.termOffset;
            byte flags = -128;
            int remaining = length;
            int positionOne = 0;
            int positionTwo = 0;
            do {
                bytesToWrite = Math.min(remaining, maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align(frameLength, 32);
                this.headerWriter.write(termBuffer, frameOffset, frameLength, this.termId);
                int bytesWritten = 0;
                int payloadOffset = frameOffset + 32;
                do {
                    int numBytes;
                    int remainingOne;
                    if ((remainingOne = lengthOne - positionOne) > 0) {
                        numBytes = Math.min(bytesToWrite - bytesWritten, remainingOne);
                        termBuffer.putBytes(payloadOffset, bufferOne, offsetOne + positionOne, numBytes);
                        bytesWritten += numBytes;
                        payloadOffset += numBytes;
                        positionOne += numBytes;
                        continue;
                    }
                    numBytes = Math.min(bytesToWrite - bytesWritten, lengthTwo - positionTwo);
                    termBuffer.putBytes(payloadOffset, bufferTwo, offsetTwo + positionTwo, numBytes);
                    bytesWritten += numBytes;
                    payloadOffset += numBytes;
                    positionTwo += numBytes;
                } while (bytesWritten < bytesToWrite);
                if (remaining <= maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                    termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
                flags = 0;
                frameOffset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return resultingOffset;
    }

    private int appendUnfragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBufferVector[] vectors, int length, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        int termLength = termBuffer.capacity();
        int resultingOffset = this.termOffset + alignedLength;
        this.logMetaDataBuffer.putLongOrdered(tailCounterOffset, LogBufferDescriptor.packTail(this.termId, resultingOffset));
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLog(termBuffer, termLength);
        } else {
            this.headerWriter.write(termBuffer, this.termOffset, frameLength, this.termId);
            int offset = this.termOffset + 32;
            for (DirectBufferVector vector : vectors) {
                termBuffer.putBytes(offset, vector.buffer(), vector.offset(), vector.length());
                offset += vector.length();
            }
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get(termBuffer, this.termOffset, frameLength);
                termBuffer.putLong(this.termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, this.termOffset, frameLength);
        }
        return resultingOffset;
    }

    private int appendFragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBufferVector[] vectors, int length, ReservedValueSupplier reservedValueSupplier) {
        int framedLength = ExclusivePublication.computeFramedLength(length, this.maxPayloadLength);
        int termLength = termBuffer.capacity();
        int resultingOffset = this.termOffset + framedLength;
        this.logMetaDataBuffer.putLongOrdered(tailCounterOffset, LogBufferDescriptor.packTail(this.termId, resultingOffset));
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLog(termBuffer, termLength);
        } else {
            int bytesToWrite;
            int frameOffset = this.termOffset;
            byte flags = -128;
            int remaining = length;
            int vectorIndex = 0;
            int vectorOffset = 0;
            do {
                bytesToWrite = Math.min(remaining, this.maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align(frameLength, 32);
                this.headerWriter.write(termBuffer, frameOffset, frameLength, this.termId);
                int bytesWritten = 0;
                int payloadOffset = frameOffset + 32;
                do {
                    DirectBufferVector vector = vectors[vectorIndex];
                    int vectorRemaining = vector.length() - vectorOffset;
                    int numBytes = Math.min(bytesToWrite - bytesWritten, vectorRemaining);
                    termBuffer.putBytes(payloadOffset, vector.buffer(), vector.offset() + vectorOffset, numBytes);
                    bytesWritten += numBytes;
                    payloadOffset += numBytes;
                    vectorOffset += numBytes;
                    if (vectorRemaining > numBytes) continue;
                    ++vectorIndex;
                    vectorOffset = 0;
                } while (bytesWritten < bytesToWrite);
                if (remaining <= this.maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                    termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
                flags = 0;
                frameOffset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return resultingOffset;
    }

    int claim(UnsafeBuffer termBuffer, int tailCounterOffset, int length, BufferClaim bufferClaim) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        int termLength = termBuffer.capacity();
        int resultingOffset = this.termOffset + alignedLength;
        this.logMetaDataBuffer.putLongOrdered(tailCounterOffset, LogBufferDescriptor.packTail(this.termId, resultingOffset));
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLog(termBuffer, termLength);
        } else {
            this.headerWriter.write(termBuffer, this.termOffset, frameLength, this.termId);
            bufferClaim.wrap(termBuffer, this.termOffset, frameLength);
        }
        return resultingOffset;
    }

    private int appendPadding(UnsafeBuffer termBuffer, int tailCounterOffset, int length) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        int termLength = termBuffer.capacity();
        int resultingOffset = this.termOffset + alignedLength;
        this.logMetaDataBuffer.putLongOrdered(tailCounterOffset, LogBufferDescriptor.packTail(this.termId, resultingOffset));
        if (resultingOffset > termLength) {
            resultingOffset = this.handleEndOfLog(termBuffer, termLength);
        } else {
            this.headerWriter.write(termBuffer, this.termOffset, frameLength, this.termId);
            FrameDescriptor.frameType(termBuffer, this.termOffset, 0);
            FrameDescriptor.frameLengthOrdered(termBuffer, this.termOffset, frameLength);
        }
        return resultingOffset;
    }

    private int appendBlock(UnsafeBuffer termBuffer, int tailCounterOffset, MutableDirectBuffer buffer, int offset, int length) {
        int resultingOffset = this.termOffset + length;
        int lengthOfFirstFrame = buffer.getInt(offset, ByteOrder.LITTLE_ENDIAN);
        this.logMetaDataBuffer.putLongOrdered(tailCounterOffset, LogBufferDescriptor.packTail(this.termId, resultingOffset));
        buffer.putInt(offset, 0, ByteOrder.LITTLE_ENDIAN);
        termBuffer.putBytes(this.termOffset, buffer, offset, length);
        FrameDescriptor.frameLengthOrdered(termBuffer, this.termOffset, lengthOfFirstFrame);
        return resultingOffset;
    }
}

