/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.CatalogHeaderDecoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public final class CatalogHeaderEncoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 20;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 7;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final CatalogHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 20;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 7;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public CatalogHeaderEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 32);
        return this;
    }

    public CatalogHeaderEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(32).templateId(20).schemaId(101).version(7);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int versionId() {
        return 1;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 0;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public CatalogHeaderEncoder version(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int lengthId() {
        return 2;
    }

    public static int lengthSinceVersion() {
        return 0;
    }

    public static int lengthEncodingOffset() {
        return 4;
    }

    public static int lengthEncodingLength() {
        return 4;
    }

    public static String lengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lengthMinValue() {
        return -2147483647;
    }

    public static int lengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public CatalogHeaderEncoder length(int value) {
        this.buffer.putInt(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int nextRecordingIdId() {
        return 3;
    }

    public static int nextRecordingIdSinceVersion() {
        return 0;
    }

    public static int nextRecordingIdEncodingOffset() {
        return 8;
    }

    public static int nextRecordingIdEncodingLength() {
        return 8;
    }

    public static String nextRecordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long nextRecordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long nextRecordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long nextRecordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public CatalogHeaderEncoder nextRecordingId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int alignmentId() {
        return 4;
    }

    public static int alignmentSinceVersion() {
        return 0;
    }

    public static int alignmentEncodingOffset() {
        return 16;
    }

    public static int alignmentEncodingLength() {
        return 4;
    }

    public static String alignmentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int alignmentNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int alignmentMinValue() {
        return -2147483647;
    }

    public static int alignmentMaxValue() {
        return Integer.MAX_VALUE;
    }

    public CatalogHeaderEncoder alignment(int value) {
        this.buffer.putInt(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int reservedId() {
        return 5;
    }

    public static int reservedSinceVersion() {
        return 0;
    }

    public static int reservedEncodingOffset() {
        return 31;
    }

    public static int reservedEncodingLength() {
        return 1;
    }

    public static String reservedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte reservedNullValue() {
        return -128;
    }

    public static byte reservedMinValue() {
        return -127;
    }

    public static byte reservedMaxValue() {
        return 127;
    }

    public CatalogHeaderEncoder reserved(byte value) {
        this.buffer.putByte(this.offset + 31, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        CatalogHeaderDecoder decoder = new CatalogHeaderDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 32, 7);
        return decoder.appendTo(builder);
    }
}

