/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class RecordingDescriptorDecoder {
    public static final int BLOCK_LENGTH = 80;
    public static final int TEMPLATE_ID = 22;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 7;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordingDescriptorDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 80;
    }

    public int sbeTemplateId() {
        return 22;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 7;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RecordingDescriptorDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public RecordingDescriptorDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (22 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public RecordingDescriptorDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long controlSessionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int recordingIdId() {
        return 3;
    }

    public static int recordingIdSinceVersion() {
        return 0;
    }

    public static int recordingIdEncodingOffset() {
        return 16;
    }

    public static int recordingIdEncodingLength() {
        return 8;
    }

    public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long recordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long recordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long recordingId() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int startTimestampId() {
        return 4;
    }

    public static int startTimestampSinceVersion() {
        return 0;
    }

    public static int startTimestampEncodingOffset() {
        return 24;
    }

    public static int startTimestampEncodingLength() {
        return 8;
    }

    public static String startTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long startTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long startTimestamp() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int stopTimestampId() {
        return 5;
    }

    public static int stopTimestampSinceVersion() {
        return 0;
    }

    public static int stopTimestampEncodingOffset() {
        return 32;
    }

    public static int stopTimestampEncodingLength() {
        return 8;
    }

    public static String stopTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long stopTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long stopTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long stopTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long stopTimestamp() {
        return this.buffer.getLong(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static int startPositionId() {
        return 6;
    }

    public static int startPositionSinceVersion() {
        return 0;
    }

    public static int startPositionEncodingOffset() {
        return 40;
    }

    public static int startPositionEncodingLength() {
        return 8;
    }

    public static String startPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long startPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long startPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long startPosition() {
        return this.buffer.getLong(this.offset + 40, ByteOrder.LITTLE_ENDIAN);
    }

    public static int stopPositionId() {
        return 7;
    }

    public static int stopPositionSinceVersion() {
        return 0;
    }

    public static int stopPositionEncodingOffset() {
        return 48;
    }

    public static int stopPositionEncodingLength() {
        return 8;
    }

    public static String stopPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long stopPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long stopPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long stopPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long stopPosition() {
        return this.buffer.getLong(this.offset + 48, ByteOrder.LITTLE_ENDIAN);
    }

    public static int initialTermIdId() {
        return 8;
    }

    public static int initialTermIdSinceVersion() {
        return 0;
    }

    public static int initialTermIdEncodingOffset() {
        return 56;
    }

    public static int initialTermIdEncodingLength() {
        return 4;
    }

    public static String initialTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int initialTermIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int initialTermIdMinValue() {
        return -2147483647;
    }

    public static int initialTermIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int initialTermId() {
        return this.buffer.getInt(this.offset + 56, ByteOrder.LITTLE_ENDIAN);
    }

    public static int segmentFileLengthId() {
        return 9;
    }

    public static int segmentFileLengthSinceVersion() {
        return 0;
    }

    public static int segmentFileLengthEncodingOffset() {
        return 60;
    }

    public static int segmentFileLengthEncodingLength() {
        return 4;
    }

    public static String segmentFileLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int segmentFileLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int segmentFileLengthMinValue() {
        return -2147483647;
    }

    public static int segmentFileLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int segmentFileLength() {
        return this.buffer.getInt(this.offset + 60, ByteOrder.LITTLE_ENDIAN);
    }

    public static int termBufferLengthId() {
        return 10;
    }

    public static int termBufferLengthSinceVersion() {
        return 0;
    }

    public static int termBufferLengthEncodingOffset() {
        return 64;
    }

    public static int termBufferLengthEncodingLength() {
        return 4;
    }

    public static String termBufferLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int termBufferLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int termBufferLengthMinValue() {
        return -2147483647;
    }

    public static int termBufferLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int termBufferLength() {
        return this.buffer.getInt(this.offset + 64, ByteOrder.LITTLE_ENDIAN);
    }

    public static int mtuLengthId() {
        return 11;
    }

    public static int mtuLengthSinceVersion() {
        return 0;
    }

    public static int mtuLengthEncodingOffset() {
        return 68;
    }

    public static int mtuLengthEncodingLength() {
        return 4;
    }

    public static String mtuLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int mtuLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int mtuLengthMinValue() {
        return -2147483647;
    }

    public static int mtuLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int mtuLength() {
        return this.buffer.getInt(this.offset + 68, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionIdId() {
        return 12;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 72;
    }

    public static int sessionIdEncodingLength() {
        return 4;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sessionIdMinValue() {
        return -2147483647;
    }

    public static int sessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int sessionId() {
        return this.buffer.getInt(this.offset + 72, ByteOrder.LITTLE_ENDIAN);
    }

    public static int streamIdId() {
        return 13;
    }

    public static int streamIdSinceVersion() {
        return 0;
    }

    public static int streamIdEncodingOffset() {
        return 76;
    }

    public static int streamIdEncodingLength() {
        return 4;
    }

    public static String streamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int streamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int streamIdMinValue() {
        return -2147483647;
    }

    public static int streamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 76, ByteOrder.LITTLE_ENDIAN);
    }

    public static int strippedChannelId() {
        return 14;
    }

    public static int strippedChannelSinceVersion() {
        return 0;
    }

    public static String strippedChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String strippedChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int strippedChannelHeaderLength() {
        return 4;
    }

    public int strippedChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipStrippedChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getStrippedChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getStrippedChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapStrippedChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String strippedChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getStrippedChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int originalChannelId() {
        return 15;
    }

    public static int originalChannelSinceVersion() {
        return 0;
    }

    public static String originalChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String originalChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int originalChannelHeaderLength() {
        return 4;
    }

    public int originalChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipOriginalChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getOriginalChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getOriginalChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapOriginalChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String originalChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getOriginalChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int sourceIdentityId() {
        return 16;
    }

    public static int sourceIdentitySinceVersion() {
        return 0;
    }

    public static String sourceIdentityCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String sourceIdentityMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sourceIdentityHeaderLength() {
        return 4;
    }

    public int sourceIdentityLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipSourceIdentity() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getSourceIdentity(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSourceIdentity(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapSourceIdentity(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String sourceIdentity() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getSourceIdentity(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RecordingDescriptorDecoder decoder = new RecordingDescriptorDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[RecordingDescriptor](sbeTemplateId=");
        builder.append(22);
        builder.append("|sbeSchemaId=");
        builder.append(101);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 7) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(7);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 80) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(80);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("recordingId=");
        builder.append(this.recordingId());
        builder.append('|');
        builder.append("startTimestamp=");
        builder.append(this.startTimestamp());
        builder.append('|');
        builder.append("stopTimestamp=");
        builder.append(this.stopTimestamp());
        builder.append('|');
        builder.append("startPosition=");
        builder.append(this.startPosition());
        builder.append('|');
        builder.append("stopPosition=");
        builder.append(this.stopPosition());
        builder.append('|');
        builder.append("initialTermId=");
        builder.append(this.initialTermId());
        builder.append('|');
        builder.append("segmentFileLength=");
        builder.append(this.segmentFileLength());
        builder.append('|');
        builder.append("termBufferLength=");
        builder.append(this.termBufferLength());
        builder.append('|');
        builder.append("mtuLength=");
        builder.append(this.mtuLength());
        builder.append('|');
        builder.append("sessionId=");
        builder.append(this.sessionId());
        builder.append('|');
        builder.append("streamId=");
        builder.append(this.streamId());
        builder.append('|');
        builder.append("strippedChannel=");
        builder.append('\'');
        this.getStrippedChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("originalChannel=");
        builder.append('\'');
        this.getOriginalChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("sourceIdentity=");
        builder.append('\'');
        this.getSourceIdentity(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public RecordingDescriptorDecoder sbeSkip() {
        this.sbeRewind();
        this.skipStrippedChannel();
        this.skipOriginalChannel();
        this.skipSourceIdentity();
        return this;
    }
}

