/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ExclusivePublication;
import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.PendingServiceMessageTracker;
import io.aeron.cluster.TimerService;
import io.aeron.cluster.codecs.ClusterSessionEncoder;
import io.aeron.cluster.codecs.ConsensusModuleEncoder;
import io.aeron.cluster.codecs.PendingMessageTrackerEncoder;
import io.aeron.cluster.codecs.TimerEncoder;
import io.aeron.cluster.service.SnapshotTaker;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.ExpandableRingBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.IdleStrategy;

class ConsensusModuleSnapshotTaker
extends SnapshotTaker
implements ExpandableRingBuffer.MessageConsumer,
TimerService.TimerSnapshotTaker {
    private static final int ENCODED_TIMER_LENGTH = 24;
    private final ExpandableArrayBuffer offerBuffer = new ExpandableArrayBuffer(1024);
    private final ClusterSessionEncoder clusterSessionEncoder = new ClusterSessionEncoder();
    private final TimerEncoder timerEncoder = new TimerEncoder();
    private final ConsensusModuleEncoder consensusModuleEncoder = new ConsensusModuleEncoder();
    private final PendingMessageTrackerEncoder pendingMessageTrackerEncoder = new PendingMessageTrackerEncoder();

    ConsensusModuleSnapshotTaker(ExclusivePublication publication, IdleStrategy idleStrategy, AgentInvoker aeronClientInvoker) {
        super(publication, idleStrategy, aeronClientInvoker);
    }

    @Override
    public boolean onMessage(MutableDirectBuffer buffer, int offset, int length, int headOffset) {
        this.offer(buffer, offset, length);
        return true;
    }

    void snapshotConsensusModuleState(long nextSessionId, long nextServiceSessionId, long logServiceSessionId, int pendingMessageCapacity) {
        int length = 36;
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(36, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.consensusModuleEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).nextSessionId(nextSessionId).nextServiceSessionId(nextServiceSessionId).logServiceSessionId(logServiceSessionId).pendingMessageCapacity(pendingMessageCapacity);
        this.bufferClaim.commit();
    }

    void snapshotSession(ClusterSession session) {
        block3: {
            String responseChannel = session.responseChannel();
            int length = 48 + ClusterSessionEncoder.responseChannelHeaderLength() + responseChannel.length();
            if (length <= this.publication.maxPayloadLength()) {
                this.idleStrategy.reset();
                while (true) {
                    long result;
                    if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) {
                        this.encodeSession(session, responseChannel, this.bufferClaim.buffer(), this.bufferClaim.offset());
                        this.bufferClaim.commit();
                        break block3;
                    }
                    this.checkResultAndIdle(result);
                }
            }
            boolean offset = false;
            this.encodeSession(session, responseChannel, this.offerBuffer, 0);
            this.offer(this.offerBuffer, 0, length);
        }
    }

    @Override
    public void snapshotTimer(long correlationId, long deadline) {
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(24, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.timerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).deadline(deadline);
        this.bufferClaim.commit();
    }

    void snapshot(PendingServiceMessageTracker tracker) {
        int length = 32;
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(32, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.pendingMessageTrackerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).nextServiceSessionId(tracker.nextServiceSessionId()).logServiceSessionId(tracker.logServiceSessionId()).pendingMessageCapacity(tracker.pendingMessages().size()).serviceId(tracker.serviceId());
        this.bufferClaim.commit();
        tracker.pendingMessages().forEach(this, Integer.MAX_VALUE);
    }

    private void encodeSession(ClusterSession session, String responseChannel, MutableDirectBuffer buffer, int offset) {
        this.clusterSessionEncoder.wrapAndApplyHeader(buffer, offset, this.messageHeaderEncoder).clusterSessionId(session.id()).correlationId(session.correlationId()).openedLogPosition(session.openedLogPosition()).timeOfLastActivity(session.timeOfLastActivityNs()).closeReason(session.closeReason()).responseStreamId(session.responseStreamId()).responseChannel(responseChannel);
    }
}

