/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.node.CandidateTermDecoder;
import io.aeron.cluster.codecs.node.CandidateTermEncoder;
import io.aeron.cluster.codecs.node.ClusterMembersDecoder;
import io.aeron.cluster.codecs.node.ClusterMembersEncoder;
import io.aeron.cluster.codecs.node.MessageHeaderDecoder;
import io.aeron.cluster.codecs.node.MessageHeaderEncoder;
import io.aeron.cluster.codecs.node.NodeStateFooterEncoder;
import io.aeron.cluster.codecs.node.NodeStateHeaderDecoder;
import io.aeron.cluster.codecs.node.NodeStateHeaderEncoder;
import io.aeron.cluster.service.ClusterMarkFile;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.IoUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.concurrent.UnsafeBuffer;

public class NodeStateFile
implements AutoCloseable {
    public static final String FILENAME = "node-state.dat";
    private static final int MINIMUM_FILE_LENGTH = 0x100000;
    private final CandidateTerm candidateTerm = new CandidateTerm();
    private final ClusterMembers clusterMembers = new ClusterMembers();
    private final MappedByteBuffer mappedFile;
    private final int fileSyncLevel;
    private final NodeStateHeaderDecoder nodeStateHeaderDecoder = new NodeStateHeaderDecoder();
    private final ClusterMembersDecoder clusterMembersDecoder = new ClusterMembersDecoder();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final CandidateTermDecoder candidateTermDecoder = new CandidateTermDecoder();
    private final UnsafeBuffer buffer;
    private int candidateTermIdOffset;

    public NodeStateFile(File clusterDir, boolean createNew, int fileSyncLevel) throws IOException {
        UnsafeBuffer buffer;
        this.fileSyncLevel = fileSyncLevel;
        MappedByteBuffer mappedFile = null;
        try {
            File nodeStateFile = new File(clusterDir, FILENAME);
            if (!nodeStateFile.exists()) {
                if (!createNew) {
                    throw new IOException("NodeStateFile does not exist and createNew=false");
                }
                mappedFile = IoUtil.mapNewFile(nodeStateFile, 0x100000L);
                buffer = new UnsafeBuffer(mappedFile, 0, mappedFile.capacity());
                buffer.verifyAlignment();
                NodeStateFile.initialiseDecodersOnCreation(buffer, this.nodeStateHeaderDecoder, this.messageHeaderDecoder, this.candidateTermDecoder, this.clusterMembersDecoder);
                this.candidateTermIdOffset = this.calculateAndVerifyCandidateTermIdOffset();
                buffer.putLongVolatile(this.candidateTermIdOffset, -1L);
            } else {
                mappedFile = IoUtil.mapExistingFile(nodeStateFile, "NodeState");
                buffer = new UnsafeBuffer(mappedFile, 0, mappedFile.capacity());
                this.loadDecodersAndOffsets(buffer);
            }
            this.syncFile(mappedFile);
        }
        catch (IOException | RuntimeException ex) {
            if (null != mappedFile) {
                IoUtil.unmap(mappedFile);
            }
            throw ex;
        }
        this.mappedFile = mappedFile;
        this.buffer = buffer;
    }

    private int calculateAndVerifyCandidateTermIdOffset() {
        int candidateTermIdOffset = this.candidateTermDecoder.offset() + CandidateTermDecoder.candidateTermIdEncodingOffset();
        NodeStateFile.verifyAlignment(candidateTermIdOffset);
        return candidateTermIdOffset;
    }

    private static void verifyAlignment(int offset) {
        if (0 != (offset & 7)) {
            throw new IllegalStateException("offset=" + offset + " is not correctly aligned, it is not divisible by " + 8);
        }
    }

    private static void loadInitialState(MutableDirectBuffer buffer, NodeStateHeaderDecoder nodeStateHeaderDecoder, CandidateTermDecoder candidateTermDecoder, ClusterMembersDecoder clusterMembersDecoder, MessageHeaderDecoder messageHeaderDecoder) {
        nodeStateHeaderDecoder.wrap(buffer, 0, 8, 10);
        int version = nodeStateHeaderDecoder.version();
        if (0 != SemanticVersion.major(version)) {
            throw new ClusterException("mark file major version " + SemanticVersion.major(version) + " does not match software: " + 0);
        }
        int footerOffset = NodeStateFile.scanForMessageTypeOffset(nodeStateHeaderDecoder.sbeBlockLength(), 304, buffer, messageHeaderDecoder);
        if (-1 == footerOffset) {
            throw new IllegalStateException("failed to find NodeStateFooter entry, file corrupt?");
        }
        int candidateTermOffset = NodeStateFile.scanForMessageTypeOffset(nodeStateHeaderDecoder.sbeBlockLength(), 301, buffer, messageHeaderDecoder);
        if (-1 == candidateTermOffset) {
            throw new IllegalStateException("failed to find CandidateTerm entry");
        }
        candidateTermDecoder.wrapAndApplyHeader(buffer, candidateTermOffset, messageHeaderDecoder);
        int clusterMembersOffset = NodeStateFile.scanForMessageTypeOffset(nodeStateHeaderDecoder.sbeBlockLength(), 303, buffer, messageHeaderDecoder);
        if (-1 == clusterMembersOffset) {
            throw new IllegalStateException("failed to find ClusterMembers entry");
        }
        clusterMembersDecoder.wrapAndApplyHeader(buffer, clusterMembersOffset, messageHeaderDecoder);
    }

    private static void initialiseDecodersOnCreation(MutableDirectBuffer buffer, NodeStateHeaderDecoder nodeStateHeaderDecoder, MessageHeaderDecoder messageHeaderDecoder, CandidateTermDecoder candidateTermDecoder, ClusterMembersDecoder clusterMembersDecoder) {
        MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
        nodeStateHeaderDecoder.wrap(buffer, 0, 8, 10);
        new NodeStateHeaderEncoder().wrap(buffer, 0).version(ClusterMarkFile.SEMANTIC_VERSION);
        int candidateTermFrameOffset = 8;
        NodeStateFile.verifyAlignment(8);
        CandidateTermEncoder candidateTermEncoder = new CandidateTermEncoder();
        candidateTermEncoder.wrapAndApplyHeader(buffer, 8, messageHeaderEncoder);
        candidateTermDecoder.wrapAndApplyHeader(buffer, 8, messageHeaderDecoder);
        candidateTermEncoder.logPosition(-1L).timestamp(-1L).candidateTermId(-1L);
        messageHeaderEncoder.frameLength(16 + candidateTermEncoder.encodedLength());
        int clusterMembersFrameOffset = 8 + BitUtil.align(messageHeaderDecoder.frameLength(), 8);
        NodeStateFile.verifyAlignment(8);
        ClusterMembersEncoder clusterMembersEncoder = new ClusterMembersEncoder();
        clusterMembersEncoder.wrapAndApplyHeader(buffer, clusterMembersFrameOffset, messageHeaderEncoder);
        clusterMembersDecoder.wrapAndApplyHeader(buffer, clusterMembersFrameOffset, messageHeaderDecoder);
        clusterMembersEncoder.leadershipTermId(-1L).memberId(-1).highMemberId(-1).clusterMembers("");
        messageHeaderEncoder.frameLength(16 + clusterMembersEncoder.encodedLength());
        int footerOffset = clusterMembersFrameOffset + BitUtil.align(messageHeaderDecoder.frameLength(), 8);
        NodeStateFooterEncoder nodeStateFooterEncoder = new NodeStateFooterEncoder();
        nodeStateFooterEncoder.wrapAndApplyHeader(buffer, footerOffset, messageHeaderEncoder);
        messageHeaderEncoder.frameLength(16 + nodeStateFooterEncoder.encodedLength());
    }

    @Override
    public void close() {
        IoUtil.unmap(this.mappedFile);
    }

    public void updateCandidateTermId(long candidateTermId, long logPosition, long timestampMs) {
        this.buffer.putLong(this.candidateTermDecoder.offset() + CandidateTermDecoder.logPositionEncodingOffset(), logPosition);
        this.buffer.putLong(this.candidateTermDecoder.offset() + CandidateTermDecoder.timestampEncodingOffset(), timestampMs);
        this.buffer.putLongVolatile(this.candidateTermIdOffset, candidateTermId);
        this.syncFile(this.mappedFile);
    }

    public long proposeMaxCandidateTermId(long candidateTermId, long logPosition, long timestampMs) {
        long existingCandidateTermId = this.candidateTerm.candidateTermId();
        if (candidateTermId > existingCandidateTermId) {
            this.updateCandidateTermId(candidateTermId, logPosition, timestampMs);
            return candidateTermId;
        }
        return existingCandidateTermId;
    }

    public CandidateTerm candidateTerm() {
        return this.candidateTerm;
    }

    public ClusterMembers clusterMembers() {
        if (-1L == this.clusterMembersDecoder.leadershipTermId()) {
            return null;
        }
        return this.clusterMembers;
    }

    public void updateClusterMembers(long leadershipTermId, int memberId, int highMemberId, String clusterMembers) {
        MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
        ClusterMembersEncoder clusterMembersEncoder = new ClusterMembersEncoder();
        ExpandableArrayBuffer tempBuffer = new ExpandableArrayBuffer(128);
        clusterMembersEncoder.wrapAndApplyHeader(tempBuffer, 0, messageHeaderEncoder);
        clusterMembersEncoder.leadershipTermId(leadershipTermId).memberId(memberId).highMemberId(highMemberId).clusterMembers(clusterMembers);
        int newFrameLength = messageHeaderEncoder.encodedLength() + clusterMembersEncoder.encodedLength();
        messageHeaderEncoder.frameLength(newFrameLength);
        int clusterMembersOffset = this.clusterMembersDecoder.offset();
        this.insertRecord(tempBuffer, clusterMembersOffset, newFrameLength);
    }

    private void insertRecord(MutableDirectBuffer record, int recordOffset, int recordLength) {
        int frameOffset = recordOffset - 16;
        this.messageHeaderDecoder.wrap(this.buffer, frameOffset);
        int existingFrameLengthAligned = BitUtil.align(this.messageHeaderDecoder.frameLength(), 8);
        int nextRecordOffset = frameOffset + existingFrameLengthAligned;
        int amountToMoveTrailingRecords = BitUtil.align(recordLength, 8) - existingFrameLengthAligned;
        int newNextRecordOffset = nextRecordOffset + amountToMoveTrailingRecords;
        int footerOffset = NodeStateFile.scanForMessageTypeOffset(this.nodeStateHeaderDecoder.encodedLength(), 304, this.buffer, this.messageHeaderDecoder);
        if (-1 == footerOffset) {
            throw new IllegalStateException("failed to find footer, file corrupt?");
        }
        int footerEndOffset = footerOffset + 16 + 0;
        int lengthOfTrailingRecords = footerEndOffset - nextRecordOffset;
        NodeStateFile.moveTrailingRecords(this.buffer, nextRecordOffset, lengthOfTrailingRecords, newNextRecordOffset);
        this.buffer.putBytes(frameOffset, record, 0, recordLength);
        this.loadDecodersAndOffsets(this.buffer);
        this.syncFile(this.mappedFile);
    }

    private void loadDecodersAndOffsets(UnsafeBuffer buffer) {
        NodeStateFile.loadInitialState(buffer, this.nodeStateHeaderDecoder, this.candidateTermDecoder, this.clusterMembersDecoder, this.messageHeaderDecoder);
        this.candidateTermIdOffset = this.calculateAndVerifyCandidateTermIdOffset();
    }

    static void moveTrailingRecords(UnsafeBuffer buffer, int srcOffset, int length, int dstOffset) {
        block3: {
            block2: {
                NodeStateFile.verifyAlignment(length);
                if (dstOffset >= srcOffset) break block2;
                for (int i = 0; i < length; i += 8) {
                    buffer.putLong(dstOffset + i, buffer.getLong(srcOffset + i));
                }
                break block3;
            }
            if (srcOffset >= dstOffset) break block3;
            for (int i = length - 8; 0 <= i; i -= 8) {
                buffer.putLong(dstOffset + i, buffer.getLong(srcOffset + i));
            }
        }
    }

    private static int scanForMessageTypeOffset(int startPosition, int templateId, DirectBuffer buffer, MessageHeaderDecoder messageHeaderDecoder) {
        int messageLength;
        NodeStateFile.verifyAlignment(startPosition);
        for (int position = startPosition; position < buffer.capacity(); position += BitUtil.align(messageLength, 8)) {
            messageHeaderDecoder.wrap(buffer, position);
            messageLength = messageHeaderDecoder.frameLength();
            if (templateId == messageHeaderDecoder.templateId()) {
                return position;
            }
            if (304 == messageHeaderDecoder.templateId()) {
                return -1;
            }
            if (messageLength < 0) {
                throw new IllegalStateException("Message length < 0, file corrupt?");
            }
            if (0 != messageLength) continue;
            return -1;
        }
        return -1;
    }

    private void syncFile(MappedByteBuffer mappedFile) {
        if (0 < this.fileSyncLevel) {
            mappedFile.force();
        }
    }

    public final class ClusterMembers {
        public int memberId() {
            return NodeStateFile.this.clusterMembersDecoder.memberId();
        }

        public int highMemberId() {
            return NodeStateFile.this.clusterMembersDecoder.highMemberId();
        }

        public long leadershipTermId() {
            return NodeStateFile.this.clusterMembersDecoder.leadershipTermId();
        }

        public String clusterMembers() {
            return NodeStateFile.this.clusterMembersDecoder.clusterMembers();
        }
    }

    public final class CandidateTerm {
        private CandidateTerm() {
        }

        public long candidateTermId() {
            return NodeStateFile.this.buffer.getLongVolatile(NodeStateFile.this.candidateTermIdOffset);
        }

        public long timestamp() {
            return NodeStateFile.this.candidateTermDecoder.timestamp();
        }

        public long logPosition() {
            return NodeStateFile.this.candidateTermDecoder.logPosition();
        }
    }
}

