/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class PendingMessageTrackerDecoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 107;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.3";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final PendingMessageTrackerDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 107;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public PendingMessageTrackerDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public PendingMessageTrackerDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (107 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public PendingMessageTrackerDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int nextServiceSessionIdId() {
        return 1;
    }

    public static int nextServiceSessionIdSinceVersion() {
        return 0;
    }

    public static int nextServiceSessionIdEncodingOffset() {
        return 0;
    }

    public static int nextServiceSessionIdEncodingLength() {
        return 8;
    }

    public static String nextServiceSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long nextServiceSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long nextServiceSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long nextServiceSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long nextServiceSessionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int logServiceSessionIdId() {
        return 2;
    }

    public static int logServiceSessionIdSinceVersion() {
        return 0;
    }

    public static int logServiceSessionIdEncodingOffset() {
        return 8;
    }

    public static int logServiceSessionIdEncodingLength() {
        return 8;
    }

    public static String logServiceSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logServiceSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logServiceSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logServiceSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logServiceSessionId() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int pendingMessageCapacityId() {
        return 3;
    }

    public static int pendingMessageCapacitySinceVersion() {
        return 0;
    }

    public static int pendingMessageCapacityEncodingOffset() {
        return 16;
    }

    public static int pendingMessageCapacityEncodingLength() {
        return 4;
    }

    public static String pendingMessageCapacityMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int pendingMessageCapacityNullValue() {
        return 0;
    }

    public static int pendingMessageCapacityMinValue() {
        return -2147483647;
    }

    public static int pendingMessageCapacityMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int pendingMessageCapacity() {
        return this.buffer.getInt(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int serviceIdId() {
        return 4;
    }

    public static int serviceIdSinceVersion() {
        return 0;
    }

    public static int serviceIdEncodingOffset() {
        return 20;
    }

    public static int serviceIdEncodingLength() {
        return 4;
    }

    public static String serviceIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int serviceIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int serviceIdMinValue() {
        return -2147483647;
    }

    public static int serviceIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int serviceId() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        PendingMessageTrackerDecoder decoder = new PendingMessageTrackerDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[PendingMessageTracker](sbeTemplateId=");
        builder.append(107);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 10) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(10);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 24) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(24);
        builder.append("):");
        builder.append("nextServiceSessionId=");
        builder.append(this.nextServiceSessionId());
        builder.append('|');
        builder.append("logServiceSessionId=");
        builder.append(this.logServiceSessionId());
        builder.append('|');
        builder.append("pendingMessageCapacity=");
        builder.append(this.pendingMessageCapacity());
        builder.append('|');
        builder.append("serviceId=");
        builder.append(this.serviceId());
        this.limit(originalLimit);
        return builder;
    }

    public PendingMessageTrackerDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

