/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.SessionOpenEventDecoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class SessionOpenEventEncoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 21;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.3";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SessionOpenEventEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 21;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SessionOpenEventEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 36);
        return this;
    }

    public SessionOpenEventEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(36).templateId(21).schemaId(111).version(10);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int leadershipTermIdId() {
        return 1;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionOpenEventEncoder leadershipTermId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionOpenEventEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int clusterSessionIdId() {
        return 3;
    }

    public static int clusterSessionIdSinceVersion() {
        return 0;
    }

    public static int clusterSessionIdEncodingOffset() {
        return 16;
    }

    public static int clusterSessionIdEncodingLength() {
        return 8;
    }

    public static String clusterSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long clusterSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long clusterSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long clusterSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionOpenEventEncoder clusterSessionId(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int timestampId() {
        return 4;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 24;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionOpenEventEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int responseStreamIdId() {
        return 6;
    }

    public static int responseStreamIdSinceVersion() {
        return 0;
    }

    public static int responseStreamIdEncodingOffset() {
        return 32;
    }

    public static int responseStreamIdEncodingLength() {
        return 4;
    }

    public static String responseStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int responseStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int responseStreamIdMinValue() {
        return -2147483647;
    }

    public static int responseStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public SessionOpenEventEncoder responseStreamId(int value) {
        this.buffer.putInt(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int responseChannelId() {
        return 7;
    }

    public static String responseChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String responseChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int responseChannelHeaderLength() {
        return 4;
    }

    public SessionOpenEventEncoder putResponseChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SessionOpenEventEncoder putResponseChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SessionOpenEventEncoder responseChannel(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public SessionOpenEventEncoder responseChannel(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int encodedPrincipalId() {
        return 8;
    }

    public static String encodedPrincipalMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int encodedPrincipalHeaderLength() {
        return 4;
    }

    public SessionOpenEventEncoder putEncodedPrincipal(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SessionOpenEventEncoder putEncodedPrincipal(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SessionOpenEventDecoder decoder = new SessionOpenEventDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 36, 10);
        return decoder.appendTo(builder);
    }
}

