/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs.node;

import io.aeron.cluster.codecs.node.MessageHeaderDecoder;
import io.aeron.cluster.codecs.node.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class NodeStateHeaderDecoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 300;
    public static final int SCHEMA_ID = 112;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.3";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NodeStateHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 300;
    }

    public int sbeSchemaId() {
        return 112;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public NodeStateHeaderDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public NodeStateHeaderDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (300 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 16, headerDecoder.blockLength(), headerDecoder.version());
    }

    public NodeStateHeaderDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int versionId() {
        return 1;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 0;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int version() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int paddingId() {
        return 2;
    }

    public static int paddingSinceVersion() {
        return 0;
    }

    public static int paddingEncodingOffset() {
        return 4;
    }

    public static int paddingEncodingLength() {
        return 4;
    }

    public static String paddingMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int paddingNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int paddingMinValue() {
        return -2147483647;
    }

    public static int paddingMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int padding() {
        return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        NodeStateHeaderDecoder decoder = new NodeStateHeaderDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[nodeStateHeader](sbeTemplateId=");
        builder.append(300);
        builder.append("|sbeSchemaId=");
        builder.append(112);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 10) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(10);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 8) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(8);
        builder.append("):");
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("padding=");
        builder.append(this.padding());
        this.limit(originalLimit);
        return builder;
    }

    public NodeStateHeaderDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

