/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PublicationParams;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.UntetheredSubscription;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferUnblocker;
import java.util.ArrayList;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public final class IpcPublication
implements DriverManagedResource,
Subscribable {
    private static final ReadablePosition[] EMPTY_POSITIONS = new ReadablePosition[0];
    private final long registrationId;
    private final long tag;
    private final long unblockTimeoutNs;
    private final long untetheredWindowLimitTimeoutNs;
    private final long untetheredRestingTimeoutNs;
    private final String channel;
    private final int sessionId;
    private final int streamId;
    private final int startingTermId;
    private final int startingTermOffset;
    private final int positionBitsToShift;
    private final int termBufferLength;
    private final int termWindowLength;
    private final int initialTermId;
    private final int tripGain;
    private long tripLimit;
    private long consumerPosition;
    private long lastConsumerPosition;
    private long timeOfLastConsumerPositionUpdateNs;
    private long cleanPosition;
    private int refCount = 0;
    private boolean reachedEndOfLife = false;
    private final boolean isExclusive;
    private State state = State.ACTIVE;
    private final UnsafeBuffer[] termBuffers;
    private final Position publisherPos;
    private final Position publisherLimit;
    private final UnsafeBuffer metaDataBuffer;
    private ReadablePosition[] subscriberPositions = EMPTY_POSITIONS;
    private final ArrayList<UntetheredSubscription> untetheredSubscriptions = new ArrayList();
    private final RawLog rawLog;
    private final AtomicCounter unblockedPublications;
    private final ErrorHandler errorHandler;

    IpcPublication(long registrationId, String channel, MediaDriver.Context ctx, long tag, int sessionId, int streamId, Position publisherPos, Position publisherLimit, RawLog rawLog, int termWindowLength, boolean isExclusive, PublicationParams params) {
        int termLength;
        this.registrationId = registrationId;
        this.channel = channel;
        this.tag = tag;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.isExclusive = isExclusive;
        this.termBuffers = rawLog.termBuffers();
        this.initialTermId = LogBufferDescriptor.initialTermId(rawLog.metaData());
        this.startingTermId = params.hasPosition ? params.termId : this.initialTermId;
        this.startingTermOffset = params.hasPosition ? params.termOffset : 0;
        this.errorHandler = ctx.errorHandler();
        this.termBufferLength = termLength = rawLog.termLength();
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        this.termWindowLength = termWindowLength;
        this.tripGain = termWindowLength >> 3;
        this.publisherPos = publisherPos;
        this.publisherLimit = publisherLimit;
        this.rawLog = rawLog;
        this.unblockTimeoutNs = ctx.publicationUnblockTimeoutNs();
        this.untetheredWindowLimitTimeoutNs = ctx.untetheredWindowLimitTimeoutNs();
        this.untetheredRestingTimeoutNs = ctx.untetheredRestingTimeoutNs();
        this.unblockedPublications = ctx.systemCounters().get(SystemCounterDescriptor.UNBLOCKED_PUBLICATIONS);
        this.metaDataBuffer = rawLog.metaData();
        this.lastConsumerPosition = this.consumerPosition = this.producerPosition();
        this.cleanPosition = this.consumerPosition;
        this.timeOfLastConsumerPositionUpdateNs = ctx.cachedNanoClock().nanoTime();
    }

    public String channel() {
        return this.channel;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    @Override
    public long subscribableRegistrationId() {
        return this.registrationId;
    }

    long registrationId() {
        return this.registrationId;
    }

    long tag() {
        return this.tag;
    }

    boolean isExclusive() {
        return this.isExclusive;
    }

    int initialTermId() {
        return this.initialTermId;
    }

    int startingTermId() {
        return this.startingTermId;
    }

    int startingTermOffset() {
        return this.startingTermOffset;
    }

    RawLog rawLog() {
        return this.rawLog;
    }

    int publisherLimitId() {
        return this.publisherLimit.id();
    }

    @Override
    public boolean free() {
        return this.rawLog.free();
    }

    @Override
    public void close() {
        CloseHelper.close(this.errorHandler, this.publisherPos);
        CloseHelper.close(this.errorHandler, this.publisherLimit);
        CloseHelper.closeAll(this.errorHandler, (AutoCloseable[])this.subscriberPositions);
        int size = this.untetheredSubscriptions.size();
        for (int i = 0; i < size; ++i) {
            UntetheredSubscription untetheredSubscription = this.untetheredSubscriptions.get(i);
            if (UntetheredSubscription.State.RESTING != untetheredSubscription.state) continue;
            CloseHelper.close(this.errorHandler, untetheredSubscription.position);
        }
    }

    @Override
    public void addSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition, long nowNs) {
        this.subscriberPositions = ArrayUtil.add(this.subscriberPositions, subscriberPosition);
        if (!subscriptionLink.isTether()) {
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriptionLink, subscriberPosition, nowNs));
        }
        LogBufferDescriptor.isConnected(this.metaDataBuffer, true);
    }

    @Override
    public void removeSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition) {
        this.updatePublisherLimit();
        this.subscriberPositions = ArrayUtil.remove(this.subscriberPositions, subscriberPosition);
        subscriberPosition.close();
        if (this.subscriberPositions.length == 0) {
            LogBufferDescriptor.isConnected(this.metaDataBuffer, false);
        }
        if (!subscriptionLink.isTether()) {
            int lastIndex;
            for (int i = lastIndex = this.untetheredSubscriptions.size() - 1; i >= 0; --i) {
                if (this.untetheredSubscriptions.get((int)i).subscriptionLink != subscriptionLink) continue;
                ArrayListUtil.fastUnorderedRemove(this.untetheredSubscriptions, i, lastIndex);
                break;
            }
        }
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        switch (this.state) {
            case ACTIVE: {
                long producerPosition = this.producerPosition();
                this.publisherPos.setOrdered(producerPosition);
                if (!this.isExclusive) {
                    this.checkForBlockedPublisher(producerPosition, timeNs);
                }
                this.checkUntetheredSubscriptions(timeNs, conductor);
                break;
            }
            case DRAINING: {
                long producerPosition = this.producerPosition();
                this.publisherPos.setOrdered(producerPosition);
                if (this.isDrained(producerPosition)) {
                    conductor.transitionToLinger(this);
                    this.state = State.LINGER;
                    break;
                }
                if (!LogBufferUnblocker.unblock(this.termBuffers, this.metaDataBuffer, this.consumerPosition, this.termBufferLength)) break;
                this.unblockedPublications.incrementOrdered();
                break;
            }
            case LINGER: {
                conductor.cleanupIpcPublication(this);
                this.reachedEndOfLife = true;
                this.state = State.DONE;
                break;
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    void incRef() {
        ++this.refCount;
    }

    void decRef() {
        if (0 == --this.refCount) {
            long producerPosition = this.producerPosition();
            this.publisherLimit.setOrdered(producerPosition);
            LogBufferDescriptor.endOfStreamPosition(this.metaDataBuffer, producerPosition);
            this.state = State.DRAINING;
        }
    }

    int updatePublisherLimit() {
        int workCount = 0;
        if (State.ACTIVE == this.state) {
            if (this.subscriberPositions.length > 0) {
                long proposedLimit;
                long minSubscriberPosition = Long.MAX_VALUE;
                long maxSubscriberPosition = this.consumerPosition;
                for (ReadablePosition subscriberPosition : this.subscriberPositions) {
                    long position = subscriberPosition.getVolatile();
                    minSubscriberPosition = Math.min(minSubscriberPosition, position);
                    maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
                }
                if (maxSubscriberPosition > this.consumerPosition) {
                    this.consumerPosition = maxSubscriberPosition;
                }
                if ((proposedLimit = minSubscriberPosition + (long)this.termWindowLength) > this.tripLimit) {
                    this.cleanBufferTo(minSubscriberPosition);
                    this.publisherLimit.setOrdered(proposedLimit);
                    this.tripLimit = proposedLimit + (long)this.tripGain;
                    workCount = 1;
                }
            } else if (this.publisherLimit.get() > this.consumerPosition) {
                this.tripLimit = this.consumerPosition;
                this.publisherLimit.setOrdered(this.consumerPosition);
                this.cleanBufferTo(this.consumerPosition);
            }
        }
        return workCount;
    }

    long joinPosition() {
        long position = this.consumerPosition;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            position = Math.min(subscriberPosition.getVolatile(), position);
        }
        return position;
    }

    long producerPosition() {
        long rawTail = LogBufferDescriptor.rawTailVolatile(this.metaDataBuffer);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, this.termBufferLength);
        return LogBufferDescriptor.computePosition(LogBufferDescriptor.termId(rawTail), termOffset, this.positionBitsToShift, this.initialTermId);
    }

    long consumerPosition() {
        return this.consumerPosition;
    }

    State state() {
        return this.state;
    }

    boolean isAcceptingSubscriptions() {
        return State.ACTIVE == this.state || State.DRAINING == this.state && !this.isDrained(this.producerPosition());
    }

    private void checkUntetheredSubscriptions(long nowNs, DriverConductor conductor) {
        int lastIndex;
        long untetheredWindowLimit = this.consumerPosition - (long)this.termWindowLength + (long)(this.termWindowLength >> 2);
        for (int i = lastIndex = this.untetheredSubscriptions.size() - 1; i >= 0; --i) {
            UntetheredSubscription untethered = this.untetheredSubscriptions.get(i);
            if (UntetheredSubscription.State.ACTIVE == untethered.state) {
                if (untethered.position.getVolatile() > untetheredWindowLimit) {
                    untethered.timeOfLastUpdateNs = nowNs;
                    continue;
                }
                if (untethered.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - nowNs > 0L) continue;
                conductor.notifyUnavailableImageLink(this.registrationId, untethered.subscriptionLink);
                untethered.state(UntetheredSubscription.State.LINGER, nowNs, this.streamId, this.sessionId);
                continue;
            }
            if (UntetheredSubscription.State.LINGER == untethered.state) {
                if (untethered.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - nowNs > 0L) continue;
                this.subscriberPositions = ArrayUtil.remove(this.subscriberPositions, untethered.position);
                untethered.state(UntetheredSubscription.State.RESTING, nowNs, this.streamId, this.sessionId);
                continue;
            }
            if (UntetheredSubscription.State.RESTING != untethered.state || untethered.timeOfLastUpdateNs + this.untetheredRestingTimeoutNs - nowNs > 0L) continue;
            this.subscriberPositions = ArrayUtil.add(this.subscriberPositions, untethered.position);
            conductor.notifyAvailableImageLink(this.registrationId, this.sessionId, untethered.subscriptionLink, untethered.position.id(), this.joinPosition(), this.rawLog.fileName(), "aeron:ipc");
            untethered.state(UntetheredSubscription.State.ACTIVE, nowNs, this.streamId, this.sessionId);
            LogBufferDescriptor.isConnected(this.metaDataBuffer, true);
        }
    }

    private boolean isDrained(long producerPosition) {
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            if (subscriberPosition.getVolatile() >= producerPosition) continue;
            return false;
        }
        return true;
    }

    private void checkForBlockedPublisher(long producerPosition, long timeNs) {
        long consumerPosition = this.consumerPosition;
        if (consumerPosition == this.lastConsumerPosition && this.isPossiblyBlocked(producerPosition, consumerPosition)) {
            if (this.timeOfLastConsumerPositionUpdateNs + this.unblockTimeoutNs - timeNs < 0L && LogBufferUnblocker.unblock(this.termBuffers, this.metaDataBuffer, consumerPosition, this.termBufferLength)) {
                this.unblockedPublications.incrementOrdered();
            }
        } else {
            this.timeOfLastConsumerPositionUpdateNs = timeNs;
            this.lastConsumerPosition = consumerPosition;
        }
    }

    private boolean isPossiblyBlocked(long producerPosition, long consumerPosition) {
        int expectedTermCount;
        int producerTermCount = LogBufferDescriptor.activeTermCount(this.metaDataBuffer);
        if (producerTermCount != (expectedTermCount = (int)(consumerPosition >> this.positionBitsToShift))) {
            return true;
        }
        return producerPosition > consumerPosition;
    }

    private void cleanBufferTo(long position) {
        long cleanPosition = this.cleanPosition;
        if (position > cleanPosition) {
            UnsafeBuffer dirtyTerm = this.termBuffers[LogBufferDescriptor.indexByPosition(cleanPosition, this.positionBitsToShift)];
            int bytesForCleaning = (int)(position - cleanPosition);
            int bufferCapacity = this.termBufferLength;
            int termOffset = (int)cleanPosition & bufferCapacity - 1;
            int length = Math.min(bytesForCleaning, bufferCapacity - termOffset);
            dirtyTerm.setMemory(termOffset + 8, length - 8, (byte)0);
            dirtyTerm.putLongOrdered(termOffset, 0L);
            this.cleanPosition = cleanPosition + (long)length;
        }
    }

    static enum State {
        ACTIVE,
        DRAINING,
        LINGER,
        DONE;

    }
}

