/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransportRhsPadding;
import io.aeron.driver.media.UdpChannel;
import io.aeron.status.LocalSocketAddressStatus;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import org.agrona.CloseHelper;
import org.agrona.concurrent.status.AtomicCounter;

public final class ReceiveDestinationTransport
extends ReceiveDestinationTransportRhsPadding {
    private InetSocketAddress currentControlAddress;
    private final AtomicCounter localSocketAddressIndicator;

    public ReceiveDestinationTransport(UdpChannel udpChannel, MediaDriver.Context context, AtomicCounter localSocketAddressIndicator, ReceiveChannelEndpoint receiveChannelEndpoint) {
        super(udpChannel, udpChannel.remoteData(), udpChannel.remoteData(), null, context, receiveChannelEndpoint.socketRcvbufLength(), receiveChannelEndpoint.socketSndbufLength());
        this.timeOfLastActivityNs = context.receiverCachedNanoClock().nanoTime();
        this.currentControlAddress = udpChannel.hasExplicitControl() ? udpChannel.localControl() : null;
        this.localSocketAddressIndicator = localSocketAddressIndicator;
    }

    public void openChannel(DriverConductorProxy conductorProxy, AtomicCounter statusIndicator) {
        if (conductorProxy.notConcurrent()) {
            this.openDatagramChannel(statusIndicator);
        } else {
            try {
                this.openDatagramChannel(statusIndicator);
            }
            catch (Exception ex) {
                conductorProxy.channelEndpointError(statusIndicator.id(), ex);
                throw ex;
            }
        }
        LocalSocketAddressStatus.updateBindAddress(this.localSocketAddressIndicator, this.bindAddressAndPort(), this.context.countersMetaDataBuffer());
        this.localSocketAddressIndicator.setOrdered(1L);
    }

    public void closeTransport() {
        super.close();
    }

    public void closeIndicators() {
        CloseHelper.close(this.localSocketAddressIndicator);
    }

    @Override
    public void close() {
        super.close();
    }

    public boolean hasExplicitControl() {
        return this.udpChannel.hasExplicitControl();
    }

    public InetSocketAddress explicitControlAddress() {
        return this.udpChannel.hasExplicitControl() ? this.currentControlAddress : null;
    }

    public void selectionKey(SelectionKey key) {
        this.selectionKey = key;
    }

    public void timeOfLastActivityNs(long nowNs) {
        this.timeOfLastActivityNs = nowNs;
    }

    public long timeOfLastActivityNs() {
        return this.timeOfLastActivityNs;
    }

    @Override
    public UdpChannel udpChannel() {
        return this.udpChannel;
    }

    public void currentControlAddress(InetSocketAddress newAddress) {
        this.currentControlAddress = newAddress;
    }

    public InetSocketAddress currentControlAddress() {
        return this.currentControlAddress;
    }
}

