/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.samples.SamplesUtil;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.agrona.concurrent.status.CountersReader;

public class BacklogStat {
    private final CountersReader counters;

    public static void main(String[] args) {
        CountersReader counters = SamplesUtil.mapCounters();
        BacklogStat backlogStat = new BacklogStat(counters);
        backlogStat.print(System.out);
    }

    public BacklogStat(CountersReader counters) {
        this.counters = counters;
    }

    public Map<StreamCompositeKey, StreamBacklog> snapshot() {
        HashMap<StreamCompositeKey, StreamBacklog> streams = new HashMap<StreamCompositeKey, StreamBacklog>();
        this.counters.forEach((counterId, typeId, keyBuffer, label) -> {
            if (typeId >= 1 && typeId <= 5 || typeId == 9 || typeId == 10 || typeId == 12) {
                StreamCompositeKey key = new StreamCompositeKey(keyBuffer.getInt(8), keyBuffer.getInt(12), keyBuffer.getStringAscii(16));
                StreamBacklog streamBacklog = streams.computeIfAbsent(key, ignore -> new StreamBacklog());
                long registrationId = keyBuffer.getLong(0);
                long value = this.counters.getCounterValue(counterId);
                switch (typeId) {
                    case 1: {
                        streamBacklog.createPublisherIfAbsent().registrationId(registrationId);
                        streamBacklog.createPublisherIfAbsent().limit(value);
                        break;
                    }
                    case 12: {
                        streamBacklog.createPublisherIfAbsent().registrationId(registrationId);
                        streamBacklog.createPublisherIfAbsent().position(value);
                        break;
                    }
                    case 2: {
                        streamBacklog.createSenderIfAbsent().registrationId(registrationId);
                        streamBacklog.createSenderIfAbsent().position(value);
                        break;
                    }
                    case 9: {
                        streamBacklog.createSenderIfAbsent().registrationId(registrationId);
                        streamBacklog.createSenderIfAbsent().limit(value);
                        break;
                    }
                    case 3: {
                        streamBacklog.createReceiverIfAbsent().registrationId(registrationId);
                        streamBacklog.createReceiverIfAbsent().highWaterMark(value);
                        break;
                    }
                    case 5: {
                        streamBacklog.createReceiverIfAbsent().registrationId(registrationId);
                        streamBacklog.createReceiverIfAbsent().position(value);
                        break;
                    }
                    case 4: {
                        streamBacklog.subscriberBacklogs().put(registrationId, new Subscriber(value));
                    }
                }
            }
        });
        return streams;
    }

    public void print(PrintStream out) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<StreamCompositeKey, StreamBacklog> entry : this.snapshot().entrySet()) {
            builder.setLength(0);
            StreamCompositeKey key = entry.getKey();
            builder.append("sessionId=").append(key.sessionId()).append(" streamId=").append(key.streamId()).append(" channel=").append(key.channel()).append(" : ");
            StreamBacklog streamBacklog = entry.getValue();
            if (streamBacklog.publisher() != null) {
                builder.append("\n\u250c\u2500for publisher ").append(streamBacklog.publisher().registrationId()).append(" the last sampled position is ").append(streamBacklog.publisher().position()).append(" (~").append(streamBacklog.publisher().remainingWindow()).append(" bytes before back-pressure)");
                Sender sender = streamBacklog.sender();
                if (sender != null) {
                    long senderBacklog = sender.backlog(streamBacklog.publisher().position());
                    builder.append("\n\u2514\u2500sender ").append(sender.registrationId());
                    if (senderBacklog >= 0L) {
                        builder.append(" has to send ").append(senderBacklog).append(" bytes");
                    } else {
                        builder.append(" is at position ").append(sender.position());
                    }
                    builder.append(" (").append(sender.window()).append(" bytes remaining in the sender window)");
                } else {
                    builder.append("\n\u2514\u2500no sender");
                }
            }
            if (streamBacklog.receiver() != null) {
                builder.append("\n\u250c\u2500receiver ").append(streamBacklog.receiver().registrationId()).append(" is at position ").append(streamBacklog.receiver().position());
                Iterator<Map.Entry<Long, Subscriber>> subscriberIterator = streamBacklog.subscriberBacklogs().entrySet().iterator();
                while (subscriberIterator.hasNext()) {
                    Map.Entry<Long, Subscriber> subscriber = subscriberIterator.next();
                    builder.append(subscriberIterator.hasNext() ? "\n\u251c" : "\n\u2514").append("\u2500subscriber ").append(subscriber.getKey()).append(" has ").append(subscriber.getValue().backlog(streamBacklog.receiver().highWaterMark())).append(" backlog bytes");
                }
            }
            builder.append('\n');
            out.println(builder);
        }
    }

    static class Subscriber {
        private final long position;

        Subscriber(long position) {
            this.position = position;
        }

        long backlog(long receiverHwm) {
            return receiverHwm - this.position;
        }
    }

    static class Receiver
    extends AeronEntity {
        private long highWaterMark;
        private long position;

        Receiver() {
        }

        void highWaterMark(long highWaterMark) {
            this.highWaterMark = highWaterMark;
        }

        long highWaterMark() {
            return this.highWaterMark;
        }

        void position(long position) {
            this.position = position;
        }

        long position() {
            return this.position;
        }
    }

    static class Sender
    extends AeronEntity {
        private long position;
        private long limit;

        Sender() {
        }

        void position(long publisherPosition) {
            this.position = publisherPosition;
        }

        long position() {
            return this.position;
        }

        void limit(long limit) {
            this.limit = limit;
        }

        long backlog(long publisherPosition) {
            return publisherPosition - this.position;
        }

        long window() {
            return this.limit - this.position;
        }
    }

    static class Publisher
    extends AeronEntity {
        private long limit;
        private long position;

        Publisher() {
        }

        void limit(long limit) {
            this.limit = limit;
        }

        void position(long position) {
            this.position = position;
        }

        long position() {
            return this.position;
        }

        long remainingWindow() {
            return this.limit - this.position;
        }
    }

    static class AeronEntity {
        private long registrationId;

        AeronEntity() {
        }

        long registrationId() {
            return this.registrationId;
        }

        void registrationId(long registrationId) {
            this.registrationId = registrationId;
        }
    }

    public static final class StreamBacklog {
        private Publisher publisher;
        private Sender sender;
        private Receiver receiver;
        private final SortedMap<Long, Subscriber> subscriberBacklogs = new TreeMap<Long, Subscriber>();

        Publisher publisher() {
            return this.publisher;
        }

        Sender sender() {
            return this.sender;
        }

        Receiver receiver() {
            return this.receiver;
        }

        Map<Long, Subscriber> subscriberBacklogs() {
            return this.subscriberBacklogs;
        }

        Publisher createPublisherIfAbsent() {
            return this.publisher == null ? (this.publisher = new Publisher()) : this.publisher;
        }

        Sender createSenderIfAbsent() {
            return this.sender == null ? (this.sender = new Sender()) : this.sender;
        }

        Receiver createReceiverIfAbsent() {
            return this.receiver == null ? (this.receiver = new Receiver()) : this.receiver;
        }
    }

    public static final class StreamCompositeKey {
        private final int sessionId;
        private final int streamId;
        private final String channel;

        public StreamCompositeKey(int sessionId, int streamId, String channel) {
            Objects.requireNonNull(channel, "channel cannot be null");
            this.sessionId = sessionId;
            this.streamId = streamId;
            this.channel = channel;
        }

        public int sessionId() {
            return this.sessionId;
        }

        public int streamId() {
            return this.streamId;
        }

        public String channel() {
            return this.channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StreamCompositeKey)) {
                return false;
            }
            StreamCompositeKey that = (StreamCompositeKey)o;
            return this.sessionId == that.sessionId && this.streamId == that.streamId && this.channel.equals(that.channel);
        }

        public int hashCode() {
            int result = this.sessionId;
            result = 31 * result + this.streamId;
            result = 31 * result + this.channel.hashCode();
            return result;
        }

        public String toString() {
            return "StreamCompositeKey{sessionId=" + this.sessionId + ", streamId=" + this.streamId + ", channel='" + this.channel + '\'' + '}';
        }
    }
}

