/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CommonContext;
import io.aeron.driver.reports.LossReportReader;
import io.aeron.driver.reports.LossReportUtil;
import io.aeron.samples.SamplesUtil;
import java.io.File;
import java.nio.MappedByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class LossStat {
    public static void main(String[] args) {
        String aeronDirectoryName = System.getProperty("aeron.dir", CommonContext.AERON_DIR_PROP_DEFAULT);
        File lossReportFile = LossReportUtil.file(aeronDirectoryName);
        if (!lossReportFile.exists()) {
            System.err.print("Loss report does not exist: " + lossReportFile);
            System.exit(1);
        }
        MappedByteBuffer mappedByteBuffer = SamplesUtil.mapExistingFileReadOnly(lossReportFile);
        UnsafeBuffer buffer = new UnsafeBuffer(mappedByteBuffer);
        System.out.println("#OBSERVATION_COUNT,TOTAL_BYTES_LOST,FIRST_OBSERVATION,LAST_OBSERVATION,SESSION_ID,STREAM_ID,CHANNEL,SOURCE");
        int entriesRead = LossReportReader.read(buffer, LossReportReader.defaultEntryConsumer(System.out));
        System.out.println(entriesRead + " loss entries");
    }
}

