/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import org.agrona.nio.NioSelectedKeySet;

public class Common {
    public static final int NUM_MESSAGES = 10000;
    public static final int PONG_PORT = 20123;
    public static final int PING_PORT = 20124;
    public static final String PING_DEST = System.getProperty("io.aeron.raw.ping.dest", "localhost");
    public static final String PONG_DEST = System.getProperty("io.aeron.raw.pong.dest", "localhost");
    static final Field SELECTED_KEYS_FIELD;
    static final Field PUBLIC_SELECTED_KEYS_FIELD;

    static void init(DatagramChannel channel) throws IOException {
        channel.configureBlocking(false);
        channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
    }

    static void init(DatagramChannel channel, InetSocketAddress sendAddress) throws IOException {
        channel.configureBlocking(false);
        channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        channel.connect(sendAddress);
    }

    static NioSelectedKeySet keySet(Selector selector) {
        NioSelectedKeySet tmpSet = null;
        if (null != PUBLIC_SELECTED_KEYS_FIELD) {
            try {
                tmpSet = new NioSelectedKeySet();
                SELECTED_KEYS_FIELD.set(selector, tmpSet);
                PUBLIC_SELECTED_KEYS_FIELD.set(selector, tmpSet);
            }
            catch (Exception ignore) {
                tmpSet = null;
            }
        }
        return tmpSet;
    }

    static {
        Field selectKeysField = null;
        Field publicSelectKeysField = null;
        try (Selector selector = Selector.open();){
            Class<?> clazz = Class.forName("sun.nio.ch.SelectorImpl", false, ClassLoader.getSystemClassLoader());
            if (clazz.isAssignableFrom(selector.getClass())) {
                selectKeysField = clazz.getDeclaredField("selectedKeys");
                selectKeysField.setAccessible(true);
                publicSelectKeysField = clazz.getDeclaredField("publicSelectedKeys");
                publicSelectKeysField.setAccessible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SELECTED_KEYS_FIELD = selectKeysField;
        PUBLIC_SELECTED_KEYS_FIELD = publicSelectKeysField;
    }
}

