/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.agrona.concurrent.SigInt;

public class ShutdownSignalBarrier {
    public static final String[] SIGNAL_NAMES = new String[]{"INT", "TERM"};
    private static final ArrayList<CountDownLatch> LATCHES = new ArrayList();
    private final CountDownLatch latch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShutdownSignalBarrier() {
        ArrayList<CountDownLatch> arrayList = LATCHES;
        synchronized (arrayList) {
            LATCHES.add(this.latch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal() {
        ArrayList<CountDownLatch> arrayList = LATCHES;
        synchronized (arrayList) {
            LATCHES.remove(this.latch);
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAll() {
        ArrayList<CountDownLatch> arrayList = LATCHES;
        synchronized (arrayList) {
            LATCHES.forEach(CountDownLatch::countDown);
            LATCHES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        ArrayList<CountDownLatch> arrayList = LATCHES;
        synchronized (arrayList) {
            LATCHES.remove(this.latch);
        }
    }

    public void await() {
        try {
            this.latch.await();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        for (String signalName : SIGNAL_NAMES) {
            SigInt.register(signalName, () -> LATCHES.forEach(CountDownLatch::countDown));
        }
    }
}

