/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.DirectBuffer;


/**
 * Used in the catalog to describe the recording descriptor entry which follows.
 */
@SuppressWarnings("all")
public final class RecordingDescriptorHeaderDecoder
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 21;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 8;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RecordingDescriptorHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public RecordingDescriptorHeaderDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public RecordingDescriptorHeaderDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public RecordingDescriptorHeaderDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int lengthId()
    {
        return 1;
    }

    public static int lengthSinceVersion()
    {
        return 0;
    }

    public static int lengthEncodingOffset()
    {
        return 0;
    }

    public static int lengthEncodingLength()
    {
        return 4;
    }

    public static String lengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int lengthNullValue()
    {
        return -2147483648;
    }

    public static int lengthMinValue()
    {
        return -2147483647;
    }

    public static int lengthMaxValue()
    {
        return 2147483647;
    }

    public int length()
    {
        return buffer.getInt(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int stateId()
    {
        return 2;
    }

    public static int stateSinceVersion()
    {
        return 0;
    }

    public static int stateEncodingOffset()
    {
        return 4;
    }

    public static int stateEncodingLength()
    {
        return 4;
    }

    public static String stateMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public int stateRaw()
    {
        return buffer.getInt(offset + 4, java.nio.ByteOrder.LITTLE_ENDIAN);
    }

    public RecordingState state()
    {
        return RecordingState.get(buffer.getInt(offset + 4, java.nio.ByteOrder.LITTLE_ENDIAN));
    }


    public static int checksumId()
    {
        return 4;
    }

    public static int checksumSinceVersion()
    {
        return 0;
    }

    public static int checksumEncodingOffset()
    {
        return 8;
    }

    public static int checksumEncodingLength()
    {
        return 4;
    }

    public static String checksumMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int checksumNullValue()
    {
        return -2147483648;
    }

    public static int checksumMinValue()
    {
        return -2147483647;
    }

    public static int checksumMaxValue()
    {
        return 2147483647;
    }

    public int checksum()
    {
        return buffer.getInt(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int reservedId()
    {
        return 3;
    }

    public static int reservedSinceVersion()
    {
        return 0;
    }

    public static int reservedEncodingOffset()
    {
        return 31;
    }

    public static int reservedEncodingLength()
    {
        return 1;
    }

    public static String reservedMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static byte reservedNullValue()
    {
        return (byte)-128;
    }

    public static byte reservedMinValue()
    {
        return (byte)-127;
    }

    public static byte reservedMaxValue()
    {
        return (byte)127;
    }

    public byte reserved()
    {
        return buffer.getByte(offset + 31);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final RecordingDescriptorHeaderDecoder decoder = new RecordingDescriptorHeaderDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[RecordingDescriptorHeader](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("length=");
        builder.append(this.length());
        builder.append('|');
        builder.append("state=");
        builder.append(this.state());
        builder.append('|');
        builder.append("checksum=");
        builder.append(this.checksum());
        builder.append('|');
        builder.append("reserved=");
        builder.append(this.reserved());

        limit(originalLimit);

        return builder;
    }
    
    public RecordingDescriptorHeaderDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
