/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;


/**
 * Used in the catalog to describe the recording descriptor entry which follows.
 */
@SuppressWarnings("all")
public final class RecordingDescriptorHeaderEncoder
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 21;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 8;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RecordingDescriptorHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public RecordingDescriptorHeaderEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public RecordingDescriptorHeaderEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int lengthId()
    {
        return 1;
    }

    public static int lengthSinceVersion()
    {
        return 0;
    }

    public static int lengthEncodingOffset()
    {
        return 0;
    }

    public static int lengthEncodingLength()
    {
        return 4;
    }

    public static String lengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int lengthNullValue()
    {
        return -2147483648;
    }

    public static int lengthMinValue()
    {
        return -2147483647;
    }

    public static int lengthMaxValue()
    {
        return 2147483647;
    }

    public RecordingDescriptorHeaderEncoder length(final int value)
    {
        buffer.putInt(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int stateId()
    {
        return 2;
    }

    public static int stateSinceVersion()
    {
        return 0;
    }

    public static int stateEncodingOffset()
    {
        return 4;
    }

    public static int stateEncodingLength()
    {
        return 4;
    }

    public static String stateMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public RecordingDescriptorHeaderEncoder state(final RecordingState value)
    {
        buffer.putInt(offset + 4, value.value(), java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int checksumId()
    {
        return 4;
    }

    public static int checksumSinceVersion()
    {
        return 0;
    }

    public static int checksumEncodingOffset()
    {
        return 8;
    }

    public static int checksumEncodingLength()
    {
        return 4;
    }

    public static String checksumMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int checksumNullValue()
    {
        return -2147483648;
    }

    public static int checksumMinValue()
    {
        return -2147483647;
    }

    public static int checksumMaxValue()
    {
        return 2147483647;
    }

    public RecordingDescriptorHeaderEncoder checksum(final int value)
    {
        buffer.putInt(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int reservedId()
    {
        return 3;
    }

    public static int reservedSinceVersion()
    {
        return 0;
    }

    public static int reservedEncodingOffset()
    {
        return 31;
    }

    public static int reservedEncodingLength()
    {
        return 1;
    }

    public static String reservedMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static byte reservedNullValue()
    {
        return (byte)-128;
    }

    public static byte reservedMinValue()
    {
        return (byte)-127;
    }

    public static byte reservedMaxValue()
    {
        return (byte)127;
    }

    public RecordingDescriptorHeaderEncoder reserved(final byte value)
    {
        buffer.putByte(offset + 31, value);
        return this;
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final RecordingDescriptorHeaderDecoder decoder = new RecordingDescriptorHeaderDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
